/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.wizard;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.search.ResourceSearchComposite;
import net.refractions.udig.catalog.ui.workflow.ResourceSearchState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ResourceSearchPage
extends WorkflowWizardPage
implements IPageChangedListener {
    ResourceSearchComposite search;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = event.getSelection();
            HashSet<IResolve> set = new HashSet<IResolve>();
            if (!sel.isEmpty() && sel instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)sel;
                for (Object item : selection) {
                    if (item instanceof IGeoResource) {
                        IGeoResource resource = (IGeoResource)item;
                        set.add((IResolve)resource);
                        continue;
                    }
                    if (item != ResourceSearchState.IMPORT_PLACEHOLDER) continue;
                    set.add(ResourceSearchState.IMPORT_PLACEHOLDER);
                }
            }
            ResourceSearchPage.this.getState().setSelected(set);
            ResourceSearchPage.this.getWizard().getContainer().updateButtons();
        }
    };

    public ResourceSearchPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ResourceSelectionPage_title);
        this.setMessage(Messages.ResourceSelectionPage_message);
        this.setDescription(Messages.ResourceSelectionPage_description);
        this.setImageDescriptor(CatalogUIPlugin.getDefault().getImageDescriptor("wizban/chooselayer_wiz.gif"));
    }

    @Override
    public ResourceSearchState getState() {
        return (ResourceSearchState)super.getState();
    }

    @Override
    public void setState(State state) {
        if (!(state instanceof ResourceSearchState)) {
            throw new IllegalArgumentException("ResourceSearchState required");
        }
        super.setState(state);
    }

    public void createControl(Composite parent) {
        this.search = new ResourceSearchComposite(parent, 0){

            @Override
            protected void reviewResults(List<IResolve> resolves) {
                resolves.add(ResourceSearchState.IMPORT_PLACEHOLDER);
            }
        };
        this.setControl((Control)this.search);
        ResourceSearchState state = this.getState();
        this.setInput(state);
    }

    @Override
    public void shown() {
        this.setInput(this.getState());
    }

    private void listen(boolean listen) {
        if (listen) {
            this.search.addSelectionChangedListener(this.listener);
        } else {
            this.search.removeSelectionChangedListener(this.listener);
        }
    }

    private void setInput(ResourceSearchState state) {
        try {
            this.listen(false);
            this.search.setSearchText(state.getSearch());
        }
        finally {
            this.listen(true);
        }
    }

    Button findButton(Control[] children, int id) {
        if ((Integer)this.getShell().getDefaultButton().getData() == id) {
            return this.getShell().getDefaultButton();
        }
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite;
            Button button;
            Button button2;
            Control child = controlArray[n2];
            if (child instanceof Button && (Integer)(button2 = (Button)child).getData() == id) {
                return button2;
            }
            if (child instanceof Composite && (button = this.findButton((composite = (Composite)child).getChildren(), id)) != null) {
                return button;
            }
            ++n2;
        }
        return null;
    }

    public void pageChanged(PageChangedEvent event) {
    }

    @Override
    public boolean canFlipToNextPage() {
        boolean more = super.canFlipToNextPage();
        Set<IResolve> selected = this.getState().getSelected();
        if (selected == null || selected.isEmpty()) {
            return false;
        }
        if (selected.contains(ResourceSearchState.IMPORT_PLACEHOLDER)) {
            return true;
        }
        return more;
    }
}

