/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.wizard.DataBaseConnInfo;
import net.refractions.udig.catalog.ui.wizard.DataStoreWizardPage;
import net.refractions.udig.ui.PlatformGIS;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class DataBaseRegistryWizardPage
extends DataStoreWizardPage
implements FocusListener,
ModifyListener,
SelectionListener {
    protected final DataBaseConnInfo currentDBCI = new DataBaseConnInfo("");
    protected final DataBaseConnInfo defaultDBCI = new DataBaseConnInfo("");
    protected final List<DataBaseConnInfo> storedDBCIList = new ArrayList<DataBaseConnInfo>();
    protected IDialogSettings settings;
    protected BasicDataSource dataSource = null;
    protected String settingsArrayName;
    protected Combo rcntComboWgt = null;
    protected Text hostTextWgt = null;
    protected Text portTextWgt = null;
    protected Text userTextWgt = null;
    protected Text passTextWgt = null;
    protected Combo dbComboWgt = null;
    protected Combo schemaComboWgt = null;
    protected Button lookupBtnWgt = null;
    protected Button connectBtnWgt = null;
    protected Button advancedBtnWgt = null;
    protected Group advancedGrp = null;
    private Widget wgtLostFocus = null;
    protected final List<String> dbExclusionList = new ArrayList<String>();
    protected final List<String> schemaExclusionList = new ArrayList<String>();

    public DataBaseRegistryWizardPage(String header) {
        super(header);
    }

    protected abstract boolean dbmsUsesSchema();

    protected boolean excludeDbFromUserChoices(String d) {
        return this.dbExclusionList.contains(d);
    }

    protected boolean excludeSchemaFromUserChoices(String s) {
        return this.schemaExclusionList.contains(s);
    }

    protected boolean couldLookup() {
        return this.currentDBCI.getHostString().length() > 0 && this.currentDBCI.getPortString().length() > 0 && this.currentDBCI.getUserString().length() > 0 && this.currentDBCI.getPassString().length() > 0 && this.currentDBCI.getDbString().length() > 0;
    }

    protected boolean couldConnect() {
        if (this.currentDBCI.getHostString().length() > 0 && this.currentDBCI.getPortString().length() > 0 && this.currentDBCI.getUserString().length() > 0 && this.currentDBCI.getPassString().length() > 0 && this.currentDBCI.getDbString().length() > 0) {
            if (!this.dbmsUsesSchema()) {
                return true;
            }
            return this.currentDBCI.getSchemaString().length() > 0;
        }
        return false;
    }

    protected void canNowLookup() {
        this.lookupBtnWgt.setEnabled(true);
    }

    protected void canNowConnect() {
        this.canNowLookup();
        this.connectBtnWgt.setEnabled(true);
    }

    protected void runInPage(final IRunnableWithProgress activity) {
        boolean guess = true;
        try {
            if (guess) {
                this.getContainer().run(false, true, activity);
            } else {
                this.getContainer().run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        PlatformGIS.runBlockingOperation((IRunnableWithProgress)activity, (IProgressMonitor)monitor);
                    }
                });
            }
        }
        catch (InvocationTargetException e2) {
            CatalogUIPlugin.log(e2.getLocalizedMessage(), e2);
            this.setErrorMessage(e2.getCause().getLocalizedMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.hostTextWgt.setFocus();
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    public void createControl(Composite comp) {
        FormData fd;
        Label lbl;
        int WIZARD_PARAM_INDENT = 100;
        int WIZARD_COLUMN_SEPARATION = 20;
        int WIZARD_CONNECT_NEG_INDENT = -142;
        Composite topComp = new Composite(comp, 0);
        FormLayout topLayout = new FormLayout();
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        topComp.setLayout((Layout)topLayout);
        if (this.storedDBCIList.size() > 0) {
            lbl = new Label(topComp, 0);
            lbl.setText(Messages.DataBaseRegistryWizardPage_label_recent_text);
            lbl.setToolTipText(Messages.DataBaseRegistryWizardPage_recent_tooltip);
            fd = new FormData();
            fd.top = new FormAttachment(0, 10);
            fd.left = new FormAttachment(0, 24);
            lbl.setLayoutData((Object)fd);
            this.rcntComboWgt = new Combo(topComp, 8);
            this.rcntComboWgt.select(0);
            this.rcntComboWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_recent_tooltip);
            fd = new FormData();
            fd.top = new FormAttachment(0, 10);
            fd.left = new FormAttachment((Control)lbl, 5);
            fd.right = new FormAttachment(100, -40);
            this.rcntComboWgt.setLayoutData((Object)fd);
        }
        Composite paramComp = new Composite(topComp, 0);
        fd = new FormData();
        fd.top = this.storedDBCIList.size() > 0 ? new FormAttachment((Control)this.rcntComboWgt, 10) : new FormAttachment(0, 2);
        fd.left = new FormAttachment((Control)topComp, 2);
        fd.bottom = new FormAttachment(100, -2);
        paramComp.setLayoutData((Object)fd);
        paramComp.setLayout((Layout)new FormLayout());
        lbl = new Label(paramComp, 0);
        lbl.setText(Messages.DataBaseRegistryWizardPage_label_host_text);
        lbl.setToolTipText(Messages.DataBaseRegistryWizardPage_host_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.rcntComboWgt, 15);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        this.hostTextWgt = new Text(paramComp, 2048);
        this.hostTextWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_host_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.rcntComboWgt, 15);
        fd.left = new FormAttachment(0, WIZARD_PARAM_INDENT);
        fd.right = new FormAttachment(100, -5);
        this.hostTextWgt.setLayoutData((Object)fd);
        lbl = new Label(paramComp, 0);
        lbl.setText(Messages.DataBaseRegistryWizardPage_label_port_text);
        lbl.setToolTipText(Messages.DataBaseRegistryWizardPage_port_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.hostTextWgt, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        this.portTextWgt = new Text(paramComp, 2048);
        this.portTextWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_port_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.hostTextWgt, 5);
        fd.left = new FormAttachment(0, WIZARD_PARAM_INDENT);
        fd.right = new FormAttachment(0, WIZARD_PARAM_INDENT + 60);
        this.portTextWgt.setLayoutData((Object)fd);
        lbl = new Label(paramComp, 0);
        lbl.setText(Messages.DataBaseRegistryWizardPage_label_username_text);
        lbl.setToolTipText(Messages.DataBaseRegistryWizardPage_username_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.portTextWgt, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        this.userTextWgt = new Text(paramComp, 2048);
        this.userTextWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_username_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.portTextWgt, 5);
        fd.left = new FormAttachment(0, WIZARD_PARAM_INDENT);
        fd.right = new FormAttachment(100, -5);
        this.userTextWgt.setLayoutData((Object)fd);
        lbl = new Label(paramComp, 0);
        lbl.setText(Messages.DataBaseRegistryWizardPage_label_password_text);
        lbl.setToolTipText(Messages.DataBaseRegistryWizardPage_password_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.userTextWgt, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        this.passTextWgt = new Text(paramComp, 2048);
        this.passTextWgt.setEchoChar("\u2022".toCharArray()[0]);
        this.passTextWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_password_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.userTextWgt, 5);
        fd.left = new FormAttachment(0, WIZARD_PARAM_INDENT);
        fd.right = new FormAttachment(100, -5);
        this.passTextWgt.setLayoutData((Object)fd);
        this.lookupBtnWgt = new Button(paramComp, 8);
        this.lookupBtnWgt.setText(Messages.DataBaseRegistryWizardPage_button_lookup_text);
        this.lookupBtnWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_button_lookup_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.passTextWgt, 20);
        fd.right = new FormAttachment(100, -5);
        this.lookupBtnWgt.setLayoutData((Object)fd);
        lbl = new Label(paramComp, 0);
        lbl.setText(Messages.DataBaseRegistryWizardPage_label_database_text);
        lbl.setToolTipText(Messages.DataBaseRegistryWizardPage_database_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.passTextWgt, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        this.dbComboWgt = new Combo(paramComp, 2048);
        this.dbComboWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_database_tooltip);
        fd = new FormData();
        fd.left = new FormAttachment(0, WIZARD_PARAM_INDENT);
        fd.top = new FormAttachment((Control)this.passTextWgt, 5);
        fd.right = new FormAttachment((Control)this.lookupBtnWgt, -5);
        this.dbComboWgt.setLayoutData((Object)fd);
        lbl = new Label(paramComp, 0);
        lbl.setText(Messages.DataBaseRegistryWizardPage_label_schema_text);
        lbl.setToolTipText(Messages.DataBaseRegistryWizardPage_schema_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.dbComboWgt, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        this.schemaComboWgt = new Combo(paramComp, 2048);
        this.schemaComboWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_schema_tooltip);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.dbComboWgt, 5);
        fd.left = new FormAttachment(0, WIZARD_PARAM_INDENT);
        fd.right = new FormAttachment((Control)this.lookupBtnWgt, -5);
        this.schemaComboWgt.setLayoutData((Object)fd);
        if (!this.dbmsUsesSchema()) {
            lbl.setVisible(false);
            this.schemaComboWgt.setVisible(false);
        }
        this.advancedGrp = this.createAdvancedControl(paramComp);
        if (this.advancedGrp != null) {
            this.advancedBtnWgt = new Button(paramComp, 32);
            this.advancedBtnWgt.setText(Messages.DataBaseRegistryWizardPage_label_advanced_text);
            this.advancedBtnWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_label_advanced_tooltip);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.dbComboWgt, 45);
            fd.left = new FormAttachment(0, 5);
            this.advancedBtnWgt.setLayoutData((Object)fd);
            this.advancedBtnWgt.setSelection(false);
            this.advancedBtnWgt.addSelectionListener((SelectionListener)this);
            FormData d = new FormData();
            d.top = new FormAttachment((Control)this.dbComboWgt, 45);
            d.left = new FormAttachment(0, 5);
            d.right = new FormAttachment(100, -5);
            this.advancedGrp.setLayoutData((Object)d);
            this.advancedGrp.setVisible(false);
            this.advancedGrp.setEnabled(false);
        }
        this.connectBtnWgt = new Button(topComp, 8);
        this.connectBtnWgt.setText(Messages.DataBaseRegistryWizardPage_button_connect_text);
        this.connectBtnWgt.setToolTipText(Messages.DataBaseRegistryWizardPage_button_connect_tooltip);
        fd = new FormData();
        fd.left = new FormAttachment((Control)paramComp, 10);
        fd.bottom = new FormAttachment(100, 0);
        this.connectBtnWgt.setLayoutData((Object)fd);
        ((FormData)paramComp.getLayoutData()).right = new FormAttachment(100, WIZARD_CONNECT_NEG_INDENT - WIZARD_COLUMN_SEPARATION);
        if (this.storedDBCIList != null) {
            for (DataBaseConnInfo dbci : this.storedDBCIList) {
                this.rcntComboWgt.add(dbci.toDisplayString());
            }
        }
        this.currentDBCI.treatEmptyStringAsNull(false);
        this.hostTextWgt.setText(this.currentDBCI.getHostString());
        this.portTextWgt.setText(this.currentDBCI.getPortString());
        this.userTextWgt.setText(this.currentDBCI.getUserString());
        this.passTextWgt.setText(this.currentDBCI.getPassString());
        String str = null;
        str = this.currentDBCI.getDbString();
        if (!this.excludeDbFromUserChoices(str)) {
            this.dbComboWgt.setText(str);
        }
        if (this.dbmsUsesSchema() && !this.excludeSchemaFromUserChoices(str = this.currentDBCI.getSchemaString())) {
            this.schemaComboWgt.setText(str);
        }
        if (this.rcntComboWgt != null) {
            this.rcntComboWgt.setFocus();
        } else {
            this.hostTextWgt.setFocus();
        }
        if (this.couldConnect()) {
            this.lookupBtnWgt.setEnabled(true);
            this.connectBtnWgt.setEnabled(true);
        } else {
            this.lookupBtnWgt.setEnabled(false);
            this.connectBtnWgt.setEnabled(false);
        }
        this.hostTextWgt.addFocusListener((FocusListener)this);
        this.portTextWgt.addFocusListener((FocusListener)this);
        this.userTextWgt.addFocusListener((FocusListener)this);
        this.passTextWgt.addFocusListener((FocusListener)this);
        this.dbComboWgt.addFocusListener((FocusListener)this);
        this.schemaComboWgt.addFocusListener((FocusListener)this);
        if (this.rcntComboWgt != null) {
            this.rcntComboWgt.addModifyListener((ModifyListener)this);
        }
        this.hostTextWgt.addModifyListener((ModifyListener)this);
        this.portTextWgt.addModifyListener((ModifyListener)this);
        this.userTextWgt.addModifyListener((ModifyListener)this);
        this.passTextWgt.addModifyListener((ModifyListener)this);
        this.dbComboWgt.addModifyListener((ModifyListener)this);
        this.schemaComboWgt.addModifyListener((ModifyListener)this);
        this.lookupBtnWgt.addSelectionListener((SelectionListener)this);
        this.connectBtnWgt.addSelectionListener((SelectionListener)this);
        this.setControl((Control)topComp);
        this.setPageComplete(true);
    }

    protected Group createAdvancedControl(Composite arg0) {
        return null;
    }

    protected abstract DataSource getDataSource() throws Exception;

    /*
     * Loose catch block
     */
    protected String[] lookupDbNamesForDisplay(DataSource dataSource) {
        String[] stringArray;
        Connection con;
        block13: {
            ArrayList<String> dbList = new ArrayList<String>();
            con = null;
            con = dataSource.getConnection();
            ResultSet rs = null;
            if (con != null) {
                rs = this.getDatabaseResultSet(con);
                while (rs.next()) {
                    String dbName = rs.getString(1);
                    if (this.excludeDbFromUserChoices(dbName)) continue;
                    dbList.add(dbName);
                }
            }
            stringArray = dbList.toArray(new String[dbList.size()]);
            if (con == null) break block13;
            try {
                con.close();
            }
            catch (SQLException sQLException) {}
        }
        return stringArray;
        catch (SQLException e) {
            block14: {
                try {
                    this.setMessage(Messages.DataBaseRegistryWizardPage_databaseMessage);
                    this.setErrorMessage(e.getLocalizedMessage());
                    if (con == null) break block14;
                }
                catch (Throwable throwable) {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
            return null;
        }
    }

    protected ResultSet getDatabaseResultSet(Connection c) throws SQLException {
        return c.getMetaData().getCatalogs();
    }

    /*
     * Loose catch block
     */
    protected String[] lookupSchemaNamesForDisplay(DataSource dataSource) {
        String[] stringArray;
        Connection con;
        block14: {
            if (dataSource == null) {
                return null;
            }
            con = null;
            ArrayList<String> schemaList = new ArrayList<String>();
            con = dataSource.getConnection();
            ResultSet rs = null;
            if (con != null) {
                rs = this.getSchemasResultSet(con);
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    if (this.excludeSchemaFromUserChoices(schemaName)) continue;
                    schemaList.add(schemaName);
                }
            }
            stringArray = schemaList.toArray(new String[schemaList.size()]);
            if (con == null) break block14;
            try {
                con.close();
            }
            catch (SQLException sQLException) {}
        }
        return stringArray;
        catch (SQLException e) {
            block15: {
                try {
                    this.setMessage(Messages.DataBaseRegistryWizardPage_schemaMessage);
                    this.setErrorMessage(e.getLocalizedMessage());
                    if (con == null) break block15;
                }
                catch (Throwable throwable) {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
            return null;
        }
    }

    protected ResultSet getSchemasResultSet(Connection c) throws SQLException {
        return c.getMetaData().getSchemas();
    }

    public void focusGained(FocusEvent e) {
        if (e.widget == null) {
            return;
        }
        if (e.widget == this.wgtLostFocus) {
            return;
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == null) {
            return;
        }
        this.wgtLostFocus = e.widget;
    }

    public void modifyText(ModifyEvent e) {
        int j;
        int i;
        if (e.widget == null) {
            return;
        }
        if (e.widget == this.rcntComboWgt) {
            i = this.rcntComboWgt.getSelectionIndex();
            this.currentDBCI.setParameters(this.storedDBCIList.get(i));
            this.hostTextWgt.setText(this.currentDBCI.getHostString());
            this.portTextWgt.setText(this.currentDBCI.getPortString());
            this.userTextWgt.setText(this.currentDBCI.getUserString());
            this.passTextWgt.setText(this.currentDBCI.getPassString());
            this.dbComboWgt.setText(this.currentDBCI.getDbString());
            if (this.schemaComboWgt != null) {
                this.schemaComboWgt.setText(this.currentDBCI.getSchemaString());
            }
            this.canNowConnect();
            this.connectBtnWgt.setFocus();
        }
        if (e.widget == this.hostTextWgt) {
            this.currentDBCI.setHost(((Text)e.widget).getText());
            i = this.dbComboWgt.getItemCount();
            this.dbComboWgt.remove(0, i - 1);
            if (this.dbmsUsesSchema()) {
                j = this.schemaComboWgt.getItemCount();
                this.schemaComboWgt.remove(0, j - 1);
            }
        }
        if (e.widget == this.portTextWgt) {
            this.currentDBCI.setPort(((Text)e.widget).getText());
            i = this.dbComboWgt.getItemCount();
            this.dbComboWgt.remove(0, i - 1);
            if (this.dbmsUsesSchema()) {
                j = this.schemaComboWgt.getItemCount();
                this.schemaComboWgt.remove(0, j - 1);
            }
        }
        if (e.widget == this.userTextWgt) {
            this.currentDBCI.setUser(((Text)e.widget).getText());
            i = this.dbComboWgt.getItemCount();
            this.dbComboWgt.remove(0, i - 1);
            if (this.dbmsUsesSchema()) {
                j = this.schemaComboWgt.getItemCount();
                this.schemaComboWgt.remove(0, j - 1);
            }
        }
        if (e.widget == this.passTextWgt) {
            this.currentDBCI.setPass(((Text)e.widget).getText());
            i = this.dbComboWgt.getItemCount();
            this.dbComboWgt.remove(0, i - 1);
            if (this.dbmsUsesSchema()) {
                j = this.schemaComboWgt.getItemCount();
                this.schemaComboWgt.remove(0, j - 1);
            }
        }
        if (e.widget == this.dbComboWgt) {
            this.currentDBCI.setDb(((Combo)e.widget).getText());
        }
        if (this.dbmsUsesSchema() && e.widget == this.schemaComboWgt) {
            this.currentDBCI.setSchema(((Combo)e.widget).getText());
        }
        if (this.couldConnect()) {
            this.canNowConnect();
        } else if (this.couldLookup()) {
            this.canNowLookup();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == null) {
            return;
        }
        if (e.widget.equals(this.advancedBtnWgt)) {
            boolean b = this.advancedBtnWgt.getSelection();
            this.advancedGrp.setVisible(b);
            this.advancedGrp.setEnabled(b);
        }
        if (e.widget.equals(this.lookupBtnWgt)) {
            this.lookupBtnWgt.setEnabled(false);
            DataSource dataSource = null;
            if (this.couldConnect()) {
                try {
                    dataSource = this.getDataSource();
                }
                catch (Exception ex) {
                    CatalogUIPlugin.log(ex.getLocalizedMessage(), ex);
                    this.setErrorMessage(ex.getLocalizedMessage());
                }
            }
            if (dataSource == null) {
                this.lookupBtnWgt.setEnabled(true);
                return;
            }
            this.setErrorMessage(null);
            String[] arr = this.lookupDbNamesForDisplay(dataSource);
            if (arr != null) {
                this.dbComboWgt.setItems(arr);
                this.dbComboWgt.select(0);
            }
            if (this.dbmsUsesSchema() && (arr = this.lookupSchemaNamesForDisplay(dataSource)) != null) {
                this.schemaComboWgt.setItems(arr);
                this.schemaComboWgt.select(0);
            }
            this.dbComboWgt.setFocus();
            this.lookupBtnWgt.setEnabled(true);
            return;
        }
        if (e.widget.equals(this.connectBtnWgt)) {
            this.connectBtnWgt.setEnabled(false);
            if (!this.couldConnect()) {
                return;
            }
            DataSource dataSource = null;
            try {
                dataSource = this.getDataSource();
            }
            catch (Exception ex) {
                CatalogUIPlugin.log(ex.getLocalizedMessage(), ex);
                this.setErrorMessage(ex.getLocalizedMessage());
            }
            if (dataSource == null) {
                this.connectBtnWgt.setEnabled(true);
                return;
            }
            this.setErrorMessage(null);
            this.getWizard().getContainer().updateButtons();
            if (!this.storedDBCIList.contains(this.currentDBCI)) {
                DataBaseConnInfo dbci = new DataBaseConnInfo("");
                dbci.setParameters(this.currentDBCI);
                this.storedDBCIList.add(dbci);
            }
            int s = this.storedDBCIList.size();
            ArrayList<String> rec = new ArrayList<String>(s);
            for (DataBaseConnInfo i : this.storedDBCIList) {
                rec.add(i.toString());
            }
            this.settings.put(this.settingsArrayName, rec.toArray(new String[s]));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void dispose() {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (SQLException sQLException) {}
        }
        super.dispose();
    }
}

