/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.wizard;

public class DataBaseConnInfo {
    private String host;
    private String port;
    private String user;
    private String pass;
    private String db;
    private String schema;
    private boolean treatEmptyStringAsNull;

    public DataBaseConnInfo(String hst, String prt, String usr, String pas, String dbs, String sch) {
        this.setHost(hst);
        this.setPort(prt);
        this.setUser(usr);
        this.setPass(pas);
        this.setDb(dbs);
        this.setSchema(sch);
    }

    public DataBaseConnInfo(String dbEntry) {
        String[] temp = dbEntry.split("\t");
        if (temp.length > 0) {
            this.setHost(temp[0]);
        }
        if (temp.length > 1) {
            this.setPort(temp[1]);
        }
        if (temp.length > 2) {
            this.setUser(temp[2]);
        }
        if (temp.length > 3) {
            this.setPass(temp[3]);
        }
        if (temp.length > 4) {
            this.setDb(temp[4]);
        }
        if (temp.length > 5) {
            this.setSchema(temp[5]);
        }
    }

    public String getHostString() {
        String string = this.host;
        return this.processStringForGetter(string);
    }

    public String getPortString() {
        String string = this.port;
        return this.processStringForGetter(string);
    }

    public String getUserString() {
        String string = this.user;
        return this.processStringForGetter(string);
    }

    public String getPassString() {
        String string = this.pass;
        return this.processStringForGetter(string);
    }

    public String getDbString() {
        String string = this.db;
        return this.processStringForGetter(string);
    }

    public String getSchemaString() {
        String string = this.schema;
        return this.processStringForGetter(string);
    }

    private String processStringForGetter(String string) {
        String toReturn = string == null ? "" : string;
        toReturn = toReturn.trim();
        if (this.treatEmptyStringAsNull && toReturn.length() == 0) {
            return null;
        }
        return toReturn;
    }

    public void setParameters(DataBaseConnInfo dbci) {
        if (dbci == null) {
            this.schema = null;
            this.db = null;
            this.pass = null;
            this.user = null;
            this.port = null;
            this.host = null;
            return;
        }
        this.setHost(dbci.getHostString());
        this.setPort(dbci.getPortString());
        this.setUser(dbci.getUserString());
        this.setPass(dbci.getPassString());
        this.setDb(dbci.getDbString());
        this.setSchema(dbci.getSchemaString());
    }

    public void setHost(String h) {
        this.host = h;
    }

    public void setPort(String p) {
        this.port = p;
    }

    public void setUser(String u) {
        this.user = u;
    }

    public void setPass(String p) {
        this.pass = p;
    }

    public void setDb(String d) {
        this.db = d;
    }

    public void setSchema(String s) {
        this.schema = s;
    }

    public String toDisplayString() {
        return String.valueOf(this.getHostString()) + " : " + this.getPortString() + " : " + this.getUserString() + " : " + this.getPassString() + " : " + this.getDbString() + " : " + this.getSchemaString();
    }

    public String toString() {
        return String.valueOf(this.getHostString()) + "\t" + this.getPortString() + "\t" + this.getUserString() + "\t" + this.getPassString() + "\t" + this.getDbString() + "\t" + this.getSchemaString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.db == null ? 0 : this.db.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.pass == null ? 0 : this.pass.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataBaseConnInfo other = (DataBaseConnInfo)obj;
        if (this.db == null ? other.db != null : !this.db.equals(other.db)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.pass == null ? other.pass != null : !this.pass.equals(other.pass)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.schema == null ? other.schema != null : !this.schema.equals(other.schema)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public void treatEmptyStringAsNull(boolean treatAsNull) {
        this.treatEmptyStringAsNull = treatAsNull;
    }
}

