/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.wizard;

import java.util.Collection;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.ui.CatalogView;
import net.refractions.udig.catalog.ui.CatalogTreeViewer;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CatalogImportWizard
extends WorkflowWizard {
    public CatalogImportWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map) {
        super(workflow, map);
        this.setWindowTitle("Import");
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor) {
        EndConnectionState connState = this.getWorkflow().getState(EndConnectionState.class);
        if (connState == null) {
            return false;
        }
        final Collection<IService> services = connState.getServices();
        if (services == null || services.isEmpty()) {
            return false;
        }
        ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
        catalog.add(services.iterator().next());
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CatalogView view = CatalogImportWizard.this.getCatalogView();
                    if (view != null) {
                        CatalogTreeViewer treeviewer = view.getTreeviewer();
                        treeviewer.setSelection((ISelection)new StructuredSelection(services.iterator().next()));
                    }
                }
                catch (Exception e) {
                    CatalogUIPlugin.log(e.getLocalizedMessage(), e);
                }
            }
        }, (boolean)true);
        return true;
    }

    protected boolean isShowCatalogView() {
        return true;
    }

    protected CatalogView getCatalogView() throws PartInitException {
        CatalogView view = this.isShowCatalogView() ? (CatalogView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("net.refractions.udig.catalog.ui.CatalogView") : (CatalogView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("net.refractions.udig.catalog.ui.CatalogView");
        return view;
    }
}

