/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.wizard;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.internal.ui.ConnectionPageDecorator;
import net.refractions.udig.catalog.internal.ui.ReflectionWorkflowWizardPageProvider;
import net.refractions.udig.catalog.ui.ConnectionErrorPage;
import net.refractions.udig.catalog.ui.DataSourceSelectionPage;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.wizard.CatalogImportWizard;
import net.refractions.udig.catalog.ui.workflow.BasicWorkflowWizardPageFactory;
import net.refractions.udig.catalog.ui.workflow.ConnectionErrorState;
import net.refractions.udig.catalog.ui.workflow.ConnectionFailurePage;
import net.refractions.udig.catalog.ui.workflow.ConnectionFailureState;
import net.refractions.udig.catalog.ui.workflow.DataSourceSelectionState;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.ui.workflow.IntermediateState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardAdapter;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardDialog;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.PlatformUI;

public class CatalogImport {
    Shell shell;
    private WorkflowWizardDialog dialog;
    protected WorkflowWizard wizard;

    public CatalogImport() {
        this.initWorkflow();
    }

    private void initDialog() {
        if (Display.getCurrent() == null) {
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CatalogImport.this.shell = CatalogImport.this.createShell();
                }
            });
        } else {
            this.shell = this.createShell();
        }
        this.dialog = new WorkflowWizardDialog(this.shell, this.wizard);
        this.dialog.setBlockOnOpen(true);
    }

    private void initWorkflow() {
        Workflow workflow = this.createWorkflow();
        Map<Class<? extends State>, WorkflowWizardPageProvider> map = this.createPageMapping();
        this.wizard = this.createWorkflowWizard(workflow, map);
    }

    Shell createShell() {
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (d == null) {
            d = Display.getCurrent();
        }
        Shell parent = d.getActiveShell();
        return new Shell(parent);
    }

    public WorkflowWizardDialog getDialog() {
        if (this.dialog == null) {
            this.initDialog();
        }
        return this.dialog;
    }

    public void open() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CatalogImport.this.dialog.open();
            }
        });
    }

    public boolean run(IProgressMonitor monitor, Object context) {
        if (this.dialog == null) {
            this.initDialog();
        }
        this.dialog.getWorkflowWizard().getWorkflow().setContext(context);
        String bind = MessageFormat.format(Messages.CatalogImport_monitor_task, this.format(context));
        monitor.beginTask(bind, -1);
        monitor.setTaskName(bind);
        try {
            boolean bl = this.dialog.runHeadless((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    private String format(Object data) {
        if (data instanceof URL) {
            return this.formatURL((URL)data);
        }
        if (data instanceof IGeoResource) {
            return ((IGeoResource)data).getIdentifier().getRef();
        }
        if (data instanceof IResolve) {
            return this.formatURL(((IResolve)data).getIdentifier());
        }
        return data.toString();
    }

    private String formatURL(URL url) {
        return String.valueOf(url.getProtocol()) + "://" + url.getPath();
    }

    protected Workflow createWorkflow() {
        DataSourceSelectionState state = new DataSourceSelectionState(false);
        Workflow workflow = new Workflow(new State[]{state});
        return workflow;
    }

    protected Map<Class<? extends State>, WorkflowWizardPageProvider> createPageMapping() {
        HashMap<Class<? extends State>, WorkflowWizardPageProvider> map = new HashMap<Class<? extends State>, WorkflowWizardPageProvider>();
        this.addToMap(map, DataSourceSelectionState.class, DataSourceSelectionPage.class);
        WorkflowWizardPageProvider provider = this.pageProvider(ConnectionPageDecorator.class);
        map.put(IntermediateState.class, provider);
        map.put(EndConnectionState.class, provider);
        this.addToMap(map, ConnectionErrorState.class, ConnectionErrorPage.class);
        this.addToMap(map, ConnectionFailureState.class, ConnectionFailurePage.class);
        return map;
    }

    protected void addToMap(Map<Class<? extends State>, WorkflowWizardPageProvider> map, Class<? extends State> key, Class<? extends WorkflowWizardPage> workflowPage) {
        WorkflowWizardPageProvider pageFactory = this.pageProvider(workflowPage);
        map.put(key, pageFactory);
    }

    protected WorkflowWizardPageProvider pageProvider(Class<? extends WorkflowWizardPage> workflowPage) {
        return new ReflectionWorkflowWizardPageProvider(workflowPage);
    }

    protected WorkflowWizardPageProvider pageProvider(WorkflowWizardPage page) {
        return new BasicWorkflowWizardPageFactory(page);
    }

    protected WorkflowWizard createWorkflowWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map) {
        return new CatalogImportWizard(workflow, map);
    }

    public static class CatalogImportAdapter
    extends WorkflowWizardAdapter
    implements IImportWizard {
        public CatalogImportAdapter() {
            super(new CatalogImport().wizard);
        }
    }
}

