/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.search;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ICatalogInfo;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.ISearch;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.ui.CatalogTreeViewer;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.ResolveContentProvider;
import net.refractions.udig.catalog.ui.ResolveLabelProviderSimple;
import net.refractions.udig.catalog.ui.ResolveTitlesDecorator;
import net.refractions.udig.catalog.ui.StatusLineMessageBoardAdapter;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.search.Info;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.SearchPart;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.PageBook;

public class SearchView
extends SearchPart {
    public static final String VIEW_ID = "net.refractions.udig.catalog.ui.search.searchView";
    public Text text;
    private Button bbox;
    private Label label;
    private Info cache;
    private Text summary;
    private PageBook book;
    private Action refreshAction;
    IResolveChangeListener sync = new IResolveChangeListener(){

        public void changed(IResolveChangeEvent event) {
            final IResolve res = event.getResolve();
            IResolveChangeEvent.Type type = event.getType();
            if (type != IResolveChangeEvent.Type.POST_CHANGE) {
                return;
            }
            if (res == null) {
                return;
            }
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.refresh(res);
                    }
                });
            } else {
                this.refresh(res);
            }
        }

        private void refresh(IResolve res) {
            URL resolveURL = res.getIdentifier();
            URL cachedURL = null;
            if (SearchView.this.cache != null) {
                cachedURL = SearchView.this.cache.getId();
            }
            if (resolveURL != null && resolveURL.equals(cachedURL)) {
                if (res.canResolve(ICatalogInfo.class)) {
                    try {
                        SearchView.this.showInfo(new Info(SearchView.this.cache.getId(), (ICatalogInfo)res.resolve(ICatalogInfo.class, SearchView.this.searchMonitor)));
                    }
                    catch (IOException e) {
                        CatalogUIPlugin.log(null, e);
                    }
                }
                if (res.canResolve(IServiceInfo.class)) {
                    try {
                        SearchView.this.showInfo(new Info(SearchView.this.cache.getId(), (IServiceInfo)res.resolve(IServiceInfo.class, SearchView.this.searchMonitor)));
                    }
                    catch (IOException e) {
                        CatalogUIPlugin.log(null, e);
                    }
                }
                if (res.canResolve(IGeoResourceInfo.class)) {
                    try {
                        SearchView.this.showInfo(new Info(SearchView.this.cache.getId(), (IGeoResourceInfo)res.resolve(IGeoResourceInfo.class, SearchView.this.searchMonitor)));
                    }
                    catch (IOException e) {
                        CatalogUIPlugin.log(null, e);
                    }
                }
            }
        }
    };
    private boolean aoiFilter;

    public SearchView() {
        super(CatalogUIPlugin.getDefault().getDialogSettings());
    }

    protected void setOrientation(SearchPart.Orientation orientation) {
        super.setOrientation(orientation);
        if (this.splitter.getOrientation() == 256) {
            this.label.setText(Messages.SearchView_prompt);
        } else {
            this.label.setText("");
        }
        this.parent.layout();
    }

    public void createPartControl(Composite aParent) {
        this.label = new Label(aParent, 0);
        this.label.setText(Messages.SearchView_prompt);
        this.text = new Text(aParent, 2048);
        this.text.setText(Messages.SearchView_default);
        this.text.setEditable(true);
        this.text.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SearchView.this.search(SearchView.this.createQuery());
            }

            public void widgetSelected(SelectionEvent e) {
                SearchView.this.quick(SearchView.this.text.getText());
            }
        });
        super.createPartControl(aParent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        aParent.setLayout((Layout)layout);
        FormData dLabel = new FormData();
        dLabel.left = new FormAttachment(0);
        dLabel.top = new FormAttachment((Control)this.text, 5, 0x1000000);
        this.label.setLayoutData((Object)dLabel);
        FormData dText = new FormData();
        dText.top = new FormAttachment(1);
        dText.left = new FormAttachment((Control)this.label, 5);
        dText.right = new FormAttachment(100);
        this.text.setLayoutData((Object)dText);
        FormData dBbox = new FormData();
        dBbox.right = new FormAttachment(100);
        dBbox.top = new FormAttachment((Control)this.text, 0, 0x1000000);
        FormData dsashForm = new FormData(100, 100);
        dsashForm.right = new FormAttachment(100);
        dsashForm.left = new FormAttachment(0);
        dsashForm.top = new FormAttachment((Control)this.text, 2);
        dsashForm.bottom = new FormAttachment(100);
        this.splitter.setWeights(new int[]{60, 40});
        this.splitter.setLayoutData((Object)dsashForm);
        this.createContextMenu();
    }

    protected void initDragAndDrop() {
        UDIGDragDropUtilities.addDragSupport((Control)this.viewer.getControl(), (ISelectionProvider)this.viewer);
    }

    protected Composite createDetails(SashForm parent) {
        this.book = new PageBook((Composite)parent, 0);
        this.summary = new Text((Composite)this.book, 2632);
        this.summary.setText("");
        Color white = new Color((Device)parent.getDisplay(), 255, 255, 255);
        this.summary.setBackground(white);
        white.dispose();
        CatalogPlugin.addListener((IResolveChangeListener)this.sync);
        this.book.showPage((Control)this.summary);
        return this.book;
    }

    private void createContextMenu() {
        final MenuManager contextMenu = new MenuManager();
        this.refreshAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)SearchView.this.viewer.getSelection();
                sel.getFirstElement();
                SearchView.this.viewer.refresh();
            }
        };
        Messages.initAction((IAction)this.refreshAction, "action_refresh");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                contextMenu.add((IContributionItem)new GroupMarker("additions"));
                contextMenu.add((IContributionItem)new Separator());
                SearchView.this.refreshAction.setImageDescriptor(CatalogUIPlugin.getDefault().getImageDescriptor("elcl16/refresh_co.gif"));
                IWorkbenchWindow window = SearchView.this.getSite().getWorkbenchWindow();
                ActionFactory.IWorkbenchAction action = ActionFactory.IMPORT.create(window);
                contextMenu.add((IAction)action);
                contextMenu.add((IContributionItem)new Separator());
                contextMenu.add((IContributionItem)UiPlugin.getDefault().getOperationMenuFactory().getContextMenu(SearchView.this.viewer.getSelection()));
            }
        });
        Menu menu = contextMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.viewer);
    }

    protected StructuredViewer createViewer(Composite parent) {
        CatalogTreeViewer catalogTreeViewer = new CatalogTreeViewer(parent, true);
        catalogTreeViewer.setMessageBoard(new StatusLineMessageBoardAdapter(this.getViewSite().getActionBars().getStatusLineManager()));
        return catalogTreeViewer;
    }

    Query createQuery() {
        Query filter = new Query();
        filter.text = this.text.getText();
        filter.bbox = new Envelope();
        boolean aoiFilter2 = this.isAOIFilter();
        if (aoiFilter2) {
            IAOIService aOIService = PlatformGIS.getAOIService();
            try {
                filter.bbox = aOIService.getExtent();
            }
            catch (Throwable t) {
                CatalogUIPlugin.log("Unable to create search:" + t, t);
            }
        }
        return filter;
    }

    protected IBaseLabelProvider createLabelProvider() {
        ResolveLabelProviderSimple base = new ResolveLabelProviderSimple();
        return new DecoratingLabelProvider((ILabelProvider)base, (ILabelDecorator)new ResolveTitlesDecorator(base));
    }

    protected void showInfo(Info info) {
        this.book.showPage((Control)this.summary);
        if (this.cache != null && info.getId().equals(this.cache.getId())) {
            return;
        }
        this.cache = info;
        this.summary.setText("");
        URL url = this.cache.getId();
        String serverName = "";
        if (url != null) {
            serverName = url.getHost();
        }
        if (this.cache.title != null && !this.cache.title.equals("")) {
            this.summary.append(String.valueOf(MessageFormat.format(Messages.SearchView_title, this.cache.title)) + "\n\n");
        }
        if (this.cache.name != null && !this.cache.name.equals("")) {
            this.summary.append(String.valueOf(MessageFormat.format(Messages.SearchView_name, this.cache.name, serverName)) + ")\n\n");
        } else if (serverName != null && !serverName.equals("")) {
            this.summary.append(String.valueOf(MessageFormat.format(Messages.SearchView_server, serverName)) + "\n\n");
        }
        if (this.cache.keys != null && this.cache.keys.length > 0) {
            this.summary.append(Messages.SearchView_keywords);
            int i = 0;
            while (i < this.cache.keys.length) {
                String keyword = this.cache.keys[i];
                String string = keyword = keyword == null ? null : keyword.trim();
                if (keyword != null && !keyword.equalsIgnoreCase("")) {
                    if (i == this.cache.keys.length - 1) {
                        this.summary.append(String.valueOf(keyword) + "\n\n");
                    } else {
                        this.summary.append(String.valueOf(keyword) + ", ");
                    }
                }
                ++i;
            }
        }
        if (this.cache.description != null && !this.cache.description.equals("")) {
            this.summary.append(MessageFormat.format(Messages.SearchView_description, this.cache.description));
        }
    }

    protected void showDetail(Object selection) {
        if (!(selection instanceof IResolve)) {
            return;
        }
        IResolve record = (IResolve)selection;
        if (record instanceof ICatalog) {
            ICatalog catalog = (ICatalog)record;
            try {
                ICatalogInfo info = catalog.getInfo(this.searchMonitor);
                this.showInfo(new Info(catalog.getIdentifier(), info));
            }
            catch (IOException e) {
                CatalogUIPlugin.log("No information for catalog", e);
            }
        } else if (record instanceof IService) {
            IService service = (IService)record;
            try {
                IServiceInfo info = service.getInfo(this.searchMonitor);
                this.showInfo(new Info(service.getIdentifier(), info));
            }
            catch (IOException e) {
                CatalogUIPlugin.log("No information for service", e);
            }
        } else if (record instanceof IGeoResource) {
            IGeoResource layer = (IGeoResource)record;
            try {
                IGeoResourceInfo info = layer.getInfo(this.searchMonitor);
                this.showInfo(new Info(layer.getIdentifier(), info));
            }
            catch (IOException e) {
                CatalogUIPlugin.log("No information for layer", e);
            }
        }
    }

    protected IStructuredContentProvider createContentProvider() {
        return new ResolveContentProvider();
    }

    public void setStatus(String message) {
    }

    protected void searchImplementation(Object filter, IProgressMonitor monitor, SearchPart.ResultSet results) {
        Query query = (Query)filter;
        if (query == null) {
            return;
        }
        if (!(query.bbox != null && !query.bbox.isNull() || query.text != null && query.text.trim().length() != 0)) {
            return;
        }
        if (query.bbox == null) {
            query.bbox = new Envelope();
        }
        if (query.scope == null) {
            query.scope = Arrays.asList(CatalogPlugin.getDefault().getCatalogs());
        }
        monitor.beginTask(Messages.SearchView_searching, query.scope.size() * 3);
        int work = 0;
        for (ISearch catalog : query.scope) {
            String name = null;
            try {
                name = catalog.getInfo(null).getTitle();
                if (name == null && catalog.getIdentifier() != null) {
                    name = "url: " + catalog.getIdentifier();
                }
                if (name == null) {
                    name = catalog.getClass().getSimpleName();
                }
            }
            catch (Exception exception) {
                name = catalog.getClass().getSimpleName();
            }
            List records = null;
            try {
                monitor.subTask(MessageFormat.format(Messages.SearchView_searching_for, query.text, name));
                monitor.worked(++work);
                records = catalog.search(query.text, query.bbox, monitor);
                if (records == null || records.isEmpty()) continue;
                results.addAll((Collection)records);
            }
            catch (Throwable t) {
                CatalogUIPlugin.log("Search for " + name + " failed", t);
            }
        }
    }

    public void setAOIFilter(boolean filter) {
        this.aoiFilter = filter;
        this.search(this.createQuery());
    }

    public boolean isAOIFilter() {
        return this.aoiFilter;
    }

    static class Query {
        String text;
        Envelope bbox;
        List<ISearch> scope;

        Query() {
        }
    }
}

