/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.operation;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.operation.TransformDialog;
import net.refractions.udig.catalog.util.GeoToolsAdapters;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.process.vector.TransformProcess;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.util.ProgressListener;

public class TransformOperation
implements IOp {
    static int count = 0;

    public void op(final Display display, Object target, final IProgressMonitor monitor) throws Exception {
        SimpleFeature feature;
        final IGeoResource handle = (IGeoResource)target;
        final SimpleFeatureSource featureSource = (SimpleFeatureSource)handle.resolve(SimpleFeatureSource.class, null);
        SimpleFeatureCollection collection = featureSource.getFeatures();
        FeatureIterator iterator = collection.features();
        try {
            if (!iterator.hasNext()) {
                return;
            }
            feature = (SimpleFeature)iterator.next();
        }
        finally {
            iterator.close();
        }
        final SimpleFeature sample = feature;
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                final TransformDialog dialog = new TransformDialog(display.getActiveShell(), sample);
                int result = dialog.open();
                if (result == 1) {
                    return;
                }
                if (result == 0) {
                    try {
                        PlatformGIS.runBlockingOperation((IRunnableWithProgress)new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                try {
                                    final IGeoResource reshaped = TransformOperation.this.process(featureSource, dialog, monitor);
                                    PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            dialog.executePostAction(handle, reshaped);
                                        }
                                    }, (boolean)true);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e.getMessage(), e);
                                }
                            }
                        }, (IProgressMonitor)monitor);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, (boolean)true);
    }

    public IGeoResource process(SimpleFeatureSource source, TransformDialog dialog, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.ReshapeOperation_task, 100);
        List<TransformProcess.Definition> transform = dialog.getTransform();
        TransformProcess process = new TransformProcess();
        DefaultTransaction transaction = new DefaultTransaction("Processing " + source.getName());
        try {
            SimpleFeatureCollection collection = source.getFeatures();
            SimpleFeatureCollection output = process.executeList(collection, transform);
            SimpleFeatureType featureType = (SimpleFeatureType)output.getSchema();
            IGeoResource scratch = CatalogPlugin.getDefault().getLocalCatalog().createTemporaryResource((Object)featureType);
            final SimpleFeatureStore store = (SimpleFeatureStore)scratch.resolve(SimpleFeatureStore.class, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ReshapeOperation_createTempSpaceTask, (int)10));
            store.setTransaction((Transaction)transaction);
            org.geotools.util.ProgressListener progessListener = GeoToolsAdapters.progress((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)("processing " + source.getName()), (int)90));
            output.accepts(new FeatureVisitor(){
                boolean warning = true;

                public void visit(Feature rawFeature) {
                    block2: {
                        SimpleFeature feature = (SimpleFeature)rawFeature;
                        String fid = feature.getID();
                        try {
                            store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
                        }
                        catch (Throwable t) {
                            if (!this.warning) break block2;
                            System.out.println("Process " + fid + ":" + t);
                            t.printStackTrace();
                            this.warning = false;
                        }
                    }
                }
            }, (ProgressListener)progessListener);
            transaction.commit();
            IGeoResource iGeoResource = scratch;
            return iGeoResource;
        }
        catch (RuntimeException huh) {
            transaction.rollback();
            huh.printStackTrace();
        }
        finally {
            monitor.done();
        }
        return null;
    }

    public static String getNewTypeName(String typeName) {
        return String.valueOf(typeName) + count++;
    }
}

