/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.operation;

import com.vividsolutions.jts.geom.Geometry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.operation.PostReshapeAction;
import net.refractions.udig.catalog.ui.operation.ReshapeException;
import net.refractions.udig.catalog.ui.operation.ReshapeOperation;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.core.StaticProvider;
import net.refractions.udig.core.internal.ExtensionPointList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.vector.TransformProcess;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReshapeDialog
extends Dialog {
    private static final String ACTION_COMBO_SETTINGS = "RESHAPE_ACTION_COMBO_SETTINGS";
    private SimpleFeatureType originalFeatureType;
    private SimpleFeature sample;
    private Text text;
    private SimpleFeatureType featureType;
    private List<TransformProcess.Definition> transform;
    private Combo actionCombo;
    private IProvider<PostReshapeAction> postActionProvider;
    private ControlDecoration feedbackDecorator;
    private Composite panel;
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            try {
                ReshapeDialog.this.feedbackDecorator.hide();
                ReshapeDialog.this.feedbackDecorator.hideHover();
                List<TransformProcess.Definition> list = ReshapeDialog.this.createTransformProcessDefinitionList();
                int count = 0;
                boolean changed = false;
                for (TransformProcess.Definition definition : list) {
                    ++count;
                    if (definition.expression instanceof PropertyName) {
                        PropertyName propertyName = (PropertyName)definition.expression;
                        if (definition.name.equals(propertyName.getPropertyName())) continue;
                        changed = true;
                        break;
                    }
                    changed = true;
                    break;
                }
                if (!changed && ReshapeDialog.this.originalFeatureType.getAttributeCount() == count) {
                    ReshapeDialog.this.showFeedback("Transform does not modify any content", null);
                }
            }
            catch (Throwable t) {
                ReshapeDialog.this.showFeedback(null, t);
            }
        }
    };

    public ReshapeDialog(Shell parent, SimpleFeature sample) {
        super(parent);
        this.originalFeatureType = sample.getFeatureType();
        this.sample = sample;
        this.setShellStyle(2160);
    }

    public void executePostAction(IGeoResource original, IGeoResource reshaped) {
        ((PostReshapeAction)this.postActionProvider.get(new Object[0])).execute(original, reshaped);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ReshapeOperation_DialogText);
        this.panel = (Composite)super.createDialogArea(parent);
        GridData gridData = new GridData(4, 4, true, true);
        this.panel.setLayoutData((Object)gridData);
        this.panel.setLayout((Layout)new MigLayout("fillx", "[grow,fill]", "[][grow,fill][][]"));
        Label label = new Label(this.panel, 16384);
        label.setText("Transform");
        label.setLayoutData((Object)"width pref!,left,wrap");
        this.feedbackDecorator = new ControlDecoration((Control)label, 131200);
        this.text = new Text(this.panel, 2562);
        this.text.setEditable(true);
        this.text.setText(this.getDefaultText());
        this.text.setLayoutData((Object)"wrap, height 100:pref:100%");
        this.text.addListener(24, this.listener);
        label = new Label(this.panel, 16384);
        label.setText("How would you like to handle the result:");
        label.setLayoutData((Object)"width pref!,wrap");
        this.actionCombo = new Combo(this.panel, 8);
        this.actionCombo.setLayoutData((Object)"width pref!");
        this.actionCombo(this.actionCombo);
        return this.panel;
    }

    private void actionCombo(Combo actionCombo) {
        actionCombo.add(Messages.ReshapeOperation_noAction);
        actionCombo.setData(Messages.ReshapeOperation_noAction, (Object)new StaticProvider((Object)new Null_Action()));
        int i = 1;
        String lastSelection = CatalogUIPlugin.getDefault().getDialogSettings().get(ACTION_COMBO_SETTINGS);
        int selected = 0;
        List extensions = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.catalog.ui.reshapePostAction");
        for (final IConfigurationElement configurationElement : extensions) {
            String name = configurationElement.getAttribute("name");
            IProvider<PostReshapeAction> provider = new IProvider<PostReshapeAction>(){

                public PostReshapeAction get(Object ... params) {
                    try {
                        return (PostReshapeAction)configurationElement.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        throw (RuntimeException)new RuntimeException().initCause(e);
                    }
                }
            };
            actionCombo.add(name);
            actionCombo.setData(name, (Object)provider);
            String id = String.valueOf(configurationElement.getNamespaceIdentifier()) + "." + configurationElement.getAttribute("id");
            actionCombo.setData(String.valueOf(name) + "id", (Object)id);
            if (id.equals(lastSelection)) {
                selected = i;
            }
            ++i;
        }
        actionCombo.select(selected);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    String getDefaultText() {
        StringBuffer buffer = new StringBuffer();
        for (AttributeDescriptor descriptor : this.originalFeatureType.getAttributeDescriptors()) {
            buffer.append(descriptor.getName());
            buffer.append("=");
            buffer.append(descriptor.getName());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected void okPressed() {
        boolean ok = false;
        try {
            this.transform = this.createTransformProcessDefinitionList();
            this.featureType = this.createFeatureType();
            ok = this.featureType != null;
            String selected = this.actionCombo.getItem(this.actionCombo.getSelectionIndex());
            CatalogUIPlugin.getDefault().getDialogSettings().put(ACTION_COMBO_SETTINGS, (String)this.actionCombo.getData(String.valueOf(selected) + "id"));
            this.postActionProvider = (IProvider)this.actionCombo.getData(selected);
        }
        catch (Throwable t) {
            this.showFeedback(null, t);
        }
        if (ok) {
            super.okPressed();
        }
    }

    private void showFeedback(String message, Throwable t) {
        this.feedbackDecorator.hide();
        this.feedbackDecorator.hideHover();
        if (t == null && message != null) {
            FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
            FieldDecoration errorDecoration = decorations.getFieldDecoration("DEC_WARNING");
            this.feedbackDecorator.setImage(errorDecoration.getImage());
            this.feedbackDecorator.setDescriptionText(message);
            this.feedbackDecorator.showHoverText(message);
            this.feedbackDecorator.show();
        } else if (t != null) {
            String errormessage = t.getLocalizedMessage();
            errormessage = errormessage == null ? Messages.ReshapeOperation_2 : errormessage.replaceAll("\\n\\s+", " ");
            if (message == null) {
                message = MessageFormat.format(Messages.ReshapeOperation_3, errormessage);
            }
            FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
            FieldDecoration errorDecoration = decorations.getFieldDecoration("DEC_WARNING");
            this.feedbackDecorator.setImage(errorDecoration.getImage());
            this.feedbackDecorator.setDescriptionText(message);
            this.feedbackDecorator.showHoverText(message);
            this.feedbackDecorator.show();
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public List<TransformProcess.Definition> getTransform() {
        return this.transform;
    }

    private SimpleFeatureType createFeatureType() throws SchemaException {
        SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
        this.transform = this.createTransformProcessDefinitionList();
        for (TransformProcess.Definition definition : this.transform) {
            String name = definition.name;
            Expression expression = definition.expression;
            Class<?> binding = definition.binding;
            if (binding == null) {
                Object value = expression.evaluate((Object)this.sample);
                if (value == null) {
                    if (expression instanceof PropertyName) {
                        String path = ((PropertyName)expression).getPropertyName();
                        AttributeType attributeType = this.sample.getFeatureType().getType(path);
                        if (attributeType == null) {
                            String msg = Messages.ReshapeOperation_4;
                            throw new ReshapeException(MessageFormat.format(msg, name, path));
                        }
                        binding = attributeType.getClass();
                    }
                } else {
                    binding = value.getClass();
                }
                if (binding == null) {
                    String msg = Messages.ReshapeOperation_5;
                    throw new ReshapeException(MessageFormat.format(msg, name));
                }
            }
            if (Geometry.class.isAssignableFrom(binding)) {
                AttributeType originalAttributeType = this.originalFeatureType.getType(name);
                CoordinateReferenceSystem crs = originalAttributeType == null && originalAttributeType instanceof GeometryType ? ((GeometryType)originalAttributeType).getCoordinateReferenceSystem() : this.originalFeatureType.getCoordinateReferenceSystem();
                build.crs(crs);
                build.add(name, binding);
                continue;
            }
            build.add(name, (Class)binding);
        }
        build.setName(ReshapeOperation.getNewTypeName(this.originalFeatureType.getTypeName()));
        return build.buildFeatureType();
    }

    public List<TransformProcess.Definition> createTransformProcessDefinitionList() {
        ArrayList<TransformProcess.Definition> list = new ArrayList();
        String definition = this.text.getText().replaceAll("\r", "\n").replaceAll("[\n\r][\n\r]", "\n");
        list = TransformProcess.toDefinition((String)definition);
        return list;
    }

    private final class Null_Action
    implements PostReshapeAction {
        private Null_Action() {
        }

        @Override
        public void execute(IGeoResource original, IGeoResource reshaped) {
        }
    }
}

