/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import net.refractions.udig.catalog.ui.export.FeatureWrapper;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.ui.ProgressFeatureCollection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ReprojectingFeatureCollection
extends ProgressFeatureCollection
implements FeatureCollection<SimpleFeatureType, SimpleFeature> {
    private SimpleFeatureType featureType;
    private MathTransform mt;

    public ReprojectingFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, IProgressMonitor monitor, SimpleFeatureType SimplefeatureType, MathTransform mt) {
        super(delegate, monitor);
        this.mt = mt;
        this.featureType = SimplefeatureType;
    }

    protected Iterator<SimpleFeature> openIterator() {
        final FeatureIterator iterator = this.delegate.features();
        return new Iterator<SimpleFeature>(){
            private FeatureWrapper feature;

            @Override
            public boolean hasNext() {
                while (this.feature == null) {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    SimpleFeature next = (SimpleFeature)iterator.next();
                    if (next == null) continue;
                    Geometry geometry = (Geometry)next.getDefaultGeometry();
                    if (geometry != null) {
                        try {
                            geometry = JTS.transform((Geometry)geometry, (MathTransform)ReprojectingFeatureCollection.this.mt);
                        }
                        catch (TransformException e) {
                            throw (RuntimeException)new RuntimeException(String.valueOf(Messages.ReprojectingFeatureCollection_transformationError) + next.getID()).initCause(e);
                        }
                    }
                    GeometryDescriptor defaultGeometry2 = ReprojectingFeatureCollection.this.featureType.getGeometryDescriptor();
                    Name name = defaultGeometry2.getName();
                    String localPart = name.getLocalPart();
                    this.feature = new FeatureWrapper(next, ReprojectingFeatureCollection.this.featureType, new Geometry[]{geometry}, new String[]{localPart});
                }
                return this.feature != null;
            }

            @Override
            public SimpleFeature next() {
                ReprojectingFeatureCollection.this.monitor.worked(1);
                FeatureWrapper tmp = this.feature;
                this.feature = null;
                return tmp;
            }

            @Override
            public void remove() {
                iterator.next();
            }
        };
    }
}

