/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.ui.ResolveLabelProviderSimple;
import net.refractions.udig.catalog.ui.ResolveTitlesDecorator;
import net.refractions.udig.catalog.ui.export.Data;
import net.refractions.udig.catalog.ui.export.ExportResourceSelectionState;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import net.refractions.udig.ui.CRSDialogCellEditor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.geotools.data.FeatureSource;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExportResourceSelectionPage
extends WorkflowWizardPage
implements IPageChangedListener,
ICheckStateListener {
    public static final String DIRECTORY_KEY = "ExportResourceSelection_DIRECTORY_KEY";
    private CheckboxTreeViewer viewer;
    private Text destText;

    public ExportResourceSelectionPage(String pageName, String title, ImageDescriptor banner) {
        super(pageName, title, banner);
        this.setMessage(Messages.LayerSelectionPage_message);
    }

    public List<Data> getCheckedElements() {
        ArrayList<Data> list = new ArrayList<Data>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Data resource = (Data)object;
            list.add(resource);
            ++n2;
        }
        return list;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createExportDirComponent(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.ExportPage_ResourceList);
        GridData layoutData = new GridData(4, 0, true, false);
        label.setLayoutData((Object)layoutData);
        this.viewer = new CheckboxTreeViewer(composite, 67620);
        Tree tree = this.createTree(this.viewer.getTree());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportResourceSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.viewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ExportResourceLabelProvider());
        this.viewer.setAutoExpandLevel(3);
        this.viewer.setColumnProperties(new String[]{"name", "CRS"});
        this.viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)tree), new CRSDialogCellEditor(tree)});
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                Data data = (Data)element;
                if ("CRS".equals(property)) {
                    return data.getCRS();
                }
                if (data.getName() == null) {
                    return ((ExportResourceLabelProvider)ExportResourceSelectionPage.this.viewer.getLabelProvider()).getColumnText(data, 0);
                }
                return data.getName();
            }

            public void modify(Object element, String property, Object value) {
                TreeItem item = (TreeItem)element;
                Data data = (Data)item.getData();
                if ("CRS".equals(property)) {
                    data.setCRS((CoordinateReferenceSystem)value);
                } else {
                    data.setName((String)value);
                }
                ExportResourceSelectionPage.this.viewer.update((Object)data, null);
            }
        });
        ExportResourceSelectionState state = this.getState();
        this.setInput(state);
        this.setControl((Control)composite);
    }

    private void createExportDirComponent(Composite top) {
        Composite comp = new Composite(top, 0);
        comp.setLayout((Layout)new GridLayout(3, false));
        comp.setLayoutData((Object)new GridData(768));
        this.createExportLabel(comp);
        String tooltip = Messages.ExportPage_ExportDir;
        this.createExportText(comp, tooltip);
        this.createExportBrowseButton(comp, tooltip);
    }

    private void createExportBrowseButton(Composite comp, String tooltip) {
        Button select = new Button(comp, 8);
        select.setText(Messages.ExportPage_Browse);
        select.setToolTipText(tooltip);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalAlignment = 4;
        select.setLayoutData((Object)gridData);
        select.addSelectionListener((SelectionListener)new SelectButtonListener());
    }

    private void createExportText(Composite comp, String tooltip) {
        this.destText = new Text(comp, 2052);
        this.destText.setToolTipText(tooltip);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.destText.setLayoutData((Object)gridData);
        WorkflowWizard wizard2 = this.getWizard();
        IDialogSettings dialogSettings = wizard2.getDialogSettings();
        String previousLocation = dialogSettings.get(DIRECTORY_KEY);
        if (previousLocation != null) {
            this.destText.setText(previousLocation);
            this.getState().setExportDir(previousLocation);
        } else {
            this.destText.setText(this.getState().getExportDir());
        }
        this.destText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ExportResourceSelectionPage.this.getState().setExportDir(ExportResourceSelectionPage.this.destText.getText());
            }
        });
    }

    @Override
    public ExportResourceSelectionState getState() {
        return (ExportResourceSelectionState)super.getState();
    }

    private void createExportLabel(Composite comp) {
        Label scaleLabel = new Label(comp, 0);
        scaleLabel.setText(Messages.ExportPage_Destination);
        scaleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    public File getExportDir() {
        return new File(this.destText.getText());
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object o;
        if (event.getChecked() && this.viewer.getGrayed(o = event.getElement())) {
            this.viewer.setChecked(o, false);
            return;
        }
        o = event.getElement();
        ResourceContentProvider p = (ResourceContentProvider)this.viewer.getContentProvider();
        Object[] elements = p.getElements(o);
        if (elements != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                this.viewer.setChecked(elements[i], event.getChecked());
                ++i;
            }
        }
        if (this.viewer.getCheckedElements().length > 0) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
        this.syncWithUI();
    }

    private Tree createTree(Tree tree) {
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tree.setLayout((Layout)tableLayout);
        TreeColumn name = new TreeColumn(tree, -1);
        name.setMoveable(false);
        name.setResizable(true);
        TreeColumn projection = new TreeColumn(tree, -1);
        projection.setMoveable(false);
        projection.setResizable(true);
        return tree;
    }

    public CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    public void syncWithUI() {
        ExportResourceSelectionState state = this.getState();
        ArrayList<Data> selectedLayers = new ArrayList<Data>();
        Object[] elements = this.getViewer().getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            Data layer = (Data)elements[i];
            selectedLayers.add(layer);
            ++i;
        }
        state.setSelectedLayers(selectedLayers);
    }

    @Override
    public void shown() {
        this.setInput(this.getState());
    }

    private void setInput(ExportResourceSelectionState state) {
        List<Data> resources = state.getLayers();
        this.viewer.setInput(resources);
        if (resources != null) {
            for (Data data : resources) {
                this.viewer.setChecked((Object)data, false);
                if (data.getResource().canResolve(FeatureSource.class)) {
                    this.viewer.setGrayed((Object)data, false);
                    continue;
                }
                this.viewer.setGrayed((Object)data, true);
            }
            for (Data data : resources) {
                boolean checked = !this.viewer.getGrayed((Object)data) && data.isChecked();
                this.viewer.setChecked((Object)data, checked);
            }
        }
        if (this.viewer.getCheckedElements().length > 0) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
        this.syncWithUI();
    }

    public boolean isPageComplete() {
        return this.viewer.getCheckedElements().length > 0;
    }

    Button findButton(Control[] children, int id) {
        if ((Integer)this.getShell().getDefaultButton().getData() == id) {
            return this.getShell().getDefaultButton();
        }
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite;
            Button button;
            Button button2;
            Control child = controlArray[n2];
            if (child instanceof Button && (Integer)(button2 = (Button)child).getData() == id) {
                return button2;
            }
            if (child instanceof Composite && (button = this.findButton((composite = (Composite)child).getChildren(), id)) != null) {
                return button;
            }
            ++n2;
        }
        return null;
    }

    public void pageChanged(PageChangedEvent event) {
    }

    public class ExportResourceLabelProvider
    implements ITableLabelProvider {
        private DecoratingLabelProvider wrapped;

        public ExportResourceLabelProvider() {
            ResolveTitlesDecorator titleDecorator = new ResolveTitlesDecorator(new ResolveLabelProviderSimple());
            this.wrapped = new DecoratingLabelProvider(titleDecorator.getSource(), (ILabelDecorator)titleDecorator);
        }

        public void addListener(ILabelProviderListener listener) {
            this.wrapped.addListener(listener);
        }

        public void dispose() {
            this.wrapped.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.wrapped.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.wrapped.addListener(listener);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            assert (element instanceof Data);
            assert (columnIndex < 3);
            Data data = (Data)element;
            switch (columnIndex) {
                case 0: {
                    return this.wrapped.getImage((Object)data.getResource());
                }
                case 1: {
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            assert (element instanceof Data);
            assert (columnIndex < 3);
            Data data = (Data)element;
            CoordinateReferenceSystem crs = data.getCRS();
            switch (columnIndex) {
                case 0: {
                    if (data.getName() == null) {
                        return this.wrapped.getText((Object)data.getResource());
                    }
                    return data.getName();
                }
                case 1: {
                    if (crs == null) {
                        return "undefined";
                    }
                    return crs.getName().toString();
                }
            }
            throw new RuntimeException("Don't know how to handle column 3");
        }
    }

    private static class ResourceContentProvider
    implements ITreeContentProvider {
        private ResourceContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                List resources = (List)parentElement;
                return resources.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    public class SelectButtonListener
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog d = new DirectoryDialog(e.widget.getDisplay().getActiveShell());
            String selection = d.open();
            if (selection != null) {
                ExportResourceSelectionPage.this.destText.setText(selection);
            }
        }
    }
}

