/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.ui.ProgressManager;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Data {
    private CoordinateReferenceSystem crs;
    private final IGeoResource resource;
    private Collection<IGeoResource> exportedResources = new HashSet<IGeoResource>();
    private Query query;
    private String name;
    private boolean checked;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Data(IGeoResource resource, Query query) {
        try {
            this.crs = resource.getInfo(ProgressManager.instance().get(new Object[0])).getCRS();
            this.resource = resource;
            this.checked = true;
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        this.query = query;
    }

    public Data(IGeoResource resource) {
        this(resource, (Query)new DefaultQuery());
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public IGeoResource getResource() {
        return this.resource;
    }

    public void setCRS(CoordinateReferenceSystem newCRS) {
        this.crs = newCRS;
    }

    public void addNewResource(IGeoResource resource) {
        this.exportedResources.add(resource);
    }

    public void addNewResources(Collection<IGeoResource> resources) {
        this.exportedResources.addAll(resources);
    }

    public Collection<IGeoResource> getExportedResources() {
        return this.exportedResources;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }
}

