/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import java.io.IOException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CountDownProgressMonitor
extends SubProgressMonitor {
    private int remaining;
    private long lastChange;
    private int worked = 0;
    private String name;

    public CountDownProgressMonitor(IProgressMonitor monitor, int ticks, IGeoResource resource, int remaining) {
        super(monitor, ticks);
        this.remaining = remaining;
        try {
            IGeoResourceInfo info = resource.getInfo(ProgressManager.instance().get(new Object[0]));
            this.name = info.getTitle();
            if (this.name == null) {
                this.name = info.getName();
            }
        }
        catch (IOException e) {
            CatalogUIPlugin.log("Couldn't read info", e);
            this.name = resource.getIdentifier().toString();
        }
        this.setTaskName();
    }

    private void setTaskName() {
        this.setTaskName(String.valueOf(Messages.CountDownProgressMonitor_taskNamePart1) + this.name + "," + Messages.CountDownProgressMonitor_taskNamePart2 + this.remaining);
        this.lastChange = System.currentTimeMillis();
    }

    public void worked(int work) {
        ++this.worked;
        this.remaining -= work;
        if (System.currentTimeMillis() - this.lastChange > 1000L) {
            this.setTaskName();
            super.worked(this.worked);
            this.worked = 0;
        }
    }

    public int getRemaining() {
        return this.remaining;
    }
}

