/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.ui.CatalogView;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.export.CatalogExport;
import net.refractions.udig.catalog.ui.export.Data;
import net.refractions.udig.catalog.ui.export.ExportResourceSelectionState;
import net.refractions.udig.catalog.ui.export.ReprojectingFeatureCollection;
import net.refractions.udig.catalog.ui.export.ToMultiLineFeatureCollection;
import net.refractions.udig.catalog.ui.export.ToMultiPointFeatureCollection;
import net.refractions.udig.catalog.ui.export.ToMultiPolygonFeatureCollection;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CatalogExportWizard
extends WorkflowWizard
implements IExportWizard {
    private boolean select = true;
    static String SHAPEFILE_EXT = ".shp";
    static String POLY_SUFFIX = "_poly";
    static String POINT_SUFFIX = "_point";
    static String LINE_SUFFIX = "_line";

    public CatalogExportWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map) {
        super(workflow, map);
        this.setWindowTitle(Messages.CatalogExportWizard_WindowTitle);
    }

    public void setSelectExportedInCatalog(boolean select) {
        this.select = select;
    }

    public IDialogSettings getDialogSettings() {
        return CatalogUIPlugin.getDefault().getDialogSettings();
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor) {
        ExportResourceSelectionState layerSelectState = this.getWorkflow().getState(ExportResourceSelectionState.class);
        if (layerSelectState == null) {
            return false;
        }
        List<Data> resources = layerSelectState.getExportData();
        boolean success = true;
        monitor.beginTask(Messages.CatalogExport_taskName, resources.size() + 1);
        monitor.worked(1);
        for (Data data : resources) {
            SubProgressMonitor currentMonitor;
            boolean isExported = this.exportResource(data, (IProgressMonitor)(currentMonitor = new SubProgressMonitor(monitor, 1)));
            if (isExported) continue;
            success = false;
        }
        if (success) {
            this.selectInCatalog();
        }
        monitor.done();
        if (success) {
            this.getDialogSettings().put("ExportResourceSelection_DIRECTORY_KEY", this.findState().getExportDir());
        }
        return success;
    }

    private boolean exportResource(Data data, IProgressMonitor monitor) {
        block18: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            final WizardDialog wizardDialog = (WizardDialog)this.getContainer();
            IGeoResource resource = data.getResource();
            try {
                FeatureSource fs = (FeatureSource)resource.resolve(FeatureSource.class, null);
                FeatureCollection fc = fs.getFeatures(data.getQuery());
                SimpleFeatureType schema = (SimpleFeatureType)fs.getSchema();
                if (data.getName() != null) {
                    SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                    builder.init(schema);
                    builder.setName(data.getName());
                    schema = builder.buildFeatureType();
                }
                File file = this.determineDestinationFile(data);
                monitor.beginTask("", -1);
                CoordinateReferenceSystem fromCRS = schema.getCoordinateReferenceSystem();
                CoordinateReferenceSystem crs = data.getCRS();
                Object mt = fromCRS != null && crs != null ? CRS.findMathTransform((CoordinateReferenceSystem)fromCRS, (CoordinateReferenceSystem)crs, (boolean)true) : (crs != null ? IdentityTransform.create((int)crs.getCoordinateSystem().getDimension()) : (fromCRS != null ? IdentityTransform.create((int)fromCRS.getCoordinateSystem().getDimension()) : IdentityTransform.create((int)2)));
                if (this.isAbstractGeometryType(schema)) {
                    String geomName = schema.getGeometryDescriptor().getName().getLocalPart();
                    SimpleFeatureCollection pointCollection = FeatureCollections.newCollection();
                    SimpleFeatureCollection lineCollection = FeatureCollections.newCollection();
                    SimpleFeatureCollection polygonCollection = FeatureCollections.newCollection();
                    FeatureCollection featureCollection = fs.getFeatures();
                    FeatureIterator featureIterator = featureCollection.features();
                    while (featureIterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)featureIterator.next();
                        String geometryType = ((Geometry)feature.getDefaultGeometry()).getGeometryType();
                        if (geometryType.endsWith("Point")) {
                            pointCollection.add((Feature)feature);
                            continue;
                        }
                        if (geometryType.endsWith("LineString")) {
                            lineCollection.add((Feature)feature);
                            continue;
                        }
                        if (!geometryType.endsWith("Polygon")) continue;
                        polygonCollection.add((Feature)feature);
                    }
                    if (polygonCollection.size() > 0) {
                        this.exportPolygonFeatures(data, monitor, file, (FeatureCollection<SimpleFeatureType, SimpleFeature>)polygonCollection, schema, geomName, (MathTransform)mt);
                    }
                    if (pointCollection.size() > 0) {
                        this.exportPointFeatures(data, monitor, file, (FeatureCollection<SimpleFeatureType, SimpleFeature>)pointCollection, schema, geomName, (MathTransform)mt);
                    }
                    if (lineCollection.size() > 0) {
                        this.exportLineFeatures(data, monitor, file, (FeatureCollection<SimpleFeatureType, SimpleFeature>)lineCollection, schema, geomName, (MathTransform)mt);
                    }
                    break block18;
                }
                SimpleFeatureType destinationFeatureType = this.createFeatureType(schema, schema.getGeometryDescriptor().getType().getBinding(), crs);
                ReprojectingFeatureCollection processed = new ReprojectingFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)fc, monitor, destinationFeatureType, (MathTransform)mt);
                boolean success = this.writeToShapefile(processed, destinationFeatureType, file);
                if (success) {
                    this.addToCatalog(file, data);
                    break block18;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String msg = "No features were exported; did you select anything?";
                        CatalogUIPlugin.log(msg, null);
                        wizardDialog.setErrorMessage(msg);
                    }
                });
                return false;
            }
            catch (IOException e) {
                String msg = MessageFormat.format(Messages.CatalogExport_layerFail, resource.getIdentifier());
                CatalogUIPlugin.log(msg, e);
                wizardDialog.setErrorMessage(msg);
                return false;
            }
            catch (IllegalFilterException e) {
                String msg = MessageFormat.format(Messages.CatalogExport_layerFail, resource.getIdentifier());
                CatalogUIPlugin.log(msg, e);
                wizardDialog.setErrorMessage(msg);
                return false;
            }
            catch (SchemaException e) {
                String msg = MessageFormat.format(Messages.CatalogExport_layerFail, resource.getIdentifier());
                CatalogExport.setError(wizardDialog, msg, e);
                return false;
            }
            catch (FactoryException e) {
                String msg = resource.getIdentifier() + Messages.CatalogExport_reprojectError;
                CatalogExport.setError(wizardDialog, msg, e);
                return false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                if (e.getCause() instanceof TransformException) {
                    String msg = resource.getIdentifier() + Messages.CatalogExport_reprojectError;
                    CatalogExport.setError(wizardDialog, msg, e);
                } else {
                    String msg = MessageFormat.format(Messages.CatalogExport_layerFail, resource.getIdentifier());
                    CatalogExport.setError(wizardDialog, msg, e);
                }
                return false;
            }
        }
        return true;
    }

    private File determineDestinationFile(Data data) {
        File[] destination;
        block5: {
            ExportResourceSelectionState layerSelectState = this.findState();
            File exportDir = new File(layerSelectState.getExportDir());
            String typeName = data.getName();
            try {
                if (typeName == null) {
                    FeatureSource source = (FeatureSource)data.getResource().resolve(FeatureSource.class, (IProgressMonitor)new NullProgressMonitor());
                    typeName = ((SimpleFeatureType)source.getSchema()).getTypeName();
                }
                typeName = URLUtils.cleanFilename((String)typeName);
                destination = new File[]{this.addSuffix(new File(exportDir, typeName))};
                if (destination[0].exists()) {
                    this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            boolean overwrite;
                            String pattern = Messages.CatalogExportWizard_OverwriteDialogQuery;
                            String message = MessageFormat.format(pattern, destination[0].getName());
                            boolean bl = overwrite = !MessageDialog.openQuestion((Shell)CatalogExportWizard.this.getContainer().getShell(), (String)Messages.CatalogExportWizard_0, (String)message);
                            if (!overwrite) {
                                if (!destination[0].delete()) {
                                    destination[0] = CatalogExportWizard.this.selectFile(destination[0], Messages.CatalogExportWizard_UnableToDelete);
                                }
                            } else {
                                destination[0] = CatalogExportWizard.this.selectFile(destination[0], Messages.CatalogExportWizard_SelectFile);
                            }
                        }
                    });
                }
                if (destination[0] != null) break block5;
                return null;
            }
            catch (IOException e) {
                CatalogPlugin.log((String)"Stupidly got a IOException", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.addSuffix(destination[0]);
    }

    private File addSuffix(File file) {
        String extension;
        String path = this.stripEndSlash(file.getPath());
        if (path.endsWith(extension = "shp")) {
            return file;
        }
        File destination = new File(String.valueOf(path) + "." + extension);
        return destination;
    }

    private String stripEndSlash(String path) {
        if (path.endsWith("/")) {
            return this.stripEndSlash(path.substring(0, path.length() - 1));
        }
        return path;
    }

    private File selectFile(File destination, String string) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(string);
        dialog.setFilterPath(destination.getParent());
        dialog.setFileName(destination.getName());
        String file = dialog.open();
        destination = file == null ? null : new File(file);
        return destination;
    }

    private ExportResourceSelectionState findState() {
        State[] states;
        State[] stateArray = states = this.getWorkflow().getStates();
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            if (ExportResourceSelectionState.class.isAssignableFrom(state.getClass())) {
                return (ExportResourceSelectionState)state;
            }
            ++n2;
        }
        return this.getWorkflow().getState(ExportResourceSelectionState.class);
    }

    private void selectInCatalog() {
        if (!this.select) {
            return;
        }
        ExportResourceSelectionState layerSelectState = this.getWorkflow().getState(ExportResourceSelectionState.class);
        List<Data> resources = layerSelectState.getExportData();
        final ArrayList<IGeoResource> exported = new ArrayList<IGeoResource>(resources.size());
        for (Data data : resources) {
            exported.addAll(data.getExportedResources());
        }
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CatalogView catalogView = CatalogExportWizard.this.getCatalogView();
                if (catalogView != null) {
                    catalogView.getSite().getPage().activate((IWorkbenchPart)catalogView);
                    catalogView.getTreeviewer().setSelection(this.toTreePathSelection(exported), true);
                }
            }

            private ISelection toTreePathSelection(List<IGeoResource> exported2) {
                ArrayList<TreePath> paths = new ArrayList<TreePath>(exported2.size());
                for (IGeoResource resource : exported2) {
                    paths.add(new TreePath(this.toTreePath(resource).toArray()));
                }
                return new TreeSelection(paths.toArray(new TreePath[paths.size()]));
            }

            private List<IResolve> toTreePath(IGeoResource resource) {
                IResolve parent;
                try {
                    parent = resource.parent(ProgressManager.instance().get(new Object[0]));
                }
                catch (IOException e) {
                    CatalogUIPlugin.log("Error resolving the parent", e);
                    parent = null;
                }
                ArrayList<IResolve> path = new ArrayList<IResolve>();
                if (parent instanceof IGeoResource) {
                    IGeoResource parentResource = (IGeoResource)parent;
                    path.addAll(this.toTreePath(parentResource));
                } else if (parent instanceof IService) {
                    IService service = (IService)parent;
                    path.add((IResolve)service);
                }
                path.add((IResolve)resource);
                return path;
            }
        }, (boolean)true);
    }

    private CatalogView getCatalogView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        try {
            IViewPart catalogView = page.showView("net.refractions.udig.catalog.ui.CatalogView");
            return (CatalogView)catalogView;
        }
        catch (PartInitException e) {
            CatalogUIPlugin.log("Uh oh problem opening the catalog view", e);
            return null;
        }
    }

    private void exportLineFeatures(Data data, IProgressMonitor currentMonitor, File file, FeatureCollection<SimpleFeatureType, SimpleFeature> lineCollection, SimpleFeatureType schema, String geomName, MathTransform mt) throws IllegalFilterException, IOException, SchemaException, MalformedURLException {
        File lineFile = this.addFileNameSuffix(file, LINE_SUFFIX);
        SimpleFeatureType finalFeatureType = this.createFeatureType(schema, MultiLineString.class, data.getCRS());
        ToMultiLineFeatureCollection temp = new ToMultiLineFeatureCollection(lineCollection, finalFeatureType, schema.getGeometryDescriptor(), mt, currentMonitor);
        if (this.writeToShapefile((FeatureCollection<SimpleFeatureType, SimpleFeature>)temp, finalFeatureType, lineFile)) {
            this.addToCatalog(lineFile, data);
        }
    }

    private void exportPointFeatures(Data data, IProgressMonitor currentMonitor, File file, FeatureCollection<SimpleFeatureType, SimpleFeature> pointCollection, SimpleFeatureType schema, String geomName, MathTransform mt) throws IllegalFilterException, IOException, SchemaException, MalformedURLException {
        File pointFile = this.addFileNameSuffix(file, POINT_SUFFIX);
        SimpleFeatureType createFeatureType = this.createFeatureType(schema, MultiPoint.class, data.getCRS());
        ToMultiPointFeatureCollection temp = new ToMultiPointFeatureCollection(pointCollection, createFeatureType, schema.getGeometryDescriptor(), mt, currentMonitor);
        if (this.writeToShapefile((FeatureCollection<SimpleFeatureType, SimpleFeature>)temp, createFeatureType, pointFile)) {
            this.addToCatalog(pointFile, data);
        }
    }

    private void exportPolygonFeatures(Data data, IProgressMonitor currentMonitor, File file, FeatureCollection<SimpleFeatureType, SimpleFeature> polygonCollection, SimpleFeatureType schema, String geomName, MathTransform mt) throws IllegalFilterException, IOException, SchemaException, MalformedURLException {
        File polyFile = this.addFileNameSuffix(file, POLY_SUFFIX);
        SimpleFeatureType createFeatureType = this.createFeatureType(schema, MultiPolygon.class, data.getCRS());
        ToMultiPolygonFeatureCollection temp = new ToMultiPolygonFeatureCollection(polygonCollection, createFeatureType, schema.getGeometryDescriptor(), mt, currentMonitor);
        if (this.writeToShapefile((FeatureCollection<SimpleFeatureType, SimpleFeature>)temp, createFeatureType, polyFile)) {
            this.addToCatalog(polyFile, data);
        }
    }

    private SimpleFeatureType createFeatureType(SimpleFeatureType schema, Class<? extends Geometry> geomBinding, CoordinateReferenceSystem crs) throws SchemaException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("type");
        try {
            crs.toWKT();
        }
        catch (UnformattableObjectException unformattableObjectException) {
            crs = null;
        }
        int i = 0;
        while (i < schema.getAttributeCount()) {
            AttributeDescriptor attribute = schema.getDescriptor(i);
            if (!(attribute instanceof GeometryDescriptor)) {
                builder.add(attribute);
            } else {
                GeometryDescriptor geom = schema.getGeometryDescriptor();
                builder.crs(crs).defaultValue(null).restrictions(geom.getType().getRestrictions()).nillable(geom.isNillable()).add(geom.getLocalName(), geomBinding);
            }
            ++i;
        }
        return builder.buildFeatureType();
    }

    private void addToCatalog(File file, Data data) throws IOException {
        IProgressMonitor monitor = ProgressManager.instance().get(new Object[0]);
        IServiceFactory sFactory = CatalogPlugin.getDefault().getServiceFactory();
        ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
        URL url = URLUtils.fileToURL((File)file);
        List services = sFactory.createService(url);
        monitor.beginTask("add to catalog", services.size() * 10);
        for (IService service : services) {
            IService registeredService = catalog.add(service);
            SubProgressMonitor monitor2 = new SubProgressMonitor(monitor, 10);
            List contents = registeredService.resources((IProgressMonitor)monitor2);
            data.addNewResources(contents);
        }
    }

    private boolean isAbstractGeometryType(SimpleFeatureType schema) {
        Class geometryType = schema.getGeometryDescriptor().getType().getBinding();
        return geometryType.isAssignableFrom(Geometry.class);
    }

    private File addFileNameSuffix(File file, String suffix) {
        String path = file.getPath();
        path = path.replaceAll(String.valueOf(POLY_SUFFIX) + SHAPEFILE_EXT, SHAPEFILE_EXT);
        path = path.replaceAll(String.valueOf(POINT_SUFFIX) + SHAPEFILE_EXT, SHAPEFILE_EXT);
        if ((path = path.replaceAll(String.valueOf(LINE_SUFFIX) + SHAPEFILE_EXT, SHAPEFILE_EXT)).toLowerCase().endsWith(SHAPEFILE_EXT)) {
            String start = path.substring(0, path.length() - 4);
            String end = path.substring(path.length() - 4);
            return new File(String.valueOf(start) + suffix + end);
        }
        return null;
    }

    private Filter createGeometryTypeFilter(String geomName, String type) throws IllegalFilterException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Function function = ff.function("geometryType", new Expression[]{ff.property(geomName)});
        return ff.equal((Expression)function, (Expression)ff.literal((Object)type));
    }

    private boolean writeToShapefile(FeatureCollection<SimpleFeatureType, SimpleFeature> fc, SimpleFeatureType type, File file) throws IOException {
        if (!this.canWrite(file)) {
            throw new IOException(MessageFormat.format(Messages.CatalogExport_cannotWrite, file.getAbsolutePath()));
        }
        URL shpFileURL = URLUtils.fileToURL((File)file);
        IndexedShapefileDataStore ds = new IndexedShapefileDataStore(shpFileURL);
        ds.createSchema(type);
        int[] count = new int[1];
        FeatureStore featureSource = (FeatureStore)ds.getFeatureSource();
        List ids = featureSource.addFeatures(fc);
        count[0] = ids.size();
        return count[0] >= 0;
    }

    private boolean canWrite(File file) throws IOException {
        if (file.exists()) {
            return file.canWrite();
        }
        return file.createNewFile();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getWorkflow().getState(ExportResourceSelectionState.class).selection = selection;
    }
}

