/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui.export;

import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.export.CatalogExportWizard;
import net.refractions.udig.catalog.ui.export.ExportResourceSelectionPage;
import net.refractions.udig.catalog.ui.export.ExportResourceSelectionState;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.BasicWorkflowWizardPageFactory;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardAdapter;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardDialog;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CatalogExport {
    Shell shell;
    private WorkflowWizardDialog dialog;
    protected WorkflowWizard wizard;
    static String SHAPEFILE_EXT = ".shp";
    static String POLY_SUFFIX = "_poly";
    static String POINT_SUFFIX = "_point";
    static String LINE_SUFFIX = "_line";

    public CatalogExport() {
        this.initWorkflow();
    }

    public CatalogExport(boolean initialize) {
        if (initialize) {
            this.initWorkflow();
        }
    }

    protected final void initDialog() {
        this.initWorkflow();
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CatalogExport.this.shell = CatalogExport.this.createShell();
            }
        });
        this.dialog = new WorkflowWizardDialog(this.shell, this.wizard);
        this.dialog.setBlockOnOpen(true);
    }

    protected void initWorkflow() {
        Workflow workflow = this.createWorkflow();
        Map<Class<? extends State>, WorkflowWizardPageProvider> map = this.createPageMapping();
        this.wizard = this.createWorkflowWizard(workflow, map);
    }

    Shell createShell() {
        Shell temp;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (temp = window.getShell()) != null) {
            return temp;
        }
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (d == null) {
            d = Display.getCurrent();
        }
        return new Shell(d.getActiveShell());
    }

    public WorkflowWizardDialog getDialog() {
        if (this.dialog == null) {
            this.initDialog();
        }
        return this.dialog;
    }

    public void open() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CatalogExport.this.getDialog().open();
            }
        });
    }

    public void run(IProgressMonitor monitor, Object context) {
        if (this.dialog == null) {
            this.initDialog();
        }
        this.dialog.getWorkflowWizard().getWorkflow().setContext(context);
        String name = Messages.CatalogExport_taskname;
        monitor.beginTask(name, 100);
        monitor.setTaskName(name);
        try {
            this.dialog.runHeadless((IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        finally {
            monitor.done();
        }
    }

    protected Workflow createWorkflow() {
        ExportResourceSelectionState layerState = new ExportResourceSelectionState();
        Workflow workflow = new Workflow(new State[]{layerState});
        return workflow;
    }

    protected Map<Class<? extends State>, WorkflowWizardPageProvider> createPageMapping() {
        HashMap<Class<? extends State>, WorkflowWizardPageProvider> map = new HashMap<Class<? extends State>, WorkflowWizardPageProvider>();
        String title = Messages.LayerSelectionPage_title;
        ImageDescriptor banner = CatalogUIPlugin.getDefault().getImageDescriptor("wizban/exportshapefile_wiz.gif");
        ExportResourceSelectionPage page = new ExportResourceSelectionPage("Select Layers", title, banner);
        map.put(ExportResourceSelectionState.class, new BasicWorkflowWizardPageFactory(page));
        return map;
    }

    protected WorkflowWizard createWorkflowWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map) {
        return new CatalogExportWizard(workflow, map);
    }

    public static void setError(final WizardDialog wizardDialog, final String msg, Throwable e) {
        CatalogUIPlugin.log(msg, e);
        if (Display.getCurrent() == null) {
            wizardDialog.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    wizardDialog.setErrorMessage(msg);
                }
            });
        } else {
            wizardDialog.setErrorMessage(msg);
        }
    }

    public static class CatalogExportAdapter
    extends WorkflowWizardAdapter {
        public CatalogExportAdapter() {
            super(new CatalogExport().wizard);
        }
    }
}

