/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionFactoryDescriptor;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import org.eclipse.core.runtime.CoreException;

public abstract class UDIGConnectionFactory {
    public static final String XPID = "net.refractions.udig.catalog.ui.connectionFactory";
    protected UDIGConnectionFactoryDescriptor descriptor;

    public boolean canProcess(Object context) {
        Map<String, Serializable> params = this.createConnectionParameters(context);
        if (params != null) {
            return true;
        }
        URL url = this.createConnectionURL(context);
        return url != null;
    }

    public abstract Map<String, Serializable> createConnectionParameters(Object var1);

    public abstract URL createConnectionURL(Object var1);

    public void setDescriptor(UDIGConnectionFactoryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public UDIGConnectionPage createConnectionPage(int pageIndex) {
        try {
            return this.descriptor.createConnectionPage(pageIndex);
        }
        catch (CoreException e) {
            CatalogUIPlugin.log(e.getLocalizedMessage(), e);
            return null;
        }
    }
}

