/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.ResolveLabelProviderSimple;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ResolveTitlesDecorator
implements ILabelDecorator,
IColorDecorator,
IFontDecorator {
    static final Set<ILabelProviderListener> listeners = new CopyOnWriteArraySet<ILabelProviderListener>();
    final Set<ILabelProviderListener> instanceListeners = new HashSet<ILabelProviderListener>();
    private ResolveLabelProviderSimple source;
    private final Map<IResolve, LabelData> decorated = new IdentityHashMap<IResolve, LabelData>();
    private final Map<IResolve, LabelData> images = new IdentityHashMap<IResolve, LabelData>();
    private final Map<IResolve, ImageDescriptor> imageDescriptorCache = new IdentityHashMap<IResolve, ImageDescriptor>();
    final Queue<IResolve> toDecorate = new ConcurrentLinkedQueue<IResolve>();
    final Queue<IResolve> imagesToDecorate = new ConcurrentLinkedQueue<IResolve>();
    final UpdateLabel textWorker = new UpdateLabel(this.toDecorate, this.decorated, true);
    final Queue<UpdateLabel> availableImageWorkers = new ConcurrentLinkedQueue<UpdateLabel>();
    final List<UpdateLabel> allImageWorkers = new ArrayList<UpdateLabel>();
    private volatile boolean disposed;
    private Font brokenFont;
    private IResolveChangeListener listener = new IResolveChangeListener(){

        public void changed(IResolveChangeEvent event) {
            ArrayList changed;
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            if (event.getType() == IResolveChangeEvent.Type.POST_CHANGE && event.getDelta() != null && !(changed = new ArrayList()).isEmpty()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        LabelProviderChangedEvent labelEvent = new LabelProviderChangedEvent((IBaseLabelProvider)ResolveTitlesDecorator.this.source, changed.toArray());
                        for (ILabelProviderListener l : listeners) {
                            l.labelProviderChanged(labelEvent);
                        }
                    }
                };
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(runnable);
                } else {
                    runnable.run();
                }
            }
        }

        private void updateCache(IResolveDelta delta, List<IResolve> changed) {
            if (delta.getKind() == IResolveDelta.Kind.REPLACED || delta.getKind() == IResolveDelta.Kind.REMOVED || delta.getKind() == IResolveDelta.Kind.CHANGED) {
                if (delta.getResolve() != null) {
                    ResolveTitlesDecorator.this.decorated.remove(delta.getResolve());
                    changed.add(delta.getResolve());
                }
                List children = delta.getChildren();
                for (IResolveDelta delta2 : children) {
                    this.updateCache(delta2, changed);
                }
            }
        }
    };
    private boolean decorateImages;

    public ResolveTitlesDecorator(ResolveLabelProviderSimple resolveLabelProviderSimple) {
        this(resolveLabelProviderSimple, false);
    }

    public ResolveTitlesDecorator(ResolveLabelProviderSimple resolveLabelProviderSimple, boolean decorateImages) {
        this.source = resolveLabelProviderSimple;
        this.decorateImages = decorateImages;
        CatalogPlugin.addListener((IResolveChangeListener)this.listener);
        CatalogPlugin.removeListener((IResolveChangeListener)this.source);
        int i = 0;
        while (i < 4) {
            UpdateLabel worker = new UpdateLabel(this.imagesToDecorate, this.images, false);
            this.availableImageWorkers.add(worker);
            this.allImageWorkers.add(worker);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image decorateImage(Image image, Object element) {
        ImageRegistry imageRegistry;
        LabelData data;
        if (this.disposed) {
            return null;
        }
        if (!(element instanceof IResolve)) {
            return null;
        }
        IResolve resolve = (IResolve)element;
        if (this.images.containsKey(element) && (data = this.images.get(element)) == null) {
            return null;
        }
        ImageRegistry imageRegistry2 = imageRegistry = CatalogUIPlugin.getDefault().getImageRegistry();
        synchronized (imageRegistry2) {
            Image i = imageRegistry.get(resolve.getIdentifier().toString());
            if (i != null && !i.isDisposed()) {
                return i;
            }
            if (i != null && i.isDisposed()) {
                imageRegistry.remove(resolve.getIdentifier().toString());
            }
        }
        if (!resolve.getID().isLocal() && !this.decorateImages) {
            return null;
        }
        this.images.put(resolve, null);
        this.imagesToDecorate.offer(resolve);
        imageRegistry2 = imageRegistry;
        synchronized (imageRegistry2) {
            UpdateLabel imageWorker = this.availableImageWorkers.poll();
            if (imageWorker != null) {
                imageWorker.schedule();
            }
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        if (this.disposed) {
            return null;
        }
        if (!(element instanceof IResolve)) {
            return null;
        }
        IResolve resolve = (IResolve)element;
        if (this.decorated.containsKey(element)) {
            LabelData data = this.decorated.get(element);
            if (data == null) {
                return null;
            }
            if (resolve instanceof IService && resolve.getID().getTypeQualifier() != null) {
                return String.valueOf(data.text) + " (" + resolve.getID().getTypeQualifier() + ")";
            }
            return data.text;
        }
        this.decorated.put(resolve, null);
        if (resolve.getTitle() != null) {
            LabelData data = new LabelData();
            data.text = resolve.getTitle();
            this.decorated.put(resolve, data);
            if (resolve instanceof IService && resolve.getID().getTypeQualifier() != null) {
                return String.valueOf(data.text) + " (" + resolve.getID().getTypeQualifier() + ")";
            }
            return data.text;
        }
        this.toDecorate.offer(resolve);
        this.textWorker.schedule();
        return null;
    }

    public Color decorateBackground(Object element) {
        return null;
    }

    public Color decorateForeground(Object element) {
        if (this.disposed) {
            return null;
        }
        if (!(element instanceof IResolve)) {
            return null;
        }
        IResolve resolve = (IResolve)element;
        if (resolve.getStatus() == IResolve.Status.BROKEN) {
            return Display.getCurrent().getSystemColor(3);
        }
        if (resolve.getStatus() == IResolve.Status.RESTRICTED_ACCESS) {
            return Display.getCurrent().getSystemColor(8);
        }
        return null;
    }

    public Font decorateFont(Object element) {
        if (!(element instanceof IResolve)) {
            return null;
        }
        IResolve resolve = (IResolve)element;
        if (resolve.getStatus() == IResolve.Status.BROKEN || resolve.getStatus() == IResolve.Status.RESTRICTED_ACCESS) {
            return this.getBrokenFont();
        }
        return null;
    }

    private Font getBrokenFont() {
        if (this.brokenFont == null) {
            Font systemFont = Display.getCurrent().getSystemFont();
            FontData fd = systemFont.getFontData()[0];
            this.brokenFont = new Font(systemFont.getDevice(), fd.getName(), fd.getHeight(), 2);
        }
        return this.brokenFont;
    }

    public void dispose() {
        assert (Display.getCurrent() != null);
        this.disposed = true;
        this.toDecorate.clear();
        this.textWorker.cancel();
        this.images.clear();
        for (UpdateLabel updater : this.allImageWorkers) {
            updater.cancel();
        }
        this.decorated.clear();
        listeners.removeAll(this.instanceListeners);
        this.instanceListeners.clear();
        CatalogPlugin.removeListener((IResolveChangeListener)this.listener);
        if (this.brokenFont != null) {
            this.brokenFont.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public ILabelProvider getSource() {
        return this.source;
    }

    public void removeListener(ILabelProviderListener listener) {
        assert (Display.getCurrent() != null);
        listeners.remove(listener);
        this.instanceListeners.remove(listener);
    }

    public void addListener(ILabelProviderListener listener) {
        assert (Display.getCurrent() != null);
        listeners.add(listener);
        this.instanceListeners.add(listener);
    }

    static /* synthetic */ Map access$2(ResolveTitlesDecorator resolveTitlesDecorator) {
        return resolveTitlesDecorator.images;
    }

    static /* synthetic */ boolean access$4(ResolveTitlesDecorator resolveTitlesDecorator) {
        return resolveTitlesDecorator.disposed;
    }

    private class DisplayUpdater
    implements Runnable {
        IProgressMonitor monitor;
        Queue<IResolve> updates = new LinkedList<IResolve>();

        public DisplayUpdater(IProgressMonitor monitor2) {
            this.monitor = monitor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (!ResolveTitlesDecorator.access$4(ResolveTitlesDecorator.this)) ** GOTO lbl16
            return;
lbl-1000:
            // 1 sources

            {
                var2_2 = this.updates;
                synchronized (var2_2) {
                    element = this.updates.toArray();
                    this.updates.clear();
                }
                for (ILabelProviderListener l : ResolveTitlesDecorator.listeners) {
                    if (this.monitor.isCanceled()) {
                        return;
                    }
                    l.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ResolveTitlesDecorator.access$0(ResolveTitlesDecorator.this), element));
                }
lbl16:
                // 2 sources

                ** while (!this.updates.isEmpty())
            }
lbl17:
            // 1 sources

        }
    }

    private static class LabelData {
        public ImageDescriptor image;
        String text;

        private LabelData() {
        }
    }

    private class UpdateLabel
    extends Job {
        DisplayUpdater updater;
        private Queue<IResolve> toDecorate;
        private Map<IResolve, LabelData> decorated;
        private boolean text;

        public UpdateLabel(Queue<IResolve> toDecorate, Map<IResolve, LabelData> decorated, boolean text) {
            super("Decorate Resolve " + (text ? "Titles" : "Images"));
            this.setSystem(true);
            this.setPriority(50);
            this.toDecorate = toDecorate;
            this.decorated = decorated;
            this.text = text;
        }

        /*
         * Exception decompiling
         */
        public IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addUpdate(IProgressMonitor monitor, IResolve element) {
            Queue<IResolve> queue = this.updater.updates;
            synchronized (queue) {
                if (this.updater.updates.isEmpty()) {
                    this.updater = new DisplayUpdater(monitor);
                    this.updater.updates.add(element);
                    final Display display = Display.getDefault();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            display.timerExec(500, (Runnable)UpdateLabel.this.updater);
                        }
                    });
                } else {
                    this.updater.updates.add(element);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image creatImage(LabelData data, IResolve element) throws IOException {
            Image i;
            ImageRegistry imageRegistry;
            String key = element.getIdentifier().toString();
            ImageRegistry imageRegistry2 = imageRegistry = CatalogUIPlugin.getDefault().getImageRegistry();
            synchronized (imageRegistry2) {
                i = imageRegistry.get(key);
            }
            if (i == null || i.isDisposed()) {
                data.image = CatalogUIPlugin.icon(element);
                ResolveTitlesDecorator.this.imageDescriptorCache.put(element, data.image);
                try {
                    if (data.image != null) {
                        i = data.image.createImage();
                    }
                }
                catch (Throwable e) {
                    CatalogUIPlugin.log("Error creating the Image for the resource", e);
                }
            } else {
                data.image = (ImageDescriptor)ResolveTitlesDecorator.this.imageDescriptorCache.get(element);
            }
            if (i == null) {
                i = CatalogUIPlugin.image(element);
            }
            imageRegistry2 = imageRegistry;
            synchronized (imageRegistry2) {
                Image i2 = imageRegistry.get(key);
                if (i2 != null && !i2.isDisposed()) {
                    return i;
                }
                if (i2 != null && i2.isDisposed()) {
                    imageRegistry.remove(key);
                }
                imageRegistry.put(key, i);
            }
            return i;
        }
    }
}

