/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.File;
import java.net.URL;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.ui.internal.Messages;

public class Identifier {
    public static final boolean isFile(URL url) {
        return "file".equals(url.getProtocol());
    }

    public static boolean isGraphic(URL url) {
        String HOST = url.getHost();
        String PROTOCOL = url.getProtocol();
        String PATH = url.getPath();
        if ("mapgraphic".equals(PROTOCOL)) {
            return true;
        }
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (!"localhost".equals(HOST)) {
            return false;
        }
        return "/mapgraphic".equals(PATH);
    }

    public static boolean isMemory(URL url) {
        String HOST = url.getHost();
        String PROTOCOL = url.getProtocol();
        String PATH = url.getPath();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (!"localhost".equals(HOST)) {
            return false;
        }
        return "/scratch".equals(PATH);
    }

    public static boolean isWMS(URL url) {
        String PATH = url.getPath();
        String QUERY = url.getQuery();
        String PROTOCOL = url.getProtocol();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=WMS") != -1) {
            return true;
        }
        return PATH != null && PATH.toUpperCase().indexOf("GEOSERVER/WMS") != -1;
    }

    public static final boolean isWFS(URL url) {
        String PATH = url.getPath();
        String QUERY = url.getQuery();
        String PROTOCOL = url.getProtocol();
        if (!"http".equals(PROTOCOL)) {
            return false;
        }
        if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=WFS") != -1) {
            return true;
        }
        return PATH != null && PATH.toUpperCase().indexOf("GEOSERVER/WFS") != -1;
    }

    public static final boolean isJDBC(URL url) {
        return new ID(url).isJDBC();
    }

    public static final String labelResource(URL url) {
        if (url == null) {
            return Messages.ResolveLabelProvider_missingText;
        }
        String HOST = url.getHost();
        String QUERY = url.getQuery();
        String PATH = url.getPath();
        String PROTOCOL = url.getProtocol();
        String REF = url.getRef();
        if (REF != null) {
            return REF;
        }
        if (PROTOCOL == null) {
            return "";
        }
        StringBuffer label = new StringBuffer();
        if ("file".equals(PROTOCOL)) {
            int split = PATH.lastIndexOf(47);
            if (split == -1) {
                label.append(PATH);
            } else {
                String file = PATH.substring(split + 1);
                int dot = file.lastIndexOf(46);
                if (dot != -1) {
                    file = file.substring(0, dot);
                }
                label.append(file);
            }
        } else if ("http".equals(PROTOCOL) && HOST.indexOf(".jdbc") != -1) {
            if (QUERY != null) {
                label.append(QUERY);
            } else {
                label.append(PATH);
            }
        } else if ("http".equals(PROTOCOL)) {
            if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=WFS") != -1) {
                String[] stringArray = QUERY.split("&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String split = stringArray[n2];
                    if (split.toLowerCase().startsWith("type=")) {
                        label.append(split.substring(5));
                    }
                    ++n2;
                }
            } else if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=WMS") != -1) {
                String[] stringArray = QUERY.split("&");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String split = stringArray[n3];
                    if (split.startsWith("LAYER=")) {
                        label.append(split.substring(6));
                    }
                    ++n3;
                }
            } else {
                int split = PATH.lastIndexOf(47);
                if (split == -1) {
                    label.append(PATH);
                } else {
                    label.append(PATH.substring(split + 1));
                }
            }
        } else {
            int split = PATH.lastIndexOf(47);
            if (split == -1) {
                label.append(PATH);
            } else {
                label.append(PATH.substring(split + 1));
            }
        }
        return label.toString();
    }

    public static final String labelServer(URL url) {
        if (url == null) {
            return Messages.ResolveLabelProvider_missingText;
        }
        String HOST = url.getHost();
        int PORT = url.getPort();
        String PATH = url.getPath();
        String PROTOCOL = url.getProtocol();
        if (PROTOCOL == null) {
            return "";
        }
        StringBuffer label = new StringBuffer();
        if (Identifier.isFile(url)) {
            String[] split = PATH.split("\\/");
            if (split.length == 0) {
                label.append(File.separatorChar);
            } else {
                if (split.length < 2) {
                    label.append(File.separatorChar);
                    label.append(split[0]);
                    label.append(File.separatorChar);
                } else {
                    label.append(split[split.length - 2]);
                    label.append(File.separatorChar);
                }
                label.append(split[split.length - 1]);
            }
        } else if (Identifier.isJDBC(url)) {
            int split2 = HOST.lastIndexOf(46);
            int split1 = HOST.lastIndexOf(46, split2 - 1);
            label.append(HOST.substring(split1 + 1, split2));
            label.append("://");
            label.append(HOST.subSequence(0, split1));
        } else if ("http".equals(PROTOCOL) || "https".equals(PROTOCOL)) {
            if (Identifier.isWMS(url)) {
                label.append("wms://");
            } else if (Identifier.isWFS(url)) {
                label.append("wfs://");
            }
            label.append(HOST);
        } else {
            label.append(PROTOCOL);
            label.append("://");
            label.append(HOST);
        }
        if (PORT != -1) {
            label.append(":");
            label.append(PORT);
        }
        return label.toString();
    }
}

