/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.service.FormatProvider;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;

public class FileConnectionFactory
extends UDIGConnectionFactory {
    private static final String FILE_FORMAT_EXTENSION = "net.refractions.udig.catalog.ui.fileFormat";
    private ArrayList<String> extensionList;
    private ArrayList<FileType> typeList;

    @Override
    public boolean canProcess(Object context) {
        return this.createConnectionURL(context) != null;
    }

    @Override
    public Map<String, Serializable> createConnectionParameters(Object context) {
        return null;
    }

    @Override
    public URL createConnectionURL(Object context) {
        URL url = CatalogPlugin.locateURL((Object)context);
        if (url == null) {
            return null;
        }
        if ((url = FileConnectionFactory.checkedURL(url)) == null || url.getFile() == null) {
            return null;
        }
        String fileExt = url.getFile().substring(url.getFile().lastIndexOf(46) + 1);
        if (fileExt != null) {
            fileExt = fileExt.toLowerCase();
        }
        for (String goodExt : this.getExtensionList()) {
            File f;
            if (!fileExt.equals((goodExt = goodExt.toLowerCase()).substring(goodExt.lastIndexOf(46) + 1)) || !(f = URLUtils.urlToFile((URL)url)).exists()) continue;
            return url;
        }
        return null;
    }

    public static URL checkedURL(URL url) {
        String check = url.toExternalForm();
        int hash = check.indexOf(35);
        if (hash == -1) {
            return url;
        }
        try {
            return new URL(check.substring(0, hash));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    synchronized List<FileType> getTypeList() {
        if (this.typeList == null) {
            final TreeSet extensionSet = new TreeSet();
            ExtensionPointUtil.process((Plugin)CatalogUIPlugin.getDefault(), (String)FILE_FORMAT_EXTENSION, (ExtensionPointProcessor)new ExtensionPointProcessor(){

                public void process(IExtension extension, IConfigurationElement element) throws Exception {
                    if ("fileService".equals(element.getName())) {
                        String name = element.getAttribute("name");
                        String ext = element.getAttribute("fileExtension");
                        if (name == null && ext.startsWith("*.")) {
                            name = ext.contains(";") ? String.valueOf(ext.substring(2, ext.lastIndexOf(59)).toUpperCase()) + " Files" : String.valueOf(ext.substring(2).toUpperCase()) + " Files";
                        }
                        if (!name.contains("(")) {
                            name = String.valueOf(name) + " (" + ext.replace(";", ",") + ")";
                        }
                        FileType type = new FileType(name, ext);
                        extensionSet.add(type);
                    }
                    if ("provider".equals(element.getName())) {
                        FormatProvider provider = (FormatProvider)element.createExecutableExtension("class");
                        String name = null;
                        if (name == null) {
                            name = provider.getClass().getSimpleName();
                            if (name.equals("FileDataStoreFormatProvider")) {
                                name = "GeoTools DataStore Files";
                            } else if (name.endsWith("FormatProvider")) {
                                name = name.substring(0, name.length() - 14);
                                name = String.valueOf(name) + "Files";
                            }
                        }
                        StringBuilder ext = new StringBuilder();
                        Set<String> providerExtensions = provider.getExtensions();
                        if (!providerExtensions.isEmpty()) {
                            for (String fileExtension : providerExtensions) {
                                if (ext.length() != 0) {
                                    ext.append(";");
                                }
                                ext.append(fileExtension);
                            }
                            if (!name.contains("(")) {
                                if (providerExtensions.size() > 4) {
                                    String first = providerExtensions.iterator().next();
                                    name = String.valueOf(name) + " ( " + first + " and " + (providerExtensions.size() - 1) + " more)";
                                } else {
                                    name = String.valueOf(name) + " (" + ext.toString().replace(";", ",") + ")";
                                }
                            }
                            FileType type = new FileType(name, ext.toString());
                            extensionSet.add(type);
                        }
                    }
                }
            });
            this.typeList = new ArrayList(extensionSet);
        }
        return Collections.unmodifiableList(this.typeList);
    }

    synchronized List<String> getExtensionList() {
        if (this.extensionList == null) {
            ArrayList<String> extensionSet = new ArrayList<String>();
            for (FileType type : this.getTypeList()) {
                List<String> extensions = type.getExtensionList();
                extensionSet.addAll(extensions);
            }
            this.extensionList = new ArrayList(extensionSet);
        }
        return (List)this.extensionList.clone();
    }

    public static class FileType
    implements Comparable<FileType> {
        final String name;
        final String extensions;

        FileType(String name, String extensions) {
            this.name = name;
            this.extensions = extensions;
        }

        public String getName() {
            return this.name;
        }

        public String getExtensions() {
            return this.extensions;
        }

        public List<String> getExtensionList() {
            if (this.extensions.contains(";")) {
                return Arrays.asList(this.extensions.split(";"));
            }
            return Collections.singletonList(this.extensions);
        }

        @Override
        public int compareTo(FileType o) {
            if (o == null || o.name == null) {
                return -1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

