/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.ui.ConnectionPageDecorator;
import net.refractions.udig.catalog.ui.IConnectionErrorHandler;
import net.refractions.udig.catalog.ui.internal.Messages;
import net.refractions.udig.catalog.ui.workflow.ConnectionErrorState;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionErrorPage
extends WorkflowWizardPage {
    IConnectionErrorHandler handler;

    public ConnectionErrorPage() {
        super(Messages.ConnectionErrorPage_pageName);
        this.setDescription(Messages.ConnectionErrorPage_pageDescription);
        this.setTitle(Messages.ConnectionErrorPage_pageTitle);
    }

    public boolean isPageComplete() {
        return this.handler.isComplete();
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.handler != null) {
            return this.handler.canRecover();
        }
        return false;
    }

    public void createControl(Composite parent) {
        ConnectionErrorState state = (ConnectionErrorState)this.getState();
        this.handler = new SimpleConnectionErrorHandler(state.getErrors());
        this.handler.createControl(parent);
        this.setControl(this.handler.getControl());
    }

    public IWizardPage getNextPage() {
        if (this.handler.canRecover() && this.handler.isComplete()) {
            ConnectionPageDecorator page = (ConnectionPageDecorator)this.getPreviousPage();
            return page.getNextPage();
        }
        return super.getNextPage();
    }

    static class SimpleConnectionErrorHandler
    extends IConnectionErrorHandler {
        Map<IService, Throwable> errors;

        SimpleConnectionErrorHandler(Map<IService, Throwable> errors) {
            this.errors = errors;
            this.setName("Simple");
        }

        @Override
        public boolean canHandle(IService service, Throwable t) {
            return true;
        }

        @Override
        public boolean canRecover() {
            return false;
        }

        @Override
        protected Control create(Composite parent) {
            Composite root = new Composite(parent, 0);
            root.setLayout((Layout)new FormLayout());
            Label label = new Label(root, 16384);
            label.setText(Messages.ConnectionErrorPage_message);
            ListViewer listViewer = new ListViewer(root);
            listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    IService service = (IService)element;
                    return service.getIdentifier().toString();
                }
            });
            listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            listViewer.setInput((Object)this.errors.keySet().toArray());
            final Text text = new Text(root, 2563);
            FormData layoutData = new FormData();
            layoutData.top = new FormAttachment(0);
            layoutData.left = new FormAttachment(0);
            label.setLayoutData((Object)layoutData);
            layoutData = new FormData();
            layoutData.top = new FormAttachment((Control)label, 2, 1024);
            layoutData.left = new FormAttachment(0);
            layoutData.right = new FormAttachment(100);
            layoutData.bottom = new FormAttachment(50);
            listViewer.getList().setLayoutData((Object)layoutData);
            layoutData = new FormData();
            layoutData.top = new FormAttachment((Control)listViewer.getList(), 2, 1024);
            layoutData.left = new FormAttachment(0);
            layoutData.right = new FormAttachment(100);
            layoutData.bottom = new FormAttachment(100);
            text.setLayoutData((Object)layoutData);
            listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection == null || selection.isEmpty()) {
                        return;
                    }
                    IService service = (IService)selection.getFirstElement();
                    Throwable t = SimpleConnectionErrorHandler.this.errors.get(service);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    t.printStackTrace(new PrintStream(out));
                    text.setText(new String(out.toByteArray()));
                }
            });
            return root;
        }
    }
}

