/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.ui;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;

public abstract class AbstractUDIGConnectionFactory
extends UDIGConnectionFactory {
    @Override
    public final boolean canProcess(Object context) {
        ServiceExtension2 serviceExtension = this.getServiceExtension();
        if (context instanceof ID) {
            ID id = (ID)context;
            return this.canProcess(serviceExtension, id);
        }
        if (context instanceof URL) {
            URL url = (URL)context;
            return this.canProcess(serviceExtension, url);
        }
        if (context instanceof String) {
            String string = (String)context;
            try {
                URL url = new URL(string);
                if (this.canProcess(serviceExtension, url)) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (context instanceof Map) {
            Map map = (Map)context;
            return this.canProcess(serviceExtension, map);
        }
        if (context instanceof IResolve) {
            ID id = ((IResolve)context).getID();
            return this.canProcess(serviceExtension, id);
        }
        if (CatalogPlugin.locateURL((Object)context) != null) {
            return this.canProcess(serviceExtension, CatalogPlugin.locateURL((Object)context));
        }
        return this.doOtherChecks(context);
    }

    protected boolean canProcess(ServiceExtension2 serviceExtension, Map<String, Serializable> map) {
        return serviceExtension.reasonForFailure(map) == null;
    }

    protected boolean canProcess(ServiceExtension2 serviceExtension, URL url) {
        return serviceExtension.reasonForFailure(url) == null;
    }

    protected boolean canProcess(ServiceExtension2 serviceExtension, ID id) {
        return serviceExtension.reasonForFailure(id.toURL()) == null;
    }

    protected abstract boolean doOtherChecks(Object var1);

    protected abstract ServiceExtension2 getServiceExtension();

    @Override
    public final Map<String, Serializable> createConnectionParameters(Object context) {
        Map params;
        URL url;
        ServiceExtension2 serviceExtension = this.getServiceExtension();
        if (context instanceof URL && this.canProcess(serviceExtension, url = (URL)context)) {
            return serviceExtension.createParams(url);
        }
        if (context instanceof String) {
            String string = (String)context;
            try {
                URL url2 = new URL(string);
                if (this.canProcess(serviceExtension, url2)) {
                    return serviceExtension.createParams(url2);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (context instanceof Map && this.canProcess(serviceExtension, params = (Map)context)) {
            return params;
        }
        URL locateURL = CatalogPlugin.locateURL((Object)context);
        if (locateURL != null && this.canProcess(serviceExtension, locateURL)) {
            return serviceExtension.createParams(locateURL);
        }
        return this.doCreateConnectionParameters(context);
    }

    protected abstract Map<String, Serializable> doCreateConnectionParameters(Object var1);

    @Override
    public final URL createConnectionURL(Object context) {
        URL locateURL;
        URL url;
        ServiceExtension2 serviceExtension = this.getServiceExtension();
        if (context instanceof URL && this.canProcess(serviceExtension, url = (URL)context)) {
            return url;
        }
        if (context instanceof String) {
            String string = (String)context;
            try {
                URL url2 = new URL(string);
                if (this.canProcess(serviceExtension, url2)) {
                    return url2;
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if ((locateURL = CatalogPlugin.locateURL((Object)context)) != null && this.canProcess(serviceExtension, locateURL)) {
            return locateURL;
        }
        return this.doCreateConnectionURL(context);
    }

    protected abstract URL doCreateConnectionURL(Object var1);
}

