/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.service.database;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.service.database.DatabaseConnectionRunnable;
import net.refractions.udig.catalog.service.database.DatabaseServiceDialect;
import net.refractions.udig.catalog.service.database.DatabaseWizardLocalization;
import net.refractions.udig.catalog.service.database.ExtraParamsControl;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserHostPage
extends AbstractUDIGImportPage
implements UDIGConnectionPage {
    private static final String PREVIOUS_CONNECTIONS = "previous_settings";
    protected static final String TIMESTAMP = "TIMESTAMP";
    private static final String USERNAME = "USERNAME";
    private static final String HOST = "HOST";
    private static final String PORT = "PORT";
    protected static final String PASSWORD = "PASSWORD";
    private static final String SAVE_PASSWORD = "SAVE_PASSWORD";
    private static final String REQUIRED_DECORATION = "REQUIRED_DECORATION";
    private static final String DELETED = "DELETED";
    final DatabaseServiceDialect dialect;
    private final DatabaseWizardLocalization localization;
    private Text host;
    private Text port;
    private Text password;
    private Text username;
    private String[] databaseNames;
    private Button savePassword;
    private Combo previousConnections;
    private String defaultPort;
    private ExtraParamsControl extraParams;

    public UserHostPage(DatabaseServiceDialect dialect) {
        super("User and Host page");
        this.dialect = dialect;
        this.defaultPort = dialect.portParam.sample.toString();
        this.localization = dialect.localization;
    }

    @Override
    public Map<String, Serializable> getParams() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)top);
        this.createPreviousConnectionsCombo(top);
        this.host = this.createLabelAndText(top, String.valueOf(this.localization.host) + ":", 2048);
        this.host.setLayoutData((Object)new GridData(768));
        this.port = this.createLabelAndText(top, String.valueOf(this.localization.port) + ":", 2048);
        this.port.setText(this.defaultPort);
        this.port.setLayoutData((Object)new GridData());
        this.username = this.createLabelAndText(top, String.valueOf(this.localization.username) + ":", 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.username.setLayoutData((Object)data);
        this.password = this.createLabelAndText(top, String.valueOf(this.localization.password) + ":", 0x400800);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.password.setLayoutData((Object)data);
        this.savePassword = new Button(top, 32);
        this.savePassword.setText(this.localization.storePassword);
        GridDataFactory.swtDefaults().span(4, 1).applyTo((Control)this.savePassword);
        Button removeConnection = new Button(top, 8);
        GridDataFactory.swtDefaults().span(4, 1).indent(0, 10).applyTo((Control)removeConnection);
        removeConnection.setText(this.localization.removeConnection);
        removeConnection.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UserHostPage.this.removeConnection();
            }
        });
        this.extraParams = this.dialect.createHostPageExtraParamControl();
        if (this.extraParams != null) {
            final Button optionalParams = new Button(top, 32);
            optionalParams.setText(this.localization.optionalParams);
            GridDataFactory.swtDefaults().span(4, 1).applyTo((Control)optionalParams);
            optionalParams.setSelection(false);
            final Control extraParamsControl = this.extraParams.createControl(top);
            extraParamsControl.setVisible(false);
            data = new GridData(1808);
            data.horizontalSpan = 4;
            extraParamsControl.setLayoutData((Object)data);
            optionalParams.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    extraParamsControl.setVisible(optionalParams.getSelection());
                }
            });
        }
    }

    protected void removeConnection() {
        if (this.host.getText().length() == 0 && this.username.getText().length() == 0 && this.password.getText().length() == 0 && this.port.getText().equals(this.defaultPort)) {
            return;
        }
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)this.localization.removeConnection, (String)this.localization.confirmRemoveConnection);
        if (confirm) {
            this.host.setText("");
            this.port.setText(this.defaultPort);
            this.username.setText("");
            this.password.setText("");
            this.savePassword.setSelection(false);
            this.host.setFocus();
            int index = this.previousConnections.getSelectionIndex();
            String item = this.previousConnections.getItem(index);
            IDialogSettings settings = (IDialogSettings)this.previousConnections.getData(item);
            if (settings != null) {
                this.previousConnections.remove(index);
                this.previousConnections.setData(item, null);
                settings.put(DELETED, true);
            }
            if (this.previousConnections.getItemCount() <= 1) {
                this.previousConnections.setVisible(false);
            }
        }
    }

    private void createPreviousConnectionsCombo(Composite top) {
        Label label = new Label(top, 0);
        label.setText(this.localization.previousConnections);
        GridData gridData = new GridData(4, 128, false, false);
        label.setLayoutData((Object)gridData);
        this.previousConnections = new Combo(top, 8);
        this.populatePreviousConnections(this.previousConnections);
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 3;
        this.previousConnections.setLayoutData((Object)gridData);
        if (this.previousConnections.getItemCount() < 2) {
            this.previousConnections.setVisible(false);
        }
        this.previousConnections.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String item = UserHostPage.this.previousConnections.getItem(UserHostPage.this.previousConnections.getSelectionIndex());
                IDialogSettings settings = (IDialogSettings)UserHostPage.this.previousConnections.getData(item);
                if (settings != null) {
                    String host = settings.get(UserHostPage.HOST);
                    String port = settings.get(UserHostPage.PORT);
                    String username = settings.get(UserHostPage.USERNAME);
                    String password = settings.get(UserHostPage.PASSWORD);
                    boolean savedPassword = settings.getBoolean(UserHostPage.SAVE_PASSWORD);
                    UserHostPage.this.populateWidgets(host, port, username, password, savedPassword);
                    UserHostPage.this.password.setFocus();
                } else {
                    UserHostPage.this.populateWidgets("", UserHostPage.this.defaultPort, "", "", false);
                }
                UserHostPage.this.previousConnections.setToolTipText(item);
            }
        });
    }

    private void populateWidgets(String host2, String port2, String username2, String password2, boolean savePassword2) {
        this.host.setText(this.nullToString(host2));
        this.port.setText(this.nullToString(port2));
        this.username.setText(this.nullToString(username2));
        this.password.setText(this.nullToString(password2));
        this.savePassword.setSelection(savePassword2);
    }

    private String nullToString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private void populatePreviousConnections(Combo previousConnections) {
        IDialogSettings previous = this.getDialogSettings().getSection(PREVIOUS_CONNECTIONS);
        if (previous != null) {
            IDialogSettings[] sections = previous.getSections();
            Arrays.sort(sections, new Comparator<IDialogSettings>(){

                @Override
                public int compare(IDialogSettings o1, IDialogSettings o2) {
                    long time2;
                    long time1 = o1.getLong(UserHostPage.TIMESTAMP);
                    if (time1 > (time2 = o2.getLong(UserHostPage.TIMESTAMP))) {
                        return -1;
                    }
                    return 1;
                }
            });
            ArrayList<String> items = new ArrayList<String>(sections.length);
            items.add("");
            IDialogSettings[] iDialogSettingsArray = sections;
            int n = sections.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogSettings connection = iDialogSettingsArray[n2];
                if (!connection.getBoolean(DELETED)) {
                    StringBuilder name = new StringBuilder();
                    name.append(connection.get(USERNAME));
                    name.append('@');
                    name.append(connection.get(HOST));
                    name.append(':');
                    name.append(connection.get(PORT));
                    previousConnections.setData(name.toString(), (Object)connection);
                    items.add(name.toString());
                }
                ++n2;
            }
            previousConnections.setItems(items.toArray(new String[0]));
        }
    }

    protected IDialogSettings getDialogSettings() {
        return this.dialect.getDialogSetting();
    }

    private Text createLabelAndText(Composite parent, String labelText, int textStyle) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        final Text text = new Text(parent, textStyle);
        final ControlDecoration decoration = new ControlDecoration((Control)text, 16512);
        ImageRegistry imageRegistry = CatalogUIPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(REQUIRED_DECORATION);
        if (image == null) {
            image = CatalogUIPlugin.getDefault().getImageDescriptor("ovr16/warning_ovr.gif").createImage();
            imageRegistry.put(REQUIRED_DECORATION, image);
        }
        decoration.setImage(image);
        decoration.setDescriptionText(this.localization.requiredField);
        decoration.show();
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                UserHostPage.this.getContainer().updateButtons();
                boolean valid = UserHostPage.this.isValid(text);
                if (text.getText().trim().equals("") && valid) {
                    decoration.show();
                } else {
                    decoration.hide();
                }
            }
        });
        return text;
    }

    private boolean isValid(Text text) {
        if (text == this.port) {
            try {
                int i = Integer.parseInt(text.getText());
                if (i > 0) {
                    if (this.localization.portError.equals(this.getErrorMessage())) {
                        this.setErrorMessage(null);
                    }
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (!this.localization.portError.equals(this.getErrorMessage())) {
                this.setErrorMessage(this.localization.portError);
            }
            return false;
        }
        return true;
    }

    public boolean isPageComplete() {
        boolean validEntries;
        boolean enteredEntries = this.port.getText().trim().length() > 0 && this.host.getText().trim().length() > 0 && this.username.getText().trim().length() > 0;
        boolean bl = validEntries = this.isValid(this.port) && this.isValid(this.host) && this.isValid(this.username) && this.isValid(this.password);
        return enteredEntries && validEntries;
    }

    @Override
    public void shown() {
        this.populatePreviousConnections(this.previousConnections);
    }

    @Override
    public boolean leavingPage() {
        IDialogSettings[] allSections;
        IDialogSettings match;
        block13: {
            try {
                if (this.canConnect()) break block13;
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.setMessage(this.localization.databaseConnectionInterrupted);
                return false;
            }
        }
        this.setErrorMessage(null);
        IDialogSettings section = this.getDialogSettings().getSection(PREVIOUS_CONNECTIONS);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(PREVIOUS_CONNECTIONS);
        }
        if ((match = this.findMatchForCurrent(allSections = section.getSections())) != null) {
            if (this.savePassword.getSelection()) {
                String storedPass = match.get(PASSWORD);
                if (!this.password.getText().equals(storedPass)) {
                    if (storedPass == null || storedPass.length() == 0) {
                        match.put(PASSWORD, this.password.getText());
                    } else {
                        boolean choice = MessageDialog.openConfirm((Shell)this.getShell(), (String)this.localization.password, (String)this.localization.changePasswordQuery);
                        if (choice) {
                            match.put(PASSWORD, this.password.getText());
                        }
                    }
                }
            } else {
                match.put(PASSWORD, "");
            }
            match.put(SAVE_PASSWORD, this.savePassword.getSelection());
            match.put(TIMESTAMP, System.currentTimeMillis());
        } else {
            IDialogSettings params = section.addNewSection(String.valueOf(allSections.length + 1));
            params.put(HOST, this.host.getText());
            params.put(PORT, this.port.getText());
            params.put(USERNAME, this.username.getText());
            params.put(TIMESTAMP, System.currentTimeMillis());
            params.put(SAVE_PASSWORD, this.savePassword.getSelection());
            if (this.savePassword.getSelection()) {
                params.put(PASSWORD, this.password.getText());
            }
        }
        return true;
    }

    private boolean canConnect() throws InterruptedException {
        String host2 = this.nullToString(this.host.getText());
        String port2 = this.nullToString(this.port.getText());
        String username2 = this.nullToString(this.username.getText());
        String password2 = this.nullToString(this.password.getText());
        try {
            DatabaseConnectionRunnable runnable = this.dialect.createDatabaseConnectionRunnable(host2, Integer.parseInt(port2), username2, password2);
            this.getContainer().run(false, true, (IRunnableWithProgress)runnable);
            String connect = runnable.canConnect();
            if (connect != null) {
                this.setErrorMessage(connect);
            } else {
                this.setErrorMessage(null);
                this.databaseNames = runnable.getDatabaseNames();
            }
            return connect == null;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(String.valueOf(this.localization.unexpectedError) + ":" + e);
            this.dialect.log("Error while running database connection runnable", e);
            return false;
        }
    }

    private IDialogSettings findMatchForCurrent(IDialogSettings[] allSections) {
        IDialogSettings[] iDialogSettingsArray = allSections;
        int n = allSections.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings dialogSettings = iDialogSettingsArray[n2];
            boolean sameHost = this.host.getText().equalsIgnoreCase(dialogSettings.get(HOST));
            boolean samePort = Integer.parseInt(this.port.getText()) == dialogSettings.getInt(PORT);
            boolean sameUser = this.username.getText().equals(dialogSettings.get(USERNAME));
            if (sameHost && samePort && sameUser) {
                return dialogSettings;
            }
            ++n2;
        }
        return null;
    }

    public String[] getDatabaseNames() {
        return this.databaseNames;
    }

    public String getHost() {
        return this.host.getText();
    }

    public Integer getPort() {
        return Integer.parseInt(this.port.getText());
    }

    public String getUsername() {
        return this.username.getText();
    }

    public String getPassword() {
        return this.password.getText();
    }

    public Map<String, Serializable> addParams() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(this.dialect.hostParam.key, (Serializable)((Object)this.getHost()));
        params.put(this.dialect.portParam.key, this.getPort());
        params.put(this.dialect.usernameParam.key, (Serializable)((Object)this.getUsername()));
        params.put(this.dialect.passwordParam.key, (Serializable)((Object)this.getPassword()));
        if (this.extraParams != null) {
            params.putAll(this.extraParams.getParams());
        }
        return params;
    }
}

