/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.service.database;

import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.refractions.udig.catalog.service.database.DatabaseServiceDialect;
import net.refractions.udig.catalog.service.database.DatabaseWizardLocalization;
import net.refractions.udig.catalog.service.database.Tab;
import net.refractions.udig.catalog.service.database.TableDescriptor;
import net.refractions.udig.core.Either;
import net.refractions.udig.ui.graphics.Glyph;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TableSelectionTab
implements Tab {
    private static final int LAYOUT_COLUMNS = 3;
    private CheckboxTableViewer tableViewer;
    private Button publicSchema;
    private Text filterBox;
    private Set<Listener> listeners = new HashSet<Listener>();
    private final DatabaseServiceDialect dialect;
    private final DatabaseWizardLocalization localization;

    public TableSelectionTab(DatabaseServiceDialect dialect) {
        this.dialect = dialect;
        this.localization = dialect.localization;
    }

    @Override
    public void init() {
        if (this.tableViewer != null) {
            this.tableViewer.setInput(Collections.emptyList());
            this.filterBox.setText("");
        }
    }

    public Control createControl(Composite parent, int style) {
        Composite top = new Composite(parent, style);
        top.setLayout((Layout)new GridLayout(3, false));
        this.createFilterText(top);
        this.createFilterButtons(top);
        this.createTable(top);
        return top;
    }

    public void setTableInput(Collection<TableDescriptor> tables) {
        this.tableViewer.setInput(tables);
    }

    @Override
    public Either<String, Map<String, Serializable>> getParams(Map<String, Serializable> params) {
        Object[] elements = this.tableViewer.getCheckedElements();
        if (elements.length == 0) {
            return Either.createLeft(null);
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < elements.length) {
            TableDescriptor descriptor = (TableDescriptor)elements[i];
            if (descriptor.broken) {
                return Either.createLeft((Object)this.localization.brokenElements);
            }
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(descriptor.schema);
            ++i;
        }
        if (this.dialect.schemaParam != null) {
            params.put(this.dialect.schemaParam.key, (Serializable)((Object)builder.toString()));
        }
        return Either.createRight(params);
    }

    @Override
    public boolean leavingPage() {
        return true;
    }

    @Override
    public Collection<URL> getResourceIDs(Map<String, Serializable> params) {
        List<Object> elements = Arrays.asList(this.tableViewer.getCheckedElements());
        return this.dialect.constructResourceIDs(elements.toArray(new TableDescriptor[0]), params);
    }

    @Override
    public void addListener(Listener modifyListener) {
        this.listeners.add(modifyListener);
    }

    private void createTable(Composite top) {
        Table table = new Table(top, 65568);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(this.localization.table);
        TableColumn schemaColumn = new TableColumn(table, 16384);
        schemaColumn.setText(this.localization.schema);
        TableColumn geometryNameColumn = new TableColumn(table, 16384);
        geometryNameColumn.setText(this.localization.geometryName);
        TableColumn geometryTypeColumn = new TableColumn(table, 16384);
        geometryTypeColumn.setText(this.localization.geometryType);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new FilteringContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.addDoubleClickListener((IDoubleClickListener)new CheckOnDoubleClickListener());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                for (Listener l : TableSelectionTab.this.listeners) {
                    Event event2 = new Event();
                    event2.type = 24;
                    Control control = TableSelectionTab.this.tableViewer.getControl();
                    event2.display = control.getDisplay();
                    event2.widget = control;
                    l.handleEvent(event2);
                }
            }
        });
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TableDescriptor d1 = (TableDescriptor)e1;
                TableDescriptor d2 = (TableDescriptor)e2;
                return d1.name.compareTo(d2.name);
            }
        });
    }

    private void createFilterButtons(Composite top) {
        this.publicSchema = new Button(top, 32);
        this.publicSchema.setText(this.localization.publicSchema);
        this.publicSchema.setToolTipText(this.localization.publicSchemaTooltip);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TableSelectionTab.this.tableViewer.refresh(false);
            }
        };
        this.publicSchema.addListener(13, listener);
    }

    private void createFilterText(Composite top) {
        Label label = new Label(top, 0);
        label.setText(this.localization.filter);
        this.filterBox = new Text(top, 2048);
        this.filterBox.setLayoutData((Object)new GridData(768));
        this.filterBox.setToolTipText(this.localization.tableSelectionFilterTooltip);
        this.filterBox.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TableSelectionTab.this.tableViewer.refresh(false);
            }
        });
    }

    private final class CheckOnDoubleClickListener
    implements IDoubleClickListener {
        private CheckOnDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object[] elements;
            if (event.getSelection().isEmpty() || !(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection structured = (IStructuredSelection)event.getSelection();
            Object[] objectArray = elements = structured.toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                boolean state = TableSelectionTab.this.tableViewer.getChecked(element);
                TableSelectionTab.this.tableViewer.setChecked(element, !state);
                ++n2;
            }
        }
    }

    public class FilteringContentProvider
    extends ArrayContentProvider
    implements IContentProvider {
        public Object[] getElements(Object inputElement) {
            Collection tables = (Collection)inputElement;
            HashSet<TableDescriptor> filtered = new HashSet<TableDescriptor>();
            for (TableDescriptor table : tables) {
                if (TableSelectionTab.this.publicSchema.getSelection() && !table.schema.equals(((TableSelectionTab)TableSelectionTab.this).dialect.schemaParam.sample)) continue;
                Pattern filter = Pattern.compile("\\w*" + TableSelectionTab.this.filterBox.getText().toLowerCase() + "\\w*");
                boolean geometryTypeMatch = filter.matcher(table.geometryType.getSimpleName().toLowerCase()).matches();
                boolean nameMatch = filter.matcher(table.name.toLowerCase()).matches();
                boolean sridMatch = filter.matcher(table.srid.toLowerCase()).matches();
                boolean schemaMatch = true;
                if (table.schema != null) {
                    schemaMatch = filter.matcher(table.schema.toLowerCase()).matches();
                }
                if (!geometryTypeMatch && !nameMatch && !sridMatch && !schemaMatch) continue;
                filtered.add(table);
            }
            return filtered.toArray();
        }
    }

    public class TableLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider,
    ITableLabelProvider,
    IColorProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            TableDescriptor table = (TableDescriptor)element;
            switch (columnIndex) {
                case 3: {
                    if (table.broken) {
                        return null;
                    }
                    return Glyph.icon(table.geometryType).createImage();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TableDescriptor table = (TableDescriptor)element;
            switch (columnIndex) {
                case 0: {
                    return table.name;
                }
                case 1: {
                    return table.schema == null ? "" : table.schema;
                }
                case 2: {
                    if (table.broken) {
                        return ((TableSelectionTab)TableSelectionTab.this).localization.incorrectConfiguration;
                    }
                    return table.geometryColumn;
                }
                case 3: {
                    if (table.broken) {
                        return ((TableSelectionTab)TableSelectionTab.this).localization.incorrectConfiguration;
                    }
                    return table.geometryType.getSimpleName();
                }
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex) + " is not a valid index for this table");
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            TableDescriptor table = (TableDescriptor)element;
            if (table.broken) {
                return Display.getCurrent().getSystemColor(3);
            }
            return null;
        }
    }
}

