/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.service.database;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.service.database.ExtraParams;
import net.refractions.udig.catalog.service.database.ExtraParamsControl;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableBasedExtraParamsControl
implements ExtraParamsControl {
    private List<ExtraParams> paramsDefinition;

    public TableBasedExtraParamsControl(List<ExtraParams> paramsDefinition) {
        this.paramsDefinition = paramsDefinition;
    }

    @Override
    public Control createControl(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, viewer);
        Table table = viewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(this.paramsDefinition);
        return viewer.getControl();
    }

    private void createColumns(Composite parent, final TableViewer viewer) {
        TableViewerColumn col = this.createTableViewerColumn(viewer, "c1", 200);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ExtraParams p = (ExtraParams)element;
                return p.name;
            }
        });
        col = this.createTableViewerColumn(viewer, "c2", 300);
        col.setEditingSupport((EditingSupport)new ParamEditingSupport(viewer));
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ExtraParams p = (ExtraParams)element;
                if (p.getCellEditor() == null) {
                    p.setCellEditor(p.createCellEditor((Composite)viewer.getTable()));
                }
                return p.getValue();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    @Override
    public Map<String, Serializable> getParams() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        for (ExtraParams def : this.paramsDefinition) {
            CellEditor cellEditor = def.getCellEditor();
            if (cellEditor == null || cellEditor.getValue() == null) continue;
            params.put(def.param.key, def.convertValue(cellEditor.getValue()));
        }
        return params;
    }

    class ParamEditingSupport
    extends EditingSupport {
        private TableViewer viewer;

        public ParamEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
        }

        protected CellEditor getCellEditor(Object element) {
            ExtraParams extraParams = (ExtraParams)element;
            CellEditor cellEditor = extraParams.getCellEditor();
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            ExtraParams def = (ExtraParams)element;
            return def.getCellEditor().getValue();
        }

        protected void setValue(Object element, Object value) {
            ExtraParams def = (ExtraParams)element;
            this.viewer.refresh(element, true);
            def.getCellEditor().setValue(value);
        }
    }
}

