/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.service.database;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.ui.BooleanCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.geotools.data.DataAccessFactory;

public abstract class ExtraParams {
    public final String name;
    private CellEditor cellEditor;
    public final DataAccessFactory.Param param;

    public ExtraParams(String name, DataAccessFactory.Param param) {
        this.name = name;
        this.param = param;
    }

    public abstract void setValue(String var1);

    public abstract String getValue();

    public final CellEditor getCellEditor() {
        return this.cellEditor;
    }

    public final void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }

    public Serializable convertValue(Object cellEditorValue) {
        String string = cellEditorValue.toString();
        if (this.param.type == String.class) {
            return string;
        }
        if (this.param.type == Integer.class) {
            return Integer.valueOf(Integer.parseInt(string));
        }
        if (this.param.type == Double.class) {
            return Double.valueOf(Double.parseDouble(string));
        }
        if (this.param.type == Float.class) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (this.param.type == Byte.class) {
            return Byte.valueOf(Byte.parseByte(string));
        }
        if (this.param.type == Character.class) {
            return Character.valueOf(string.charAt(0));
        }
        if (this.param.type == Boolean.class) {
            return Boolean.valueOf(Boolean.parseBoolean(string));
        }
        try {
            if (this.param.type == URL.class) {
                return new URL(string);
            }
            if (this.param.type == URI.class) {
                return new URI(string);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        throw new IllegalStateException(this.param.type + " is not one of the types that are handled by convertValue().  Method must be overridden; Param:" + this.param);
    }

    public abstract CellEditor createCellEditor(Composite var1);

    public static ExtraParams text(String name, DataAccessFactory.Param param, final String defaultValue) {
        return new ExtraParams(name, param){

            @Override
            public CellEditor createCellEditor(Composite parent) {
                TextCellEditor textCellEditor = new TextCellEditor(parent);
                textCellEditor.setValue((Object)(defaultValue == null ? "" : defaultValue));
                return textCellEditor;
            }

            @Override
            public void setValue(String value) {
                this.getCellEditor().setValue((Object)value.toString());
            }

            @Override
            public String getValue() {
                return this.getCellEditor().getValue().toString();
            }
        };
    }

    public static ExtraParams combo(String name, DataAccessFactory.Param param, String defaultValue, final String ... options) {
        int current = 0;
        if (defaultValue != null) {
            String[] stringArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                if (option.equals(defaultValue)) break;
                ++current;
                ++n2;
            }
            if (current >= options.length) {
                CatalogUIPlugin.log("ERROR:  " + defaultValue + " is not one of the legal options", new Exception());
                current = 0;
            }
        }
        final int choice = current;
        return new ExtraParams(name, param){

            @Override
            public CellEditor createCellEditor(Composite parent) {
                ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(parent, options);
                comboBoxCellEditor.setValue((Object)choice);
                return comboBoxCellEditor;
            }

            @Override
            public Serializable convertValue(Object cellEditorValue) {
                ComboBoxCellEditor editor = (ComboBoxCellEditor)this.getCellEditor();
                String value = editor.getItems()[(Integer)cellEditorValue];
                return super.convertValue(value);
            }

            @Override
            public void setValue(String value) {
                int index = 0;
                String[] stringArray = options;
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    if (option.equals(value)) {
                        this.getCellEditor().setValue((Object)index);
                        return;
                    }
                    ++index;
                    ++n2;
                }
                throw new IllegalArgumentException(String.valueOf(value) + " is not one of the options in the combo:" + Arrays.toString(options));
            }

            @Override
            public String getValue() {
                ComboBoxCellEditor editor = (ComboBoxCellEditor)this.getCellEditor();
                int cellEditorValue = (Integer)editor.getValue();
                String value = editor.getItems()[cellEditorValue];
                return value;
            }
        };
    }

    public static ExtraParams bool(String name, DataAccessFactory.Param param, final boolean initialValue) {
        return new ExtraParams(name, param){

            @Override
            public CellEditor createCellEditor(Composite parent) {
                BooleanCellEditor booleanCellEditor = new BooleanCellEditor(parent);
                booleanCellEditor.setValue((Object)initialValue);
                return booleanCellEditor;
            }

            @Override
            public void setValue(String value) {
                this.getCellEditor().setValue((Object)Boolean.parseBoolean(value.toString()));
            }

            @Override
            public String getValue() {
                return this.getCellEditor().getValue().toString();
            }
        };
    }
}

