/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.service.database;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.service.database.DatabaseServiceDialect;
import net.refractions.udig.catalog.service.database.DatabaseWizardLocalization;
import net.refractions.udig.catalog.service.database.LookUpSchemaRunnable;
import net.refractions.udig.catalog.service.database.Tab;
import net.refractions.udig.catalog.service.database.TableDescriptor;
import net.refractions.udig.catalog.service.database.TableSelectionTab;
import net.refractions.udig.catalog.service.database.UserHostPage;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.core.Either;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DataConnectionPage
extends AbstractUDIGImportPage
implements Listener {
    private Combo database;
    private UserHostPage userHostPage;
    Map<Control, Tab> tabs = new HashMap<Control, Tab>();
    private TableSelectionTab tableSelection;
    private TabFolder tabFolder;
    private String currentHost;
    private String currentUsername;
    private int currentPort;

    public DataConnectionPage() {
        super("Database connection page");
    }

    public boolean isPageComplete() {
        Map<String, Serializable> params = this.getParams();
        return params != null;
    }

    @Override
    public Map<String, Serializable> getParams() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        DatabaseServiceDialect dialect = this.dialect();
        params.putAll(this.userHostPage.addParams());
        params.put(dialect.databaseParam.key, (Serializable)((Object)this.database.getText()));
        if (dialect.schemaParam != null && dialect.schemaParam.key != null) {
            params.put(this.dialect().schemaParam.key, (Serializable)dialect.schemaParam.sample);
        }
        params.put(this.dialect().typeParam.key, (Serializable)((Object)this.dialect().dbType));
        Either<String, Map<String, Serializable>> result = this.getActiveTab().getParams(params);
        if (result.isLeft()) {
            Object msg = result.getLeft();
            if (msg != null) {
                this.setErrorMessage((String)result.getLeft());
            }
            return null;
        }
        this.setErrorMessage(null);
        return (Map)result.getRight();
    }

    private Tab getActiveTab() {
        int selection = this.tabFolder.getSelectionIndex();
        Control control2 = this.tabFolder.getItem(selection).getControl();
        return this.tabs.get(control2);
    }

    @Override
    public void shown() {
        boolean sameConnection;
        boolean bl = sameConnection = this.userHostPage.getHost().equals(this.currentHost) && this.userHostPage.getPort() == this.currentPort && this.userHostPage.getUsername().equals(this.currentUsername);
        if (!sameConnection) {
            for (Tab tab : this.tabs.values()) {
                tab.init();
            }
            this.populateDatabaseCombo();
        }
        this.currentHost = this.userHostPage.getHost();
        this.currentPort = this.userHostPage.getPort();
        this.currentUsername = this.userHostPage.getUsername();
    }

    @Override
    public boolean leavingPage() {
        return this.getActiveTab().leavingPage();
    }

    public void createControl(Composite parent) {
        Point size = this.getShell().getSize();
        if (size.y < 640) {
            this.getShell().setSize(size.x, 640);
        }
        this.userHostPage = (UserHostPage)this.getPreviousPage();
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout(2, false));
        this.createDatabaseCombo(top);
        this.createLookupButton(top);
        this.tabFolder = this.createTabFolder(top);
        this.addTableSelectionTab(this.tabFolder);
        this.tabs.putAll(this.dialect().createOptionConnectionPageTabs(this.tabFolder, this));
    }

    private void addTableSelectionTab(TabFolder tabFolder) {
        this.tableSelection = new TableSelectionTab(this.dialect());
        TabItem item = new TabItem(tabFolder, 0);
        item.setText(this.localization().table);
        item.setControl(this.tableSelection.createControl((Composite)tabFolder, 0));
        this.tabs.put(item.getControl(), this.tableSelection);
        this.tableSelection.addListener(this);
    }

    private DatabaseWizardLocalization localization() {
        return this.dialect().localization;
    }

    private DatabaseServiceDialect dialect() {
        return this.userHostPage.dialect;
    }

    private TabFolder createTabFolder(Composite top) {
        TabFolder folder = new TabFolder(top, 128);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        folder.setLayoutData((Object)layoutData);
        return folder;
    }

    private void createLookupButton(Composite top) {
        Button button = new Button(top, 8);
        button.setText(this.localization().list);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        button.setLayoutData((Object)layoutData);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String host = DataConnectionPage.this.userHostPage.getHost();
                int port = DataConnectionPage.this.userHostPage.getPort();
                String password = DataConnectionPage.this.userHostPage.getPassword();
                String username = DataConnectionPage.this.userHostPage.getUsername();
                String database = DataConnectionPage.this.database.getText();
                LookUpSchemaRunnable runnable = DataConnectionPage.this.dialect().createLookupSchemaRunnable(host, port, username, password, database);
                try {
                    DataConnectionPage.this.getContainer().run(false, true, (IRunnableWithProgress)runnable);
                    if (runnable.getError() != null) {
                        DataConnectionPage.this.setErrorMessage(runnable.getError());
                        DataConnectionPage.this.tableSelection.setTableInput(Collections.<TableDescriptor>emptySet());
                    } else {
                        DataConnectionPage.this.setErrorMessage(null);
                        DataConnectionPage.this.tableSelection.setTableInput(runnable.getTableDescriptors());
                    }
                    DataConnectionPage.this.getContainer().updateButtons();
                }
                catch (InvocationTargetException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
                catch (InterruptedException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
            }
        });
    }

    private void createDatabaseCombo(Composite top) {
        Label label = new Label(top, 0);
        label.setText(this.localization().database);
        this.database = new Combo(top, 2048);
        this.database.setLayoutData((Object)new GridData(768));
        this.populateDatabaseCombo();
        this.database.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                String[] items = DataConnectionPage.this.database.getItems();
                if (("" + event.character).matches("\\w") || event.keyCode == 8 || event.keyCode == 127) {
                    String string = DataConnectionPage.this.database.getText();
                    if (string.trim().length() == 0) {
                        DataConnectionPage.this.database.setItems(items);
                    } else {
                        Point p = DataConnectionPage.this.database.getSelection();
                        ArrayList<String> filtered = new ArrayList<String>();
                        String[] stringArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String item = stringArray[n2];
                            if (item.startsWith(string)) {
                                filtered.add(item);
                            }
                            ++n2;
                        }
                        DataConnectionPage.this.database.setItems(filtered.toArray(new String[0]));
                        DataConnectionPage.this.database.setText(string);
                        DataConnectionPage.this.database.setSelection(p);
                    }
                }
            }
        });
    }

    private void populateDatabaseCombo() {
        Object[] names = this.userHostPage.getDatabaseNames();
        this.database.setText("");
        if (names.length == 0) {
            this.database.setItems(new String[0]);
            this.setMessage(this.localization().databasePermissionProblemMessage, 2);
        } else {
            this.setMessage(null);
            Arrays.sort(names);
            String[] items = new String[names.length + 1];
            items[0] = "";
            System.arraycopy(names, 0, items, 1, names.length);
            this.database.setItems(items);
            this.database.select(1);
        }
    }

    @Override
    public Collection<URL> getResourceIDs() {
        Map<String, Serializable> params = this.getParams();
        if (params == null) {
            return Collections.emptySet();
        }
        return this.getActiveTab().getResourceIDs(params);
    }

    public void handleEvent(Event event) {
        this.getContainer().updateButtons();
    }
}

