/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.memory;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.memory.MemoryServiceExtensionImpl;
import net.refractions.udig.catalog.memory.internal.MemoryGeoResourceImpl;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import net.refractions.udig.catalog.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.DataStore;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class NewServiceConnectionFactory
extends UDIGConnectionFactory {
    @Override
    public boolean canProcess(Object context) {
        return context instanceof MemoryGeoResourceImpl;
    }

    @Override
    public Map<String, Serializable> createConnectionParameters(Object context) {
        Map params = null;
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            try {
                MemoryServiceExtensionImpl ext = new MemoryServiceExtensionImpl();
                URL id = new URL("http://localhost/scratch");
                params = ext.createParams(id);
                IService service = ext.createService(id, params);
                DataStore ds = (DataStore)service.resolve(DataStore.class, (IProgressMonitor)monitor);
                int i = 0;
                String typename = "New_Type_";
                List<String> typenames = Arrays.asList(ds.getTypeNames());
                while (typenames.contains(String.valueOf(typename) + i)) {
                    ++i;
                }
                SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
                build.setName(String.valueOf(typename) + i);
                build.setNamespaceURI("http://udig.refractions.net");
                build.setAbstract(false);
                build.add(Messages.NewServiceConnectionFactory_defaultGeom, Geometry.class);
                SimpleFeatureType schema = build.buildFeatureType();
                ds.createSchema((FeatureType)schema);
            }
            catch (Exception e) {
                CatalogUIPlugin.log("Error creating MemoryDatastore or feature type", e);
                monitor.done();
                return null;
            }
        }
        finally {
            monitor.done();
        }
        return params;
    }

    @Override
    public URL createConnectionURL(Object context) {
        return null;
    }
}

