/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.pdf;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.grid.GridStyle;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class BasicGridMapGraphic
implements MapGraphic {
    public void draw(MapGraphicContext context) {
        Point thisPixel;
        Point lastPixel;
        Coordinate thisCoord;
        Coordinate lastCoord;
        int j;
        boolean showLabels = true;
        Color gridColor = Color.black;
        Font font = new Font("Times", 0, 8);
        ReferencedEnvelope bounds = context.getViewportModel().getBounds();
        List<Double>[] gridLines = this.chooseGridLines((Envelope)bounds);
        ViewportGraphics graphics = context.getGraphics();
        int mapPixelWidth = context.getMapDisplay().getWidth();
        int mapPixelHeight = context.getMapDisplay().getHeight();
        graphics.setColor(gridColor);
        List<Double> xCoords = gridLines[0];
        List<Double> yCoords = gridLines[1];
        int i = 0;
        while (i < xCoords.size()) {
            double x = xCoords.get(i);
            j = 0;
            while (j < yCoords.size() - 1) {
                double y1 = yCoords.get(j);
                lastCoord = new Coordinate(x, y1);
                double y2 = yCoords.get(j + 1);
                thisCoord = new Coordinate(x, y2);
                lastPixel = context.worldToPixel(lastCoord);
                thisPixel = context.worldToPixel(thisCoord);
                graphics.drawLine(lastPixel.x, lastPixel.y, thisPixel.x, thisPixel.y);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < yCoords.size()) {
            double y = yCoords.get(i);
            j = 0;
            while (j < xCoords.size() - 1) {
                double x1 = xCoords.get(j);
                lastCoord = new Coordinate(x1, y);
                double x2 = xCoords.get(j + 1);
                thisCoord = new Coordinate(x2, y);
                lastPixel = context.worldToPixel(lastCoord);
                thisPixel = context.worldToPixel(thisCoord);
                graphics.drawLine(lastPixel.x, lastPixel.y, thisPixel.x, thisPixel.y);
                ++j;
            }
            ++i;
        }
        int RIGHT_STRIP_WIDTH = (int)((double)mapPixelWidth * 0.05);
        int BOTTOM_STRIP_HEIGHT = (int)((double)mapPixelHeight * 0.05);
        int GRID_LINE_EXTENSION = (int)((double)RIGHT_STRIP_WIDTH * 0.1);
        graphics.setColor(Color.white);
        graphics.setBackground(Color.white);
        graphics.clearRect(mapPixelWidth - RIGHT_STRIP_WIDTH, 0, RIGHT_STRIP_WIDTH, mapPixelHeight);
        graphics.clearRect(0, mapPixelHeight - BOTTOM_STRIP_HEIGHT, mapPixelWidth, BOTTOM_STRIP_HEIGHT);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(0, 0, mapPixelWidth - RIGHT_STRIP_WIDTH - 1, mapPixelHeight - BOTTOM_STRIP_HEIGHT - 1);
        graphics.setFont(font);
        if (showLabels) {
            Point pixel;
            graphics.setColor(gridColor);
            int i2 = 1;
            while (i2 < yCoords.size() - 1) {
                double y = yCoords.get(i2);
                double x = xCoords.get(xCoords.size() - 1);
                pixel = context.worldToPixel(new Coordinate(x, y));
                if (pixel.y > mapPixelHeight - BOTTOM_STRIP_HEIGHT) break;
                graphics.drawString(String.valueOf((int)y), mapPixelWidth - RIGHT_STRIP_WIDTH + GRID_LINE_EXTENSION, pixel.y, -1, 0);
                ++i2;
            }
            i2 = 1;
            while (i2 < xCoords.size() - 1) {
                double x = xCoords.get(i2);
                double y = yCoords.get(yCoords.size() - 1);
                pixel = context.worldToPixel(new Coordinate(x, y));
                if (pixel.x > mapPixelWidth - RIGHT_STRIP_WIDTH) break;
                graphics.drawString(String.valueOf((int)x), pixel.x, mapPixelHeight - BOTTOM_STRIP_HEIGHT + GRID_LINE_EXTENSION, 0, 1);
                ++i2;
            }
        }
    }

    private List<Double>[] chooseGridLines(Envelope bounds) {
        double max;
        double[] gridSizeChoices = new double[]{1.0, 2.0, 5.0, 10.0, 25.0, 50.0, 100.0, 500.0, 1000.0, 5000.0, 10000.0, 50000.0, 100000.0, 500000.0, 1000000.0};
        int preferredNumberOfGridLines = 2;
        double xSizeGuess = (bounds.getMaxX() - bounds.getMinX()) / (double)preferredNumberOfGridLines;
        double xSize = this.findClosest(gridSizeChoices, xSizeGuess);
        double ySizeGuess = (bounds.getMaxY() - bounds.getMinY()) / (double)preferredNumberOfGridLines;
        double ySize = this.findClosest(gridSizeChoices, ySizeGuess);
        xSize = max = Math.max(xSize, ySize);
        ySize = max;
        double firstX = (double)Math.round(bounds.getMinX() / xSize) * xSize;
        if (firstX > bounds.getMinX()) {
            firstX -= xSize;
        }
        ArrayList<Double> xList = new ArrayList<Double>();
        double xCoord = firstX;
        while (xCoord < bounds.getMaxX() + xSize) {
            xList.add(xCoord);
            xCoord += xSize;
        }
        double firstY = (double)Math.round(bounds.getMaxY() / ySize) * ySize;
        if (firstY < bounds.getMaxY()) {
            firstY += ySize;
        }
        ArrayList<Double> yList = new ArrayList<Double>();
        double yCoord = firstY;
        while (yCoord > bounds.getMinY() - ySize) {
            yList.add(yCoord);
            yCoord -= ySize;
        }
        List[] result = new List[]{xList, yList};
        return result;
    }

    private double findClosest(double[] choices, double val) {
        if (val < choices[0]) {
            return choices[0];
        }
        int i = 0;
        while (i < choices.length - 1) {
            if (val > choices[i] && val < choices[i + 1]) {
                return choices[i];
            }
            ++i;
        }
        return choices[choices.length - 1];
    }

    private void drawGrid(MapGraphicContext context, boolean showLabels) {
        GridStyle style = this.getStyle(context.getLayer());
        double[] gridSize = style.getGridSize();
        try {
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)context.getCRS(), (boolean)true);
            if (!mt.isIdentity()) {
                double x = gridSize[0] / 2.0;
                double y = gridSize[1] / 2.0;
                double[] toTransform = new double[]{-x, -y, x, y};
                double[] dest = new double[4];
                mt.transform(toTransform, 0, dest, 0, 2);
                gridSize = new double[]{Math.abs(dest[2] - dest[0]), Math.abs(dest[3] - dest[1])};
            }
        }
        catch (Exception e) {
            MapGraphicPlugin.log((String)"", (Throwable)e);
        }
        ReferencedEnvelope bounds = context.getViewportModel().getBounds();
        Coordinate centerCoord = bounds.centre();
        gridSize = style.getGridSize();
        Coordinate topLeftCenterCoord = new Coordinate(centerCoord.x - gridSize[0] / 2.0, centerCoord.y + gridSize[1] / 2.0);
        Coordinate topLeftMostCoord = new Coordinate(topLeftCenterCoord);
        while (topLeftMostCoord.x - gridSize[0] > bounds.getMinX()) {
            topLeftMostCoord.x -= gridSize[0];
        }
        while (topLeftMostCoord.y + gridSize[1] < bounds.getMaxY()) {
            topLeftMostCoord.y += gridSize[1];
        }
        Coordinate coord = topLeftMostCoord;
        ViewportGraphics graphics = context.getGraphics();
        int mapPixelWidth = context.getMapDisplay().getWidth();
        int mapPixelHeight = context.getMapDisplay().getHeight();
        int RIGHT_STRIP_WIDTH = (int)((double)mapPixelWidth * 0.05);
        int BOTTOM_STRIP_HEIGHT = (int)((double)mapPixelHeight * 0.03);
        int GRID_LINE_EXTENSION = (int)((double)RIGHT_STRIP_WIDTH * 0.1);
        graphics.setColor(Color.white);
        graphics.fillRect(mapPixelWidth - RIGHT_STRIP_WIDTH, 0, RIGHT_STRIP_WIDTH, mapPixelHeight);
        graphics.fillRect(0, mapPixelHeight - BOTTOM_STRIP_HEIGHT, mapPixelWidth, BOTTOM_STRIP_HEIGHT);
        graphics.setColor(style.getColor());
        Point pixel = null;
        while (true) {
            pixel = context.worldToPixel(coord);
            coord.x += gridSize[0];
            coord.y -= gridSize[1];
            Point next = context.worldToPixel(coord);
            if (next.x - pixel.x < 2 || next.y - pixel.y < 2) {
                context.getLayer().setStatus(4);
                context.getLayer().setStatusMessage(Messages.GridMapGraphic_grids_too_close);
                break;
            }
            if (pixel.x >= mapPixelWidth && pixel.y >= mapPixelHeight) break;
            if (pixel.x < mapPixelWidth) {
                graphics.drawLine(pixel.x, 0, pixel.x, mapPixelHeight - BOTTOM_STRIP_HEIGHT + GRID_LINE_EXTENSION);
            }
            if (showLabels) {
                graphics.drawString(String.valueOf((int)coord.y), pixel.x, mapPixelHeight - BOTTOM_STRIP_HEIGHT + GRID_LINE_EXTENSION, 0, 1);
            }
            if (pixel.y < mapPixelHeight) {
                graphics.drawLine(0, pixel.y, mapPixelWidth - RIGHT_STRIP_WIDTH + GRID_LINE_EXTENSION, pixel.y);
            }
            if (showLabels) {
                graphics.drawString(String.valueOf((int)coord.x), mapPixelWidth - RIGHT_STRIP_WIDTH + GRID_LINE_EXTENSION, pixel.y, -1, 0);
            }
            pixel = next;
        }
        graphics.drawRect(0, 0, mapPixelWidth - RIGHT_STRIP_WIDTH, mapPixelHeight - BOTTOM_STRIP_HEIGHT);
    }

    private GridStyle getStyle(ILayer layer) {
        GridStyle gridStyle = (GridStyle)layer.getStyleBlackboard().get("net.refractions.udig.tool.edit.mapgraphic.grid.style");
        if (gridStyle == null) {
            return GridStyle.DEFAULT_STYLE;
        }
        return gridStyle;
    }

    public double[] closest(int x, int y, ILayer layer) throws FactoryException {
        switch (this.getStyle(layer).getType()) {
            case SCREEN: {
                return this.screenClosest(x, y, layer);
            }
            case WORLD: {
                return this.worldClosest(x, y, layer);
            }
        }
        AssertionError e = new AssertionError((Object)("Should be impossible to reach here: " + this.getStyle(layer).getType()));
        MapGraphicPlugin.log(null, (Throwable)((Object)e));
        throw e;
    }

    private double[] screenClosest(int x, int y, ILayer layer) {
        double[] gridSize = this.getStyle(layer).getGridSize();
        double newx = (double)Math.round((double)x / gridSize[0]) * gridSize[0];
        double newy = (double)Math.round((double)y / gridSize[1]) * gridSize[1];
        Coordinate result = layer.getMap().getViewportModel().pixelToWorld((int)newx, (int)newy);
        return new double[]{result.x, result.y};
    }

    private double[] worldClosest(int x1, int y1, ILayer layer) throws FactoryException {
        Coordinate coord = layer.getMap().getViewportModel().pixelToWorld(x1, y1);
        CoordinateReferenceSystem crs = layer.getMap().getViewportModel().getCRS();
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs);
        double[] gridSize = this.getStyle(layer).getGridSize();
        try {
            if (!mt.isIdentity()) {
                double tx = gridSize[0] / 2.0;
                double ty = gridSize[1] / 2.0;
                double[] toTransform = new double[]{-tx, -ty, tx, ty};
                double[] dest = new double[4];
                mt.transform(toTransform, 0, dest, 0, 2);
                gridSize = new double[]{Math.abs(dest[2] - dest[0]), Math.abs(dest[3] - dest[1])};
            }
        }
        catch (Exception e) {
            MapGraphicPlugin.log((String)"", (Throwable)e);
        }
        double newx = (double)Math.round(coord.x / gridSize[0]) * gridSize[0];
        double newy = (double)Math.round(coord.y / gridSize[1]) * gridSize[1];
        return new double[]{newx, newy};
    }
}

