/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor.parts;

import java.util.List;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.model.PropertyListener;
import net.refractions.udig.printing.ui.internal.editor.figures.PageFigure;
import net.refractions.udig.printing.ui.internal.editor.policies.CustomXYLayoutEditPolicy;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class PagePart
extends AbstractGraphicalEditPart {
    private InternalPropertyListener listener = new InternalPropertyListener();

    protected List<?> getModelChildren() {
        return this.getModel().getBoxes();
    }

    protected IFigure createFigure() {
        PageFigure figure = new PageFigure(this.getModel().getSize());
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CustomXYLayoutEditPolicy());
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.getModel().eAdapters().add((Object)this.listener);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        this.getModel().eAdapters().remove((Object)this.listener);
    }

    public Page getModel() {
        return (Page)super.getModel();
    }

    protected void refreshVisuals() {
        Page page = this.getModel();
        Point loc = new Point(0, 0);
        Dimension size = page.getSize();
        Rectangle rectangle = new Rectangle(loc, size);
        IFigure fig = this.getFigure();
        fig.setSize(size);
        this.getParent().setLayoutConstraint((EditPart)this, fig, (Object)rectangle);
    }

    public GraphicalEditPart getParent() {
        return (GraphicalEditPart)super.getParent();
    }

    protected class InternalPropertyListener
    extends PropertyListener {
        protected InternalPropertyListener() {
        }

        protected void boxesChanged() {
            PagePart.this.refreshChildren();
        }

        protected void sizeChanged() {
            PagePart.this.refreshVisuals();
        }
    }
}

