/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor.parts;

import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.impl.LabelBoxPrinter;
import net.refractions.udig.printing.ui.internal.editor.figures.BoxFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class LabelDirectEditManager
extends DirectEditManager {
    Font scaledFont;
    protected VerifyListener verifyListener;
    protected BoxFigure nodeFigure;

    public LabelDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, BoxFigure nodeFigure) {
        super(source, editorType, locator);
        this.nodeFigure = nodeFigure;
    }

    protected void bringDown() {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void unhookListeners() {
        super.unhookListeners();
        Text text = (Text)this.getCellEditor().getControl();
        text.removeVerifyListener(this.verifyListener);
        this.verifyListener = null;
    }

    protected void initCellEditor() {
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text = (Text)LabelDirectEditManager.this.getCellEditor().getControl();
                String oldText = text.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)text);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text.computeSize(size.x, -1);
                } else {
                    size.x = 1;
                }
                Control control = LabelDirectEditManager.this.getCellEditor().getControl();
                control.setSize(size.x, size.y);
            }
        };
        Text text = (Text)this.getCellEditor().getControl();
        text.addVerifyListener(this.verifyListener);
        text.setText(((LabelBoxPrinter)((Box)this.getEditPart().getModel()).getBoxPrinter()).getText());
        this.getCellEditor().setValue((Object)this.nodeFigure.getText());
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
        text.selectAll();
    }
}

