/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor.parts;

import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.PropertyListener;
import net.refractions.udig.printing.ui.internal.editor.figures.BoxFigure;
import net.refractions.udig.printing.ui.internal.editor.parts.BoxPart;
import net.refractions.udig.printing.ui.internal.editor.parts.LabelCellEditorLocator;
import net.refractions.udig.printing.ui.internal.editor.parts.LabelDirectEditManager;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;

public class DecoratorPart
extends BoxPart {
    protected DirectEditManager manager;
    protected InternalPropertyListener listener = new InternalPropertyListener();

    @Override
    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        ((Box)this.getModel()).eAdapters().add((Object)this.listener);
    }

    @Override
    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        ((Box)this.getModel()).eAdapters().remove((Object)this.listener);
    }

    @Override
    protected void refreshVisuals() {
        Box scalebarBox = (Box)this.getModel();
        Point loc = scalebarBox.getLocation();
        Dimension size = scalebarBox.getSize();
        Rectangle rectangle = new Rectangle(loc, size);
        ((BoxFigure)this.getFigure()).setBox((Box)this.getModel());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rectangle);
    }

    @Override
    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (this.manager == null) {
                BoxFigure nodeFigure = (BoxFigure)this.getFigure();
                this.manager = new LabelDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator(nodeFigure), nodeFigure);
            }
            this.manager.show();
        }
    }

    @Override
    protected IFigure createFigure() {
        return new BoxFigure();
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
    }

    protected class InternalPropertyListener
    extends PropertyListener {
        protected InternalPropertyListener() {
        }

        protected void textChanged() {
            DecoratorPart.this.refreshVisuals();
        }

        protected void locationChanged() {
            DecoratorPart.this.refreshVisuals();
        }

        protected void sizeChanged() {
            DecoratorPart.this.refreshVisuals();
        }
    }
}

