/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor.parts;

import java.util.Collection;
import java.util.List;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.model.Connection;
import net.refractions.udig.printing.model.PropertyListener;
import net.refractions.udig.printing.ui.IBoxEditAction;
import net.refractions.udig.printing.ui.internal.BoxFactory;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.printing.ui.internal.editor.BoxAction;
import net.refractions.udig.printing.ui.internal.editor.commands.ConnectionCreateCommand;
import net.refractions.udig.printing.ui.internal.editor.commands.ConnectionReconnectCommand;
import net.refractions.udig.printing.ui.internal.editor.figures.BoxFigure;
import net.refractions.udig.printing.ui.internal.editor.parts.PrintingEditPolicy;
import net.refractions.udig.printing.ui.internal.editor.policies.PageElementEditPolicy;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class BoxPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
IAdaptable {
    protected InternalPropertyListener listener = new InternalPropertyListener();
    private BoxAction defaultAction;

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        Box box = (Box)this.getModel();
        box.eAdapters().add((Object)this.listener);
        box.addPropertyChangeListener((IPropertyChangeListener)this.listener);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        Box box = (Box)this.getModel();
        box.eAdapters().remove((Object)this.listener);
        box.removePropertyChangeListener((IPropertyChangeListener)this.listener);
    }

    public Object getAdapter(Class key) {
        Object obj;
        Box box = (Box)this.getModel();
        if (box instanceof IAdaptable && (obj = box.getAdapter(key)) != null) {
            return obj;
        }
        return super.getAdapter(key);
    }

    protected void refreshVisuals() {
        Box labelBox = (Box)this.getModel();
        Point loc = labelBox.getLocation();
        Dimension size = labelBox.getSize();
        Rectangle rectangle = new Rectangle(loc, size);
        ((BoxFigure)this.getFigure()).setBox((Box)this.getModel());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rectangle);
    }

    public BoxPrinter getBoxPrinter() {
        return ((Box)this.getModel()).getBoxPrinter();
    }

    public void performRequest(Request request) {
        EditPolicy policy = this.getEditPolicy(request.getType());
        if (policy instanceof PrintingEditPolicy) {
            PrintingEditPolicy editPolicy = (PrintingEditPolicy)policy;
            IBoxEditAction action = editPolicy.getAction().getBoxEditAction();
            action.init(this);
            action.perform();
            Display display = this.getViewer().getControl().getDisplay();
            while (!action.isDone()) {
                if (display.readAndDispatch()) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            if (!action.isDone()) {
                return;
            }
            Command command = action.getCommand();
            if (command != null && command.canExecute()) {
                this.getViewer().getEditDomain().getCommandStack().execute(command);
            }
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
    }

    protected List getModelSourceConnections() {
        return ((Box)this.getModel()).getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return ((Box)this.getModel()).getTargetConnections();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PageElementEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy(){

            protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
                ConnectionCreateCommand cmd = (ConnectionCreateCommand)request.getStartCommand();
                cmd.setTarget((Box)this.getHost().getModel());
                return cmd;
            }

            protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
                Box source = (Box)this.getHost().getModel();
                ConnectionCreateCommand cmd = new ConnectionCreateCommand(source);
                request.setStartCommand((Command)cmd);
                return cmd;
            }

            protected Command getReconnectTargetCommand(ReconnectRequest request) {
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                Box newTarget = (Box)this.getHost().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                cmd.setNewTarget(newTarget);
                return cmd;
            }

            protected Command getReconnectSourceCommand(ReconnectRequest request) {
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                Box newSource = (Box)this.getHost().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                cmd.setNewSource(newSource);
                return cmd;
            }
        });
        List<BoxFactory> boxes = PrintingPlugin.getDefault().getBoxes();
        Box model = (Box)this.getModel();
        BoxPrinter printer = model.getBoxPrinter();
        String defaultActionID = null;
        for (BoxFactory boxFactory : boxes) {
            if (boxFactory.getType() != printer.getClass()) continue;
            defaultActionID = boxFactory.getDefaultActionID();
            break;
        }
        Collection<BoxAction> actions = PrintingPlugin.getBoxExtensionActions(null);
        for (BoxAction element : actions) {
            try {
                boolean isAcceptable;
                if (element.getId() != null && element.getId().equals(defaultActionID)) {
                    isAcceptable = true;
                    this.defaultAction = element;
                } else {
                    isAcceptable = element.isAcceptableBoxPrinter(printer);
                }
                if (!isAcceptable) continue;
                EditPolicy policyObj = element.getEditPolicy();
                this.installEditPolicy(element.getRequest().getType(), policyObj);
            }
            catch (Throwable throwable) {}
        }
    }

    protected IFigure createFigure() {
        return new BoxFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public BoxAction getDefaultAction() {
        return this.defaultAction;
    }

    protected class InternalPropertyListener
    extends PropertyListener
    implements IPropertyChangeListener {
        protected InternalPropertyListener() {
        }

        protected void textChanged() {
            BoxPart.this.refreshVisuals();
        }

        protected void locationChanged() {
            BoxPart.this.refreshVisuals();
        }

        protected void sizeChanged() {
            BoxPart.this.refreshVisuals();
        }

        public void propertyChange(PropertyChangeEvent event) {
            BoxPart.this.refreshVisuals();
        }
    }
}

