/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor.figures;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class BoxFigure
extends Figure {
    private Box box;
    private RectangleFigure rectangleFigure;
    private Label label;
    PreviewJob drawJob = new PreviewJob();
    boolean rendering = false;
    private IJobChangeListener listener = new JobChangeAdapter(){

        public void scheduled(IJobChangeEvent event) {
            BoxFigure.this.rendering = true;
        }

        public void done(IJobChangeEvent event) {
            BoxFigure.this.rendering = false;
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoxFigure.this.repaint();
                }
            });
        }
    };

    public BoxFigure() {
        this.rectangleFigure = new RectangleFigure();
        this.label = new Label();
        this.add((IFigure)this.rectangleFigure);
        this.add((IFigure)this.label);
        this.setOpaque(false);
    }

    public String getText() {
        return this.label.getText();
    }

    public Rectangle getTextBounds() {
        return this.label.getTextBounds();
    }

    public void setName(String name) {
        this.label.setText(name);
        this.repaint();
    }

    public void setBox(Box newBox) {
        this.box = newBox;
        this.repaint();
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.rectangleFigure.setBounds(rect);
        this.label.setBounds(rect);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.box.getSize().width < 1 || this.box.getSize().height < 1) {
            return;
        }
        this.drawJob.addJobChangeListener(this.listener);
        graphics.translate(this.getLocation().x, this.getLocation().y);
        if (this.box.getBoxPrinter() == null) {
            return;
        }
        if (!this.box.getBoxPrinter().isNewPreviewNeeded() && this.drawJob.getCacheImage() != null || this.drawJob.getDraws() > 5 && this.drawJob.getCacheImage() != null) {
            this.drawJob.setDraws(0);
            graphics.drawImage(this.drawJob.getCacheImage(), 0, 0);
        } else {
            if (!this.rendering) {
                this.drawJob.clearCache();
                this.drawJob.setDisplay(Display.getCurrent());
                this.drawJob.setBox(this.box);
                this.drawJob.schedule();
            }
            String message = "Rendering Preview";
            Color color = graphics.getBackgroundColor();
            graphics.setBackgroundColor(Display.getCurrent().getSystemColor(15));
            graphics.fillRectangle(0, 0, this.box.getSize().width - 1, this.box.getSize().height - 1);
            graphics.setBackgroundColor(color);
            graphics.setForegroundColor(Display.getCurrent().getSystemColor(2));
            graphics.drawRectangle(0, 0, this.box.getSize().width - 1, this.box.getSize().height - 1);
            int fontHeight = graphics.getFontMetrics().getHeight();
            int fontWidth = graphics.getFontMetrics().getAverageCharWidth() * message.length();
            graphics.drawText(message, this.box.getSize().width / 2 - fontWidth, this.box.getSize().height / 2 - fontHeight);
        }
    }

    private static class PreviewJob
    extends Job {
        private Box box;
        private Display display;
        private Image cacheImage;
        private int draws = 0;

        public synchronized void setBox(Box box) {
            this.box = box;
        }

        public void clearCache() {
            if (this.cacheImage != null) {
                this.cacheImage.dispose();
            }
            this.cacheImage = null;
        }

        PreviewJob() {
            super("Preview Job");
        }

        public synchronized void setDisplay(Display display2) {
            this.display = display2;
        }

        public synchronized Image getCacheImage() {
            return this.cacheImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            int width = this.box.getSize().width;
            int height = this.box.getSize().height;
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D createGraphics = image.createGraphics();
            this.box.getBoxPrinter().createPreview(createGraphics, monitor);
            ImageRunnable runnable = new ImageRunnable();
            runnable.image = image;
            PlatformGIS.syncInDisplayThread((Runnable)runnable);
            PreviewJob previewJob = this;
            synchronized (previewJob) {
                this.cacheImage = runnable.swtImage;
                ++this.draws;
            }
            return Status.OK_STATUS;
        }

        public synchronized int getDraws() {
            return this.draws;
        }

        public synchronized void setDraws(int draws) {
            this.draws = draws;
        }

        private class ImageRunnable
        implements Runnable {
            Image swtImage;
            private RenderedImage image;

            private ImageRunnable() {
            }

            @Override
            public void run() {
                this.swtImage = AWTSWTImageUtils.createSWTImage((RenderedImage)this.image, (boolean)true);
            }
        }
    }
}

