/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor.commands;

import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.Page;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class BoxCreateCommand
extends Command {
    private Box newBox;
    private Page parent;
    private Rectangle bounds;

    public BoxCreateCommand(Box box, Page parent, Rectangle bounds) {
        this.bounds = bounds;
        this.newBox = box;
        this.parent = parent;
        this.setLabel("box creation");
    }

    public boolean canExecute() {
        return this.newBox != null && this.parent != null && this.bounds != null;
    }

    public void execute() {
        this.newBox.setLocation(this.bounds.getLocation());
        Dimension size = this.bounds.getSize();
        if (size.width > 0 && size.height > 0) {
            this.newBox.setSize(size);
        }
        this.redo();
    }

    public void redo() {
        this.parent.getBoxes().add(this.newBox);
    }

    public void undo() {
        this.parent.getBoxes().remove(this.newBox);
    }
}

