/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import java.awt.Color;
import net.refractions.udig.printing.model.impl.RectangleEllipseBoxPrinter;
import net.refractions.udig.printing.ui.IBoxEditAction;
import net.refractions.udig.printing.ui.internal.editor.parts.BoxPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class SimpleStyleAction
implements IBoxEditAction {
    private BoxPart owner;

    @Override
    public Command getCommand() {
        return null;
    }

    @Override
    public void init(BoxPart owner) {
        this.owner = owner;
    }

    private RectangleEllipseBoxPrinter getPrinter() {
        return (RectangleEllipseBoxPrinter)this.owner.getBoxPrinter();
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public void perform() {
        Shell parentShell = Display.getCurrent().getActiveShell();
        RectangleEllipseBoxPrinter boxPrinter = this.getPrinter();
        SimpleStyleDialog dialog = new SimpleStyleDialog(parentShell, boxPrinter);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        boxPrinter.setLineWidth(dialog.getLineWidth());
        boxPrinter.setLineAlpha(dialog.getLineAlpha());
        boxPrinter.setLineColor(dialog.getLineColor());
        boxPrinter.setFillAlpha(dialog.getFillAlpha());
        boxPrinter.setFillColor(dialog.getFillColor());
        boxPrinter.setType(dialog.getType());
        boxPrinter.setDirty(true);
    }

    private static class SimpleStyleDialog
    extends Dialog
    implements Listener {
        private float lineWidth;
        private int lineAlpha;
        private Color lineColor;
        private int fillAlpha;
        private Color fillColor;
        private int type;
        private Spinner lineWidthSpinner;
        private Spinner lineAlphaSpinner;
        private Button lineColorButton;
        private Spinner fillAlphaSpinner;
        private Button fillColorButton;
        private Button rectangleRadio;
        private Button roundRectangleRadio;
        private Button ellipseRadio;

        protected SimpleStyleDialog(Shell parentShell, RectangleEllipseBoxPrinter printer) {
            super(parentShell);
            this.setShellStyle(2144);
            this.lineWidth = printer.getLineWidth();
            this.lineAlpha = printer.getLineAlpha();
            this.lineColor = printer.getLineColor();
            this.fillAlpha = printer.getFillAlpha();
            this.fillColor = printer.getFillColor();
            this.type = printer.getType();
        }

        protected Control createContents(Composite parent) {
            this.getShell().setText("Set style");
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(1808));
            container.setLayout((Layout)new GridLayout(2, false));
            Label lineWidthLabel = new Label(container, 0);
            lineWidthLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            lineWidthLabel.setText("Line width");
            this.lineWidthSpinner = new Spinner(container, 2048);
            this.lineWidthSpinner.setMinimum(1);
            this.lineWidthSpinner.setMaximum(10);
            this.lineWidthSpinner.setIncrement(1);
            this.lineWidthSpinner.setSelection((int)this.lineWidth);
            this.lineWidthSpinner.addListener(24, (Listener)this);
            this.lineWidthSpinner.addListener(2, (Listener)this);
            Label lineAlphaLabel = new Label(container, 0);
            lineAlphaLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            lineAlphaLabel.setText("Line alpha");
            this.lineAlphaSpinner = new Spinner(container, 2048);
            this.lineAlphaSpinner.setMinimum(0);
            this.lineAlphaSpinner.setMaximum(255);
            this.lineAlphaSpinner.setIncrement(5);
            this.lineAlphaSpinner.setSelection(this.lineAlpha);
            this.lineAlphaSpinner.addListener(24, (Listener)this);
            this.lineAlphaSpinner.addListener(2, (Listener)this);
            Label lineColorLabel = new Label(container, 0);
            lineColorLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            lineColorLabel.setText("Line color");
            this.lineColorButton = new Button(container, 8);
            this.lineColorButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.lineColorButton.setText("...");
            this.lineColorButton.addListener(13, (Listener)this);
            Label fillAlphaLabel = new Label(container, 0);
            fillAlphaLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            fillAlphaLabel.setText("Fill alpha");
            this.fillAlphaSpinner = new Spinner(container, 2048);
            this.fillAlphaSpinner.setMinimum(0);
            this.fillAlphaSpinner.setMaximum(255);
            this.fillAlphaSpinner.setIncrement(5);
            this.fillAlphaSpinner.setSelection(this.fillAlpha);
            this.fillAlphaSpinner.addListener(24, (Listener)this);
            this.fillAlphaSpinner.addListener(2, (Listener)this);
            Label fillColorLabel = new Label(container, 0);
            fillColorLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            fillColorLabel.setText("Fill color");
            this.fillColorButton = new Button(container, 8);
            this.fillColorButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fillColorButton.setText("...");
            this.fillColorButton.addListener(13, (Listener)this);
            this.rectangleRadio = new Button(container, 16);
            this.rectangleRadio.setLayoutData((Object)new GridData(4, 4, true, false));
            this.rectangleRadio.setText("Rectangle");
            if (this.type == 0) {
                this.rectangleRadio.setSelection(true);
            }
            this.rectangleRadio.addListener(13, (Listener)this);
            new Label(container, 0);
            this.roundRectangleRadio = new Button(container, 16);
            this.roundRectangleRadio.setLayoutData((Object)new GridData(4, 4, true, false));
            this.roundRectangleRadio.setText("Rounded rectangle");
            if (this.type == 1) {
                this.roundRectangleRadio.setSelection(true);
            }
            this.roundRectangleRadio.addListener(13, (Listener)this);
            new Label(container, 0);
            this.ellipseRadio = new Button(container, 16);
            this.ellipseRadio.setLayoutData((Object)new GridData(4, 4, true, false));
            this.ellipseRadio.setText("Ellipse");
            if (this.type == 2) {
                this.ellipseRadio.setSelection(true);
            }
            this.ellipseRadio.addListener(13, (Listener)this);
            new Label(container, 0);
            Composite buttonComposite = new Composite(container, 0);
            GridData gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 2;
            buttonComposite.setLayoutData((Object)gd);
            buttonComposite.setLayout((Layout)new GridLayout(1, true));
            this.createButtonsForButtonBar(buttonComposite);
            return container;
        }

        public void handleEvent(Event event) {
            Widget widget = event.widget;
            if (widget.equals(this.lineWidthSpinner)) {
                this.lineWidth = this.lineWidthSpinner.getSelection();
            } else if (widget.equals(this.lineAlphaSpinner)) {
                this.lineAlpha = this.lineAlphaSpinner.getSelection();
            } else if (widget.equals(this.lineColorButton)) {
                ColorDialog dialog = new ColorDialog(this.lineColorButton.getShell());
                dialog.open();
                RGB rgb = dialog.getRGB();
                if (rgb != null) {
                    this.lineColor = new Color(rgb.red, rgb.green, rgb.blue);
                }
            } else if (widget.equals(this.fillAlphaSpinner)) {
                this.fillAlpha = this.fillAlphaSpinner.getSelection();
            } else if (widget.equals(this.fillColorButton)) {
                ColorDialog dialog = new ColorDialog(this.fillColorButton.getShell());
                dialog.open();
                RGB rgb = dialog.getRGB();
                if (rgb != null) {
                    this.fillColor = new Color(rgb.red, rgb.green, rgb.blue);
                }
            } else if (widget.equals(this.rectangleRadio) || widget.equals(this.roundRectangleRadio) || widget.equals(this.ellipseRadio)) {
                boolean selection = this.rectangleRadio.getSelection();
                if (selection) {
                    this.type = 0;
                }
                if (selection = this.roundRectangleRadio.getSelection()) {
                    this.type = 1;
                }
                if (selection = this.ellipseRadio.getSelection()) {
                    this.type = 2;
                }
            }
        }

        public float getLineWidth() {
            return this.lineWidth;
        }

        public int getLineAlpha() {
            return this.lineAlpha;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public int getFillAlpha() {
            return this.fillAlpha;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public int getType() {
            return this.type;
        }
    }
}

