/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import net.refractions.udig.printing.model.impl.MapGraphicBoxPrinter;
import net.refractions.udig.printing.ui.IBoxEditAction;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.printing.ui.internal.editor.parts.BoxPart;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.sld.editor.EditorPageManager;
import net.refractions.udig.style.sld.editor.StyleEditorDialog;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SetStyleAction
implements IBoxEditAction {
    private BoxPart owner;
    private StyleBlackboard original;

    @Override
    public Command getCommand() {
        final StyleBlackboard originalStyleBlackboard = this.original;
        this.original = null;
        final Layer layer = this.getSelectedLayer();
        final StyleBlackboard newBlackboard = layer.getStyleBlackboard();
        return new Command(){

            public String getLabel() {
                return "Change Style";
            }

            public void execute() {
                layer.setStyleBlackboard(newBlackboard);
            }

            public void undo() {
                layer.setStyleBlackboard(originalStyleBlackboard);
            }
        };
    }

    @Override
    public void init(BoxPart owner) {
        this.owner = owner;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    private MapGraphicBoxPrinter getBoxPrinter() {
        return (MapGraphicBoxPrinter)this.owner.getBoxPrinter();
    }

    @Override
    public void perform() {
        Layer selectedLayer = this.getSelectedLayer();
        this.original = selectedLayer.getStyleBlackboard();
        EditorPageManager manager = EditorPageManager.loadManager((Plugin)PrintingPlugin.getDefault(), (ILayer)selectedLayer);
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        StyleEditorDialog dialog = StyleEditorDialog.createDialogOn((Shell)parentShell, null, (Layer)selectedLayer, (EditorPageManager)manager);
        dialog.setBlockOnOpen(true);
        int returnCode = dialog.open();
        if (returnCode != 0) {
            selectedLayer.setStyleBlackboard(this.original);
            this.original = null;
        }
    }

    private Layer getSelectedLayer() {
        return this.getBoxPrinter().getLayer();
    }
}

