/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.printing.ui.internal.BoxFactory;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.printing.ui.internal.editor.BoxAction;
import net.refractions.udig.printing.ui.internal.editor.BoxCreationFactory;
import net.refractions.udig.printing.ui.internal.editor.parts.BoxPart;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.preference.IPreferenceStore;

public class PageEditorPaletteFactory {
    private static final String PREFIX = "PageEditorPaletteFactory.";
    private static final String PALETTE_DOCK_LOCATION = "PageEditorPaletteFactory.Location";
    private static final String PALETTE_STATE = "PageEditorPaletteFactory.State";
    private static final String PALETTE_SIZE = "PageEditorPaletteFactory.Size";
    private static final int DEFAULT_PALETTE_SIZE = 125;

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup(Messages.PageEditorPaletteFactory_controlGroup_title);
        ArrayList<SelectionToolEntry> entries = new ArrayList<SelectionToolEntry>();
        SelectionToolEntry tool = new SelectionToolEntry();
        tool.setToolClass(SelectionToolWithDoubleClick.class);
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    private static PaletteContainer createComponentsDrawer() {
        PaletteDrawer drawer = new PaletteDrawer(Messages.PageEditorPaletteFactory_components_title, null);
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        List<BoxFactory> boxFactories = PrintingPlugin.getDefault().getVisibleBoxes();
        for (BoxFactory factory : boxFactories) {
            CombinedTemplateCreationEntry tool = new CombinedTemplateCreationEntry(factory.getName(), factory.getDescription(), null, (CreationFactory)new BoxCreationFactory(factory), factory.getSmallImage(), factory.getLargeImage());
            entries.add(tool);
        }
        drawer.addAll(entries);
        return drawer;
    }

    private static List<?> createCategories(PaletteRoot root) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(PageEditorPaletteFactory.createControlGroup(root));
        categories.add(PageEditorPaletteFactory.createComponentsDrawer());
        return categories;
    }

    public static PaletteRoot createPalette() {
        PaletteRoot paletteRoot = new PaletteRoot();
        paletteRoot.addAll(PageEditorPaletteFactory.createCategories(paletteRoot));
        return paletteRoot;
    }

    private static IPreferenceStore getPreferenceStore() {
        return PrintingPlugin.getDefault().getPreferenceStore();
    }

    static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        PageEditorPaletteFactory.getPreferenceStore().setDefault(PALETTE_DOCK_LOCATION, -1);
        PageEditorPaletteFactory.getPreferenceStore().setDefault(PALETTE_STATE, 4);
        PageEditorPaletteFactory.getPreferenceStore().setDefault(PALETTE_SIZE, 125);
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return PageEditorPaletteFactory.getPreferenceStore().getInt(PageEditorPaletteFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return PageEditorPaletteFactory.getPreferenceStore().getInt(PageEditorPaletteFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return PageEditorPaletteFactory.getPreferenceStore().getInt(PageEditorPaletteFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                PageEditorPaletteFactory.getPreferenceStore().setValue(PageEditorPaletteFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                PageEditorPaletteFactory.getPreferenceStore().setValue(PageEditorPaletteFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                PageEditorPaletteFactory.getPreferenceStore().setValue(PageEditorPaletteFactory.PALETTE_SIZE, width);
            }
        };
    }

    public static class SelectionToolWithDoubleClick
    extends SelectionTool {
        protected boolean handleDoubleClick(int button) {
            BoxPart part;
            BoxAction defaultAction;
            if (this.getTargetEditPart() instanceof BoxPart && (defaultAction = (part = (BoxPart)this.getTargetEditPart()).getDefaultAction()) != null) {
                defaultAction.run();
                return true;
            }
            return super.handleDoubleClick(button);
        }
    }
}

