/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.ModelFactory;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.ui.Template;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.opengis.coverage.grid.GridCoverageReader;

public class TemplatePrintingEngine
implements Pageable,
Printable {
    private static final double MARGIN = 36.0;
    private Template template;
    private boolean showRasters;
    private double scaleHint;
    private Map map;
    private int numPages;
    private IProgressMonitor monitor;
    private PrinterJob printerJob;

    public TemplatePrintingEngine(Map map, Template template, boolean showRasters) {
        this.template = template;
        this.showRasters = showRasters;
        this.map = map;
        this.numPages = -1;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        this.template.setActivePage(pageIndex);
        Page page = this.makePage(this.map, pageFormat, this.template, this.showRasters, this.scaleHint);
        Graphics2D graphics2d = (Graphics2D)graphics;
        AffineTransform at = graphics2d.getTransform();
        double dpi = at.getScaleX() * 72.0;
        if (PrintingPlugin.isDebugging("net.refractions.udig.printing.ui/debug/printing")) {
            PrintingPlugin.log("-Printing page " + pageIndex, null);
            System.out.println("-PageFormat: " + pageFormat);
            System.out.println("-PageFormat height: " + pageFormat.getHeight());
            System.out.println("-PageFormat width: " + pageFormat.getWidth());
            System.out.println("-PageFormat imageableX,Y " + pageFormat.getImageableX() + ", " + pageFormat.getImageableY());
            System.out.println("-PageFormat imageable height: " + pageFormat.getImageableHeight());
            System.out.println("-PageFormat imageable width: " + pageFormat.getImageableWidth());
            System.out.println("-PageFormat orientation (LANDSCAPE=0, PORTRAIT=1): " + pageFormat.getOrientation());
            System.out.println("-Graphics: clip bounds: " + graphics2d.getClipBounds());
            System.out.println("-Transform: scaleX: " + at.getScaleX());
            System.out.println("-Transform: scaleY: " + at.getScaleY());
            System.out.println("-DPI?? : " + dpi);
        }
        graphics2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        for (Box box : page.getBoxes()) {
            graphics2d = (Graphics2D)graphics.create(box.getLocation().x, box.getLocation().y, box.getSize().width, box.getSize().height);
            box.getBoxPrinter().draw(graphics2d, this.monitor);
        }
        return 0;
    }

    protected Page makePage(Map map, PageFormat pf, Template template, boolean showRasters, double scaleHint) {
        Map mapCopy = null;
        mapCopy = (Map)ApplicationGIS.copyMap((IMap)map);
        List layersNoRasters = mapCopy.getLayersInternal();
        if (!showRasters) {
            ArrayList<Layer> toRemove = new ArrayList<Layer>();
            for (Layer layer : layersNoRasters) {
                for (IGeoResource resource : layer.getGeoResources()) {
                    if (!resource.canResolve(GridCoverageReader.class)) continue;
                    toRemove.add(layer);
                }
            }
            layersNoRasters.removeAll(toRemove);
        }
        Page page = ModelFactory.eINSTANCE.createPage();
        page.setSize(new Dimension((int)pf.getImageableWidth(), (int)pf.getImageableHeight()));
        MessageFormat formatter = new MessageFormat(Messages.CreatePageAction_newPageName, Locale.getDefault());
        if (page.getName() == null || page.getName().length() == 0) {
            page.setName(formatter.format(new Object[]{mapCopy.getName()}));
        }
        template.init(page, mapCopy);
        Iterator<Box> iter = template.iterator();
        while (iter.hasNext()) {
            page.getBoxes().add(iter.next());
        }
        return page;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public int getNumberOfPages() {
        this.makePage(this.map, new PageFormat(), this.template, false, -1.0);
        if (this.numPages == -1) {
            this.numPages = this.template.getNumPages();
        }
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.printerJob.defaultPage();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public void setPrinterJob(PrinterJob printerJob) {
        this.printerJob = printerJob;
    }
}

