/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.refractions.udig.printing.ui.TemplateFactory;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PrintingPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String defaultTemplate;
    private List list;
    private ArrayList templateIds;

    protected Control createContents(Composite parent) {
        int columns;
        this.templateIds = new ArrayList();
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Messages.PrintingPreferences_label_defaultTemplate);
        urlLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        Map<String, TemplateFactory> templates = PrintingPlugin.getDefault().getTemplateFactories();
        this.list = new List(composite, 2052);
        this.list.setLayoutData((Object)gridData);
        Iterator<Map.Entry<String, TemplateFactory>> iter = templates.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry<String, TemplateFactory> entry = iter.next();
            TemplateFactory templateFactory = entry.getValue();
            this.templateIds.add(i, entry.getKey());
            if (this.defaultTemplate.equals(templateFactory.getName())) {
                this.list.select(i);
            }
            this.list.add(templateFactory.getName());
            ++i;
        }
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.defaultTemplate = PrintingPlugin.getDefault().getPluginPreferences().getString("udig.preferences.defaultTemplate");
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        int selectionIndex = this.list.getSelectionIndex();
        if (selectionIndex == -1 || selectionIndex > this.templateIds.size() - 1) {
            return super.performOk();
        }
        this.defaultTemplate = (String)this.templateIds.get(selectionIndex);
        PrintingPlugin.getDefault().getPluginPreferences().setValue("udig.preferences.defaultTemplate", this.defaultTemplate);
        PrintingPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }
}

