/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrintingEngine
implements Pageable,
Printable {
    Page diagram;
    private IProgressMonitor monitor;
    private PrinterJob printerJob;

    public PrintingEngine(Page diagram) {
        this.diagram = diagram;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D graphics2d = (Graphics2D)graphics;
        AffineTransform at = graphics2d.getTransform();
        double dpi = at.getScaleX() * 72.0;
        if (PrintingPlugin.isDebugging("net.refractions.udig.printing.ui/debug/printing")) {
            PrintingPlugin.log("Printing page " + pageIndex, null);
            System.out.println("PageFormat: " + pageFormat);
            System.out.println("PageFormat height: " + pageFormat.getHeight());
            System.out.println("PageFormat width: " + pageFormat.getWidth());
            System.out.println("PageFormat imageableX,Y " + pageFormat.getImageableX() + ", " + pageFormat.getImageableY());
            System.out.println("PageFormat imageable height: " + pageFormat.getImageableHeight());
            System.out.println("PageFormat imageable width: " + pageFormat.getImageableWidth());
            System.out.println("PageFormat orientation (LANDSCAPE=0, PORTRAIT=1): " + pageFormat.getOrientation());
            System.out.println("Graphics: clip bounds: " + graphics2d.getClipBounds());
            System.out.println("Transform: scaleX: " + at.getScaleX());
            System.out.println("Transform: scaleY: " + at.getScaleY());
            System.out.println("DPI?? : " + dpi);
        }
        graphics2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        for (Box box : this.diagram.getBoxes()) {
            graphics2d = (Graphics2D)graphics.create(box.getLocation().x, box.getLocation().y, box.getSize().width, box.getSize().height);
            box.getBoxPrinter().draw(graphics2d, this.monitor);
        }
        return 0;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.printerJob.defaultPage();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public void setPrinterJob(PrinterJob printerJob) {
        this.printerJob = printerJob;
    }
}

