/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import java.io.File;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.ui.internal.Messages;
import net.refractions.udig.printing.ui.internal.PdfPrintingEngine;
import net.refractions.udig.printing.ui.internal.editor.PageEditorInput;
import net.refractions.udig.project.ui.UDIGEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PrintAction
extends Action
implements IEditorActionDelegate {
    public void run() {
        Page page = null;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        UDIGEditorInput editorInput = (UDIGEditorInput)workbenchWindow.getActivePage().getActiveEditor().getEditorInput();
        if (editorInput instanceof PageEditorInput) {
            page = (Page)((PageEditorInput)editorInput).getProjectElement();
        }
        if (page == null) {
            throw new RuntimeException(Messages.PrintAction_pageError);
        }
        FileDialog fileDialog = new FileDialog(workbenchWindow.getShell(), 8192);
        String path = fileDialog.open();
        File outFile = null;
        if (path == null || path.length() < 1) {
            return;
        }
        if (!path.endsWith(".pdf") && !path.endsWith(".PDF")) {
            path = String.valueOf(path) + ".pdf";
        }
        outFile = new File(path);
        Page copy = (Page)EcoreUtil.copy((EObject)page);
        final PdfPrintingEngine engine = new PdfPrintingEngine(copy, outFile);
        Job job = new Job(Messages.PrintAction_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                engine.setMonitor(monitor);
                boolean printToPdf = engine.printToPdf();
                if (printToPdf) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        if (job.isSystem()) {
            job.setSystem(false);
        }
        job.schedule();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

