/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import net.refractions.udig.printing.model.BoxPrinter;
import net.refractions.udig.printing.ui.internal.PrintingPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BoxFactory {
    private IConfigurationElement configurationElement;
    private boolean visible;
    private String description;
    private ImageDescriptor smallImage;
    private ImageDescriptor largeImage;
    private String name;
    private Class<? extends BoxPrinter> type;
    private boolean attempted = false;

    public BoxFactory(IConfigurationElement element) {
        this.configurationElement = element;
        this.visible = "true".equals(element.getAttribute("visible"));
        this.description = element.getAttribute("description");
        this.smallImage = this.createDescriptor(element, element.getAttribute("smallImage"));
        this.largeImage = this.createDescriptor(element, element.getAttribute("largeImage"));
        this.name = element.getAttribute("name");
    }

    private ImageDescriptor createDescriptor(IConfigurationElement element, String imagePath) {
        if (imagePath == null) {
            return null;
        }
        String pluginID = element.getNamespaceIdentifier();
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginID, (String)imagePath);
        return imageDescriptor;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public synchronized BoxPrinter createBox() throws CoreException {
        BoxPrinter box = (BoxPrinter)this.configurationElement.createExecutableExtension("class");
        this.type = box.getClass();
        return box;
    }

    public synchronized Class<? extends BoxPrinter> getType() {
        if (this.type == null && !this.attempted) {
            this.attempted = true;
            try {
                this.createBox();
            }
            catch (CoreException e) {
                PrintingPlugin.log("", e);
            }
        }
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageDescriptor getSmallImage() {
        return this.smallImage;
    }

    public ImageDescriptor getLargeImage() {
        return this.largeImage;
    }

    public String getDefaultActionID() {
        return this.configurationElement.getAttribute("defaultAction");
    }
}

