/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.printing.ui.internal;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.printing.model.Box;
import net.refractions.udig.printing.model.Page;
import net.refractions.udig.printing.model.impl.MapBoxPrinter;
import net.refractions.udig.printing.ui.Template;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractTemplate
implements Template {
    protected List<Box> boxes = new ArrayList<Box>();
    protected double scaleDenomHint = 0.0;
    protected boolean zoomToSelectionHint = false;
    protected int numPages = 1;
    private int activePage = 0;

    @Override
    public Iterator<Box> iterator() {
        return this.boxes.iterator();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Template clone() {
        try {
            return (Template)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getPreferredOrientation() {
        return 0;
    }

    @Override
    public void setMapScaleHint(double scaleDenom) {
        this.scaleDenomHint = scaleDenom;
    }

    @Override
    public double getMapScaleHint() {
        return this.scaleDenomHint;
    }

    @Override
    public void setZoomToSelectionHint(boolean hint) {
        this.zoomToSelectionHint = hint;
    }

    @Override
    public boolean getZoomToSelectionHint() {
        return this.zoomToSelectionHint;
    }

    @Override
    public Rectangle getMapBounds() throws IllegalStateException {
        Rectangle bounds = null;
        for (Box box : this.boxes) {
            if (!(box.getBoxPrinter() instanceof MapBoxPrinter)) continue;
            Dimension size = box.getSize();
            Point location = box.getLocation();
            bounds = new Rectangle(location.x, location.y, size.width, size.height);
        }
        return bounds;
    }

    protected Font getFont(int size, int style) {
        try {
            String face = "PLAIN";
            if (style == 1) {
                face = "BOLD";
            }
            Font font = Font.decode("Arial-" + face + "-" + size);
            return font;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getNumPages() {
        return 1;
    }

    @Override
    public void setActivePage(int page) {
        this.activePage = page;
    }

    @Override
    public int getActivePage() {
        return this.activePage;
    }

    protected void setPageSizeFromPaperSize(Page page, Dimension paperSize) {
        float factor = (float)paperSize.width / (float)paperSize.height;
        Dimension pageSize = page.getSize();
        int h = (int)((float)pageSize.height * 0.97f);
        int w = (int)((float)h * factor);
        page.setSize(new Dimension(w, h));
    }

    protected float scaleValue(Page page, Dimension paperSize, float previousValue) {
        float factor = (float)page.getSize().width / (float)paperSize.height;
        int resizedValue = (int)(previousValue * factor);
        if (resizedValue < 4) {
            resizedValue = 4;
        }
        return resizedValue;
    }
}

