/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.shp.op;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.shp.ShpPlugin;
import net.refractions.udig.catalog.internal.shp.ShpServiceExtension;
import net.refractions.udig.core.AdapterUtil;
import net.refractions.udig.ui.CRSChooserDialog;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SetProjection
implements IOp {
    public void op(final Display display, Object target, IProgressMonitor monitor) throws Exception {
        Object[] targets = (Object[])target;
        final ShapefileDataStore[] allDatastores = new ShapefileDataStore[targets.length];
        CoordinateReferenceSystem crs = null;
        int i = 0;
        while (i < allDatastores.length) {
            Object object = targets[i];
            allDatastores[i] = (ShapefileDataStore)AdapterUtil.instance.adaptTo(ShapefileDataStore.class, object, monitor);
            if (crs == null) {
                crs = (CoordinateReferenceSystem)AdapterUtil.instance.adaptTo(CoordinateReferenceSystem.class, object, monitor);
            }
            ++i;
        }
        final CoordinateReferenceSystem finalCRS = crs;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CRSChooserDialog dialog;
                    CoordinateReferenceSystem initVal = finalCRS;
                    if (initVal == null) {
                        initVal = allDatastores[0].getSchema().getCoordinateReferenceSystem();
                    }
                    if ((dialog = new CRSChooserDialog(display.getActiveShell(), initVal)).open() == 1) {
                        return;
                    }
                    CoordinateReferenceSystem result = dialog.getResult();
                    if (result != null) {
                        ShapefileDataStore[] shapefileDataStoreArray = allDatastores;
                        int n = allDatastores.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ShapefileDataStore ds = shapefileDataStoreArray[n2];
                            CoordinateReferenceSystem crs = ds.getSchema().getCoordinateReferenceSystem();
                            if (!CRS.equalsIgnoreMetadata((Object)result, (Object)crs)) {
                                ds.forceSchemaCRS(result);
                            }
                            ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
                            List members = catalog.members((IProgressMonitor)new NullProgressMonitor());
                            for (IResolve resolve : members) {
                                ShapefileDataStore store = (ShapefileDataStore)resolve.resolve(ShapefileDataStore.class, (IProgressMonitor)new NullProgressMonitor());
                                if (store == null || !ds.getSchema().getTypeName().equals(store.getSchema().getTypeName())) continue;
                                ShpServiceExtension fac = new ShpServiceExtension();
                                Map<String, Serializable> params = fac.createParams(resolve.getIdentifier());
                                IService replacement = fac.createService(resolve.getIdentifier(), params);
                                catalog.replace(resolve.getID(), replacement);
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error writing projection", (String)"An unexpected error occurred while setting the projection.\nPlease send error log.");
                    ShpPlugin.log("Error writing projection", e);
                }
            }
        });
    }
}

