/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.shp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.shp.ShpGeoResourceInfo;
import net.refractions.udig.catalog.internal.shp.ShpServiceImpl;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.style.GraphicalSymbol;

public class ShpGeoResourceImpl
extends IGeoResource {
    ShpServiceImpl parent;
    String typename = null;
    private URL identifier;
    private ID id;

    public ShpGeoResourceImpl(ShpServiceImpl parent, String typename) {
        this.service = parent;
        this.parent = parent;
        this.typename = typename;
        try {
            this.identifier = new URL(String.valueOf(parent.getIdentifier().toString()) + "#" + typename);
            this.id = new ID(parent.getID(), typename);
        }
        catch (MalformedURLException malformedURLException) {
            this.identifier = parent.getIdentifier();
        }
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public ID getID() {
        return this.id;
    }

    public IResolve.Status getStatus() {
        return this.parent.getStatus();
    }

    public Throwable getMessage() {
        return this.parent.getMessage();
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        Style style;
        SimpleFeatureSource fs;
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class) && (fs = this.featureSource(monitor)) instanceof SimpleFeatureStore) {
            return adaptee.cast(fs);
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class) && (fs = this.featureSource(monitor)) instanceof SimpleFeatureStore) {
            return adaptee.cast(fs);
        }
        if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
            return adaptee.cast(this.featureSource(monitor));
        }
        if (adaptee.isAssignableFrom(IndexedShapefileDataStore.class)) {
            return adaptee.cast(this.parent.getDS(monitor));
        }
        if (adaptee.isAssignableFrom(Style.class) && (style = this.style(monitor)) != null) {
            return adaptee.cast(this.style(monitor));
        }
        return (T)super.resolve(adaptee, monitor);
    }

    private SimpleFeatureSource featureSource(IProgressMonitor monitor) throws IOException {
        return this.parent.getDS(monitor).getFeatureSource();
    }

    public Style style(IProgressMonitor monitor) throws IOException {
        SimpleFeatureSource source = this.featureSource(null);
        SimpleFeatureType featureType = (SimpleFeatureType)source.getSchema();
        ID fileID = this.parent.getID();
        if (!fileID.isFile()) {
            return null;
        }
        File file = fileID.toFile("sld");
        if (!file.exists() && !(file = fileID.toFile("SLD")).exists()) {
            return null;
        }
        StyledLayerDescriptor sld = SLDs.parseSLD((File)file);
        if (sld == null) {
            return null;
        }
        Style[] styles = SLDs.styles((StyledLayerDescriptor)sld);
        if (styles != null && styles.length > 0) {
            Style style = SLDs.matchingStyle((Style[])styles, (SimpleFeatureType)featureType);
            if (style == null) {
                style = styles[0];
            }
            this.makeGraphicsAbsolute(file, style);
            return style;
        }
        return null;
    }

    private void makeGraphicsAbsolute(File relatedFile, Style style) {
        File parentFolder = relatedFile.getParentFile();
        ExternalGraphicsAbsolutePathMaker visitor = new ExternalGraphicsAbsolutePathMaker(parentFolder);
        visitor.visit(style);
    }

    public ShpServiceImpl service() {
        return this.parent;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(SimpleFeatureStore.class) || adaptee.isAssignableFrom(FeatureSource.class) || adaptee.isAssignableFrom(SimpleFeatureSource.class) || adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(Style.class) || super.canResolve(adaptee);
    }

    public ShpGeoResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (ShpGeoResourceInfo)super.getInfo(monitor);
    }

    protected ShpGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        return new ShpGeoResourceInfo(this);
    }

    private class ExternalGraphicsAbsolutePathMaker
    implements StyleVisitor {
        private final File parentFolder;

        public ExternalGraphicsAbsolutePathMaker(File parentFolder) {
            this.parentFolder = parentFolder;
        }

        public void visit(StyledLayerDescriptor sld) {
        }

        public void visit(NamedLayer layer) {
        }

        public void visit(UserLayer layer) {
        }

        public void visit(Style style) {
            List fts = style.featureTypeStyles();
            for (FeatureTypeStyle featureTypeStyle : fts) {
                featureTypeStyle.accept((StyleVisitor)this);
            }
        }

        public void visit(Rule rule) {
            List syms = rule.symbolizers();
            for (Symbolizer symbolizer : syms) {
                symbolizer.accept((StyleVisitor)this);
            }
        }

        public void visit(FeatureTypeStyle fts) {
            List rules = fts.rules();
            for (Rule rule : rules) {
                rule.accept((StyleVisitor)this);
            }
        }

        public void visit(Fill fill) {
            Graphic graphicFill = fill.getGraphicFill();
            if (graphicFill != null) {
                graphicFill.accept((StyleVisitor)this);
            }
        }

        public void visit(Stroke stroke) {
            Graphic graphicStroke;
            Graphic graphicFill = stroke.getGraphicFill();
            if (graphicFill != null) {
                graphicFill.accept((StyleVisitor)this);
            }
            if ((graphicStroke = stroke.getGraphicStroke()) != null) {
                graphicStroke.accept((StyleVisitor)this);
            }
        }

        public void visit(Symbolizer sym) {
            if (sym instanceof RasterSymbolizer) {
                this.visit((RasterSymbolizer)sym);
            } else if (sym instanceof LineSymbolizer) {
                this.visit((LineSymbolizer)sym);
            } else if (sym instanceof PolygonSymbolizer) {
                this.visit((PolygonSymbolizer)sym);
            } else if (sym instanceof PointSymbolizer) {
                this.visit((PointSymbolizer)sym);
            } else if (sym instanceof TextSymbolizer) {
                this.visit((TextSymbolizer)sym);
            } else {
                throw new RuntimeException("visit(Symbolizer) unsupported");
            }
        }

        public void visit(PointSymbolizer ps) {
            Graphic graphic = ps.getGraphic();
            if (graphic != null) {
                graphic.accept((StyleVisitor)this);
            }
        }

        public void visit(LineSymbolizer line) {
            Stroke stroke = line.getStroke();
            if (stroke != null) {
                stroke.accept((StyleVisitor)this);
            }
        }

        public void visit(PolygonSymbolizer poly) {
            Fill fill;
            Stroke stroke = poly.getStroke();
            if (stroke != null) {
                stroke.accept((StyleVisitor)this);
            }
            if ((fill = poly.getFill()) != null) {
                fill.accept((StyleVisitor)this);
            }
        }

        public void visit(TextSymbolizer text) {
        }

        public void visit(RasterSymbolizer raster) {
        }

        public void visit(Graphic gr) {
            List graphicalSymbols = gr.graphicalSymbols();
            for (GraphicalSymbol graphicalSymbol : graphicalSymbols) {
                if (!(graphicalSymbol instanceof ExternalGraphic)) continue;
                ExternalGraphic ext = (ExternalGraphic)graphicalSymbol;
                ext.accept((StyleVisitor)this);
            }
        }

        public void visit(Mark mark) {
        }

        public void visit(ExternalGraphic exgr) {
            try {
                File newFile;
                URL location = exgr.getLocation();
                File urlToFile = URLUtils.urlToFile((URL)location);
                if (urlToFile != null && !urlToFile.exists() && (newFile = new File(this.parentFolder, urlToFile.getPath())).exists()) {
                    exgr.setLocation(newFile.toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }

        public void visit(PointPlacement pp) {
        }

        public void visit(AnchorPoint ap) {
        }

        public void visit(Displacement dis) {
        }

        public void visit(LinePlacement lp) {
        }

        public void visit(Halo halo) {
        }

        public void visit(FeatureTypeConstraint ftc) {
        }

        public void visit(ColorMap colorMap) {
        }

        public void visit(ColorMapEntry colorMapEntry) {
        }

        public void visit(ContrastEnhancement contrastEnhancement) {
        }

        public void visit(ImageOutline outline) {
        }

        public void visit(ChannelSelection cs) {
        }

        public void visit(OverlapBehavior ob) {
        }

        public void visit(SelectedChannelType sct) {
        }

        public void visit(ShadedRelief sr) {
        }
    }
}

