/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.shp;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.ServiceMover;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.shp.ShpServiceImpl;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;

public class ShapeMover
implements ServiceMover {
    private ShpServiceImpl shapefile;
    private String[] extentions = new String[]{".shp", ".prj", ".dbf", ".shx", ".fix", ".qix", ".xml", ".grx"};

    public ShapeMover(IResolve resolve) {
        this.shapefile = (ShpServiceImpl)resolve;
    }

    public File toFile() {
        Map<String, Serializable> parametersMap = this.shapefile.getConnectionParams();
        URL url = (URL)parametersMap.get(ShapefileDataStoreFactory.URLP.key);
        return URLUtils.urlToFile((URL)url);
    }

    public String move(File destinationFolder) {
        if (!destinationFolder.exists() || !destinationFolder.isDirectory()) {
            return "Indicated directory does not exist:" + destinationFolder;
        }
        Map<String, Serializable> parametersMap = this.shapefile.getConnectionParams();
        URL url = (URL)parametersMap.get(ShapefileDataStoreFactory.URLP.key);
        File file = URLUtils.urlToFile((URL)url);
        String completeShapeFilePath = file.getAbsolutePath();
        completeShapeFilePath = completeShapeFilePath.replaceAll("\\\\", "/");
        int dotPosition = completeShapeFilePath.lastIndexOf(".");
        String completeShapefileBasePath = completeShapeFilePath.substring(0, dotPosition);
        try {
            this.updateConnectionParameters(destinationFolder, parametersMap, completeShapeFilePath);
        }
        catch (MalformedURLException malformedURLException) {
            return "Failed to update the service's connection Parameters";
        }
        String[] stringArray = this.extentions;
        int n = this.extentions.length;
        int n2 = 0;
        while (n2 < n) {
            boolean success;
            String extention = stringArray[n2];
            File tmpFile = new File(String.valueOf(completeShapefileBasePath) + extention);
            if (tmpFile.exists()) {
                success = tmpFile.renameTo(new File(destinationFolder, tmpFile.getName()));
                if (!success) {
                    return "Wasn't able to move file: " + tmpFile.getAbsolutePath();
                }
            } else {
                extention = extention.toUpperCase();
                tmpFile = new File(String.valueOf(completeShapefileBasePath) + extention);
                if (tmpFile.exists() && !(success = tmpFile.renameTo(new File(destinationFolder, tmpFile.getName())))) {
                    return "Wasn't able to move file: " + tmpFile.getAbsolutePath();
                }
            }
            ++n2;
        }
        ID id = this.shapefile.getID();
        IServiceFactory serviceFactory = CatalogPlugin.getDefault().getServiceFactory();
        IService newService = (IService)serviceFactory.createService(parametersMap).iterator().next();
        ICatalog localCatalog = CatalogPlugin.getDefault().getLocalCatalog();
        localCatalog.replace(id, newService);
        return null;
    }

    private void updateConnectionParameters(File destinationFolder, Map<String, Serializable> parametersMap, String completeShapeFilePath) throws MalformedURLException {
        int lastSlash = completeShapeFilePath.lastIndexOf("/");
        String shpName = completeShapeFilePath.substring(lastSlash);
        String destinationPath = destinationFolder.getAbsolutePath();
        String urlString = String.valueOf(destinationPath) + shpName;
        urlString = urlString.replaceAll("//", "/");
        URL url = new URL("file://" + urlString);
        parametersMap.put(ShapefileDataStoreFactory.URLP.key, url);
    }
}

