/*
 * Decompiled with CFR 0.152.
 */
package org.omscentral.modules.analysis.esp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.omscentral.modules.analysis.esp.ESPTimeSeries;
import org.omscentral.modules.analysis.esp.ModelDateTime;
import org.omscentral.modules.analysis.esp.TimeSeriesCookie;

public class TimeSeriesPlotter {
    TimeSeriesCollection dataset = null;
    JFreeChart chart = null;
    ChartPanel chartPanel = null;
    private boolean isLog = false;

    public ChartPanel getPanel() {
        return this.chartPanel;
    }

    public TimeSeriesPlotter(String title, String xAxisLabel, String yAxisLabel, boolean isLog) {
        this.isLog = isLog;
        this.dataset = new TimeSeriesCollection();
        this.chart = TimeSeriesPlotter.createChart((XYDataset)this.dataset, title, xAxisLabel, yAxisLabel, isLog);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setBackground(Color.WHITE);
    }

    public TimeSeriesPlotter(String title, String xAxisLabel, String yAxisLabel) {
        this.isLog = false;
        this.dataset = new TimeSeriesCollection();
        this.chart = TimeSeriesPlotter.createChart((XYDataset)this.dataset, title, xAxisLabel, yAxisLabel, false);
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
        this.chartPanel = new ChartPanel(this.chart);
    }

    private static JFreeChart createChart(XYDataset dataset, String title, String xAxisLabel, String yAxisLabel, boolean isLog) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        if (isLog) {
            LogarithmicAxis yAxis = new LogarithmicAxis("Log Values");
            plot.setRangeAxis((ValueAxis)yAxis);
        }
        plot.addRangeMarker((Marker)new ValueMarker(550.0));
        return chart;
    }

    public void clearAll() {
        this.dataset.removeAllSeries();
    }

    public void clearTrace(String traceLabel) {
        TimeSeries series = this.dataset.getSeries((Comparable)((Object)traceLabel));
        if (series != null) {
            this.dataset.removeSeries(series);
        }
    }

    public void addTrace(TimeSeriesCookie tsc) {
        TimeSeries series = new TimeSeries((Comparable)((Object)tsc.getName()), Day.class);
        double[] vals = tsc.getVals();
        double[] dates = tsc.getDates();
        ModelDateTime mdt = new ModelDateTime();
        for (int i = 0; i < vals.length; ++i) {
            mdt.setJul2Greg(dates[i]);
            if (this.isLog) {
                if (vals[i] <= 0.0) {
                    series.add((RegularTimePeriod)new Day(mdt.getDay(), mdt.getMonth(), mdt.getYear()), Double.NaN);
                    continue;
                }
                series.add((RegularTimePeriod)new Day(mdt.getDay(), mdt.getMonth(), mdt.getYear()), vals[i]);
                continue;
            }
            series.add((RegularTimePeriod)new Day(mdt.getDay(), mdt.getMonth(), mdt.getYear()), vals[i]);
        }
        this.dataset.addSeries(series);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Time Series Demo");
        TimeSeriesPlotter plotter = new TimeSeriesPlotter("Time Series Plot", "Date", "Value");
        frame.getContentPane().add((Component)plotter.getPanel());
        frame.setSize(600, 500);
        frame.setVisible(true);
        double[] x = new double[]{2453325.0, 2453326.0, 2453327.0};
        double[] y1 = new double[]{2.0, 4.0, 8.0};
        plotter.addTrace(new ESPTimeSeries("data 1", x, y1, null, null, null, null, null));
        double[] y2 = new double[]{8.0, 4.0, 2.0};
        plotter.addTrace(new ESPTimeSeries("data 2", x, y2, null, null, null, null, null));
    }
}

