/*
 * Decompiled with CFR 0.152.
 */
package org.omscentral.modules.analysis.esp;

import org.omscentral.modules.analysis.esp.EnsembleData;
import org.omscentral.modules.analysis.esp.Format;
import org.omscentral.modules.analysis.esp.TimeSeriesCookie;

public class EnsembleListLabel {
    private double traceVolume;
    private double tracePeak;
    private double timeToPeak;
    private TimeSeriesCookie forecast;
    private double actVolumeProb;
    private double roundVolumeProb;
    private double actPeakProb;
    private double roundPeakProb;
    private int volumeRank;
    private int peakRank;
    private Format probFormat = new Format("%5.1f");
    private EnsembleData ensembleData;

    public EnsembleListLabel(TimeSeriesCookie forecast, EnsembleData ensembleData) {
        this.forecast = forecast;
        this.ensembleData = ensembleData;
    }

    public EnsembleListLabel(EnsembleListLabel ell) {
        this.traceVolume = ell.traceVolume;
        this.tracePeak = ell.tracePeak;
        this.timeToPeak = ell.timeToPeak;
        this.forecast = ell.forecast;
        this.actVolumeProb = ell.actVolumeProb;
        this.roundVolumeProb = ell.roundVolumeProb;
        this.actPeakProb = ell.actPeakProb;
        this.roundPeakProb = ell.roundPeakProb;
        this.volumeRank = ell.volumeRank;
        this.peakRank = ell.peakRank;
        this.ensembleData = ell.ensembleData;
    }

    public String toString() {
        if (this.ensembleData == null) {
            return this.forecast.getName();
        }
        if (this.ensembleData.getSortOrder() == EnsembleData.YEAR) {
            return this.forecast.getName();
        }
        if (this.ensembleData.getSortOrder() == EnsembleData.VOLUME) {
            return this.getEspToolVolumeLabel();
        }
        if (this.ensembleData.getSortOrder() == EnsembleData.PEAK) {
            return this.getEspToolPeakLabel();
        }
        return this.forecast.getName();
    }

    public String getTraceName() {
        return this.forecast.getName();
    }

    public int getTraceYear() {
        return Integer.parseInt(this.forecast.getName());
    }

    public String getEspToolVolumeLabel() {
        return this.forecast.getName() + "   [actP=" + this.probFormat.form(this.actVolumeProb) + " dmiP=" + this.probFormat.form(this.roundVolumeProb) + "]";
    }

    public String getEspToolPeakLabel() {
        return this.forecast.getName() + "   [actP=" + this.probFormat.form(this.actPeakProb) + " dmiP= " + this.probFormat.form(this.roundPeakProb) + "]";
    }

    public double getTraceVolume() {
        return this.traceVolume;
    }

    public void setTraceVolume(double traceVolume) {
        this.traceVolume = traceVolume;
    }

    public double getTracePeak() {
        return this.tracePeak;
    }

    public void setTracePeak(double tracePeak) {
        this.tracePeak = tracePeak;
    }

    public double getTimeToPeak() {
        return this.timeToPeak;
    }

    public void setTimeToPeak(double timeToPeak) {
        this.timeToPeak = timeToPeak;
    }

    public TimeSeriesCookie getForecast() {
        return this.forecast;
    }

    public void setForecast(TimeSeriesCookie forecast) {
        this.forecast = forecast;
    }

    public double getActVolumeProb() {
        return this.actVolumeProb;
    }

    public void setActVolumeProb(double actVolumeProb) {
        this.actVolumeProb = actVolumeProb;
    }

    public double getRoundVolumeProb() {
        return this.roundVolumeProb;
    }

    public void setRoundVolumeProb(double roundVolumeProb) {
        this.roundVolumeProb = roundVolumeProb;
    }

    public double getActPeakProb() {
        return this.actPeakProb;
    }

    public void setActPeakProb(double actPeakProb) {
        this.actPeakProb = actPeakProb;
    }

    public double getRoundPeakProb() {
        return this.roundPeakProb;
    }

    public void setRoundPeakProb(double roundPeakProb) {
        this.roundPeakProb = roundPeakProb;
    }

    public int getVolumeRank() {
        return this.volumeRank;
    }

    public void setVolumeRank(int volumeRank) {
        this.volumeRank = volumeRank;
    }

    public int getPeakRank() {
        return this.peakRank;
    }

    public void setPeakRank(int peakRank) {
        this.peakRank = peakRank;
    }
}

