/*
 * Decompiled with CFR 0.152.
 */
package org.omscentral.modules.analysis.esp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omscentral.modules.analysis.esp.ESPTimeSeries;
import org.omscentral.modules.analysis.esp.ElNino;
import org.omscentral.modules.analysis.esp.EnsembleData;
import org.omscentral.modules.analysis.esp.EnsembleListLabel;
import org.omscentral.modules.analysis.esp.Format;
import org.omscentral.modules.analysis.esp.ModelDateTime;
import org.omscentral.modules.analysis.esp.TimeSeriesCookie;
import org.omscentral.modules.analysis.esp.TimeSeriesPlotter;

public class ESPToolPanel
extends JPanel {
    private static final long serialVersionUID = 389026251362838555L;
    private ModelDateTime analysisStart = new ModelDateTime();
    private ModelDateTime analysisEnd = new ModelDateTime();
    private EnsembleData ensembleData;
    private TimeSeriesPlotter plotter;
    private DefaultListModel listModel = new DefaultListModel();
    private JSpinner analysisEndSpinner;
    private JSpinner analysisStartSpinner;
    private ButtonGroup buttonGroup1;
    private JLabel ensembleEndLabel;
    private JLabel ensembleStartLabel;
    private JLabel initEndLabel;
    private JLabel initStartLabel;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JScrollPane jScrollPane1;
    private JButton reportButton;
    private JLabel resultPath;
    private JPanel rightPanel;
    private JComboBox selectYearsCombo;
    private JList traceListList;

    public ESPToolPanel(EnsembleData ed) {
        this.ensembleData = ed;
        this.initComponents();
        this.traceListList.setModel(this.listModel);
        this.plotter = new TimeSeriesPlotter(ed.getName(), "Date", "Flow");
        this.rightPanel.add((Component)this.plotter.getPanel());
        this.plotData(ed.getInitialization());
        ArrayList<ESPTimeSeries> forecasts = ed.getForecasts();
        TimeSeriesCookie forecastTS = forecasts.get(0);
        this.analysisStart = (ModelDateTime)forecastTS.getStart().clone();
        this.analysisEnd = (ModelDateTime)forecastTS.getEnd().clone();
        this.setDefaultDates();
        ed.setAnalysisPeriod(this.analysisStart, this.analysisEnd);
        this.loadList();
    }

    public void plotData(TimeSeriesCookie tsc) {
        this.plotter.addTrace(tsc);
    }

    public void plotData(TimeSeriesCookie[] tscs) {
        for (int i = 0; i < tscs.length; ++i) {
            this.plotData(tscs[i]);
        }
    }

    private void setDefaultDates() {
        ModelDateTime initStart = this.ensembleData.getInitializationStart();
        ModelDateTime initEnd = this.ensembleData.getInitializationEnd();
        ModelDateTime forecastStart = this.ensembleData.getForecastStart();
        ModelDateTime forecastEnd = this.ensembleData.getForecastEnd();
        this.initStartLabel.setText(initStart.getJDBCDate().toString());
        this.initEndLabel.setText(initEnd.getJDBCDate().toString());
        this.ensembleStartLabel.setText(forecastStart.getJDBCDate().toString());
        this.ensembleEndLabel.setText(forecastEnd.getJDBCDate().toString());
        this.analysisStartSpinner.setModel(new SpinnerDateModel(this.analysisStart.getTime(), initStart.getTime(), forecastEnd.getTime(), 5));
        this.analysisStartSpinner.setEditor(new JSpinner.DateEditor(this.analysisStartSpinner, "yyyy-MM-dd"));
        this.analysisEndSpinner.setModel(new SpinnerDateModel(this.analysisEnd.getTime(), initStart.getTime(), forecastEnd.getTime(), 5));
        this.analysisEndSpinner.setEditor(new JSpinner.DateEditor(this.analysisEndSpinner, "yyyy-MM-dd"));
    }

    private void loadList() {
        this.listModel.clear();
        ArrayList<EnsembleListLabel> order = this.ensembleData.getSortOrder() == EnsembleData.VOLUME ? this.ensembleData.getStatsInVolumeOrder() : (this.ensembleData.getSortOrder() == EnsembleData.PEAK ? this.ensembleData.getStatsInPeakOrder() : this.ensembleData.getStats());
        for (int i = 0; i < order.size(); ++i) {
            EnsembleListLabel tsi = order.get(i);
            this.listModel.addElement(tsi);
        }
    }

    public void setResult(String resultFile) {
        this.resultPath.setText(resultFile);
    }

    public EnsembleData getEnsembleData() {
        return this.ensembleData;
    }

    public void setEnsembleData(EnsembleData ensembleData) {
        this.ensembleData = ensembleData;
        this.setDefaultDates();
    }

    public JList getTraceListList() {
        return this.traceListList;
    }

    public void setTraceListList(JList traceListList) {
        this.traceListList = traceListList;
    }

    public ModelDateTime getAnalysisStart() {
        return this.analysisStart;
    }

    public void setAnalysisStart(ModelDateTime analysisStart) {
        this.analysisStart = analysisStart;
        this.analysisStartSpinner.setValue(analysisStart.getJDBCDate().toString());
    }

    public ModelDateTime getAnalysisEnd() {
        return this.analysisEnd;
    }

    public void setAnalysisEnd(ModelDateTime analysisEnd) {
        this.analysisEnd = analysisEnd;
        this.analysisEndSpinner.setValue(analysisEnd.getJDBCDate().toString());
    }

    static void writeReport(ESPToolPanel top, Writer out) {
        Format f1 = new Format("%11.1f");
        Format f2 = new Format("%3i");
        Format f3 = new Format("%8.1f");
        Format f4 = new Format("%4.1f");
        EnsembleData ed = top.getEnsembleData();
        ArrayList<EnsembleListLabel> stats = ed.getStats();
        ModelDateTime mdt = new ModelDateTime();
        try {
            out.write("Report for '" + ed.getName() + "'\n");
            out.write("        Analysis Period: " + top.getAnalysisStart() + " to " + top.getAnalysisEnd() + "\n");
            out.write("  Initialization Period: " + ed.getInitializationStart() + " to " + ed.getInitializationEnd() + "\n");
            out.write("        Forecast Period: " + ed.getForecastStart() + " to " + ed.getForecastEnd() + "\n\n\n");
            out.write("                        Summary of All Traces for Analysis Period\n\n");
            out.write("Historic   Volume      Volume    Volume    Volume    Peak   Peak    Peak\n");
            out.write("  Year    (cfs-days)  (acre-ft)   Rank   Exceedance  (cfs)  Rank  Exceedance   Date of Peak\n");
            out.write("--------  ----------  ---------  ------  ----------  ----   ----  ----------   ------------\n");
            for (EnsembleListLabel ell : stats) {
                mdt.setJul2Greg(ell.getTimeToPeak());
                out.write("  " + ell.getTraceYear() + "  " + f1.form(ell.getTraceVolume()) + "" + f1.form(ell.getTraceVolume() * 1.9835) + "    " + f2.form(ell.getVolumeRank()) + "       " + f4.form(ell.getActVolumeProb()) + "  " + f3.form(ell.getTracePeak()) + "  " + f2.form(ell.getPeakRank()) + "      " + f4.form(ell.getActPeakProb()) + "       " + mdt + "\n");
            }
            Object[] sel = top.getTraceListList().getSelectedValues();
            ArrayList<EnsembleListLabel> selStatsInVolumeOrder = new ArrayList<EnsembleListLabel>(sel.length);
            ArrayList<EnsembleListLabel> selStatsInPeakOrder = new ArrayList<EnsembleListLabel>(sel.length);
            ArrayList<EnsembleListLabel> selYearOrder = new ArrayList<EnsembleListLabel>(sel.length);
            for (int i = 0; i < sel.length; ++i) {
                EnsembleListLabel tsi = new EnsembleListLabel((EnsembleListLabel)sel[i]);
                selStatsInVolumeOrder.add(i, tsi);
                selStatsInPeakOrder.add(i, tsi);
                selYearOrder.add(i, tsi);
            }
            EnsembleData.sort(selStatsInVolumeOrder, selStatsInPeakOrder);
            if (sel.length > 0) {
                ArrayList<EnsembleListLabel> order;
                if (ed.getSortOrder() == EnsembleData.VOLUME) {
                    order = selStatsInVolumeOrder;
                    out.write("\n\n\n               Summary of Selected Traces for Analysis Period (by Volume)\n\n");
                } else if (ed.getSortOrder() == EnsembleData.PEAK) {
                    order = selStatsInPeakOrder;
                    out.write("\n\n\n              Summary of Selected Traces for Analysis Period (by Peak)\n\n");
                } else {
                    order = selYearOrder;
                    out.write("\n\n\n              Summary of Selected Traces for Analysis Period (by Year)\n\n");
                }
                out.write("Historic   Volume      Volume    Volume    Volume    Peak   Peak    Peak\n");
                out.write("  Year    (cfs-days)  (acre-ft)   Rank   Exceedance  (cfs)  Rank  Exceedance   Date of Peak\n");
                out.write("--------  ----------  ---------  ------  ----------  ----   ----  ----------   ------------\n");
                for (EnsembleListLabel ell : order) {
                    mdt.setJul2Greg(ell.getTimeToPeak());
                    out.write("  " + ell.getTraceYear() + "  " + f1.form(ell.getTraceVolume()) + "" + f1.form(ell.getTraceVolume() * 1.9835) + "    " + f2.form(ell.getVolumeRank()) + "       " + f4.form(ell.getActVolumeProb()) + "  " + f3.form(ell.getTracePeak()) + "  " + f2.form(ell.getPeakRank()) + "      " + f4.form(ell.getActPeakProb()) + "       " + mdt + "\n");
                }
            }
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeReport(String report) throws IOException {
        FileWriter w = new FileWriter(report);
        ESPToolPanel.writeReport(this, w);
        w.close();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.rightPanel = new JPanel();
        this.reportButton = new JButton();
        this.resultPath = new JLabel();
        this.jLabel2 = new JLabel();
        this.selectYearsCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.traceListList = new JList();
        this.jLabel4 = new JLabel();
        this.initStartLabel = new JLabel();
        this.initEndLabel = new JLabel();
        this.jLabel7 = new JLabel();
        this.ensembleStartLabel = new JLabel();
        this.ensembleEndLabel = new JLabel();
        this.jLabel11 = new JLabel();
        this.analysisStartSpinner = new JSpinner();
        this.analysisEndSpinner = new JSpinner();
        this.rightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rightPanel.setLayout(new BorderLayout());
        this.reportButton.setText("Report");
        this.reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ESPToolPanel.this.reportButtonActionPerformed(evt);
            }
        });
        this.resultPath.setText("path ..");
        this.jLabel2.setText("Traces: ");
        this.selectYearsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"La Nina", "El Nino ", "ENSO Neutral", "PDO < -0.5", "PDO > 0.5", "PDO Neutral"}));
        this.selectYearsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ESPToolPanel.this.selectYearsComboItemStateChanged(evt);
            }
        });
        this.jLabel3.setText("Sort by:");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Volume");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ESPToolPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Peak");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ESPToolPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("Year");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ESPToolPanel.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.traceListList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ESPToolPanel.this.traceListListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.traceListList);
        this.jLabel4.setText("Init:");
        this.initStartLabel.setText("jLabel5");
        this.initEndLabel.setText("jLabel6");
        this.jLabel7.setText("Forecast:");
        this.ensembleStartLabel.setText("jLabel8");
        this.ensembleEndLabel.setText("jLabel9");
        this.jLabel11.setText("Analysis");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton3)).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 58, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.ensembleEndLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.ensembleStartLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.initEndLabel, GroupLayout.Alignment.LEADING, -1, 92, Short.MAX_VALUE).addComponent(this.initStartLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectYearsCombo, -2, 141, -2)).addComponent(this.jScrollPane1, -2, 184, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11).addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.analysisStartSpinner, -1, 120, Short.MAX_VALUE).addComponent(this.analysisEndSpinner, -1, 120, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.resultPath, -1, 277, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.reportButton)).addComponent(this.rightPanel, -1, 352, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultPath).addComponent(this.jLabel2).addComponent(this.selectYearsCombo, -2, -1, -2).addComponent(this.reportButton)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rightPanel, GroupLayout.Alignment.TRAILING, -1, 281, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 99, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.initStartLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.initEndLabel).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.ensembleStartLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ensembleEndLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.analysisStartSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.analysisEndSpinner, -2, -1, -2))).addContainerGap()));
    }

    private void reportButtonActionPerformed(ActionEvent evt) {
        PrintWriter w = new PrintWriter(System.out);
        ESPToolPanel.writeReport(this, w);
    }

    private void selectYearsComboItemStateChanged(ItemEvent evt) {
        int sel = this.selectYearsCombo.getSelectedIndex();
        int flag = ElNino.UNKNOWN;
        switch (sel) {
            case 0: {
                flag = ElNino.LA_NINA;
                break;
            }
            case 1: {
                flag = ElNino.EL_NINO;
                break;
            }
            case 2: {
                flag = ElNino.NEUTRAL;
                break;
            }
            case 3: {
                flag = ElNino.NEG_PDO;
                break;
            }
            case 4: {
                flag = ElNino.POS_PDO;
                break;
            }
            case 5: {
                flag = ElNino.NEU_PDO;
                break;
            }
            default: {
                throw new IllegalArgumentException("combo");
            }
        }
        this.selectListItems(flag);
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.ensembleData.setSortOrder(EnsembleData.VOLUME);
        this.loadList();
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.ensembleData.setSortOrder(EnsembleData.PEAK);
        this.loadList();
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.ensembleData.setSortOrder(EnsembleData.YEAR);
        this.loadList();
    }

    private void traceListListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            for (EnsembleListLabel ell : this.ensembleData.getStats()) {
                this.plotter.clearTrace(ell.getTraceName());
            }
            if (this.traceListList.getSelectedIndex() != -1) {
                Object[] sel = this.traceListList.getSelectedValues();
                for (int i = 0; i < sel.length; ++i) {
                    EnsembleListLabel ell = (EnsembleListLabel)sel[i];
                    this.plotData(ell.getForecast());
                }
            }
        }
    }

    public void selectListItems(int enso_code) {
        int count = 0;
        for (int j = 0; j < this.listModel.getSize(); ++j) {
            EnsembleListLabel label = (EnsembleListLabel)this.listModel.getElementAt(j);
            if (!ElNino.lookUp(enso_code, label)) continue;
            ++count;
        }
        int[] sel = new int[count];
        count = 0;
        for (int j = 0; j < this.listModel.getSize(); ++j) {
            EnsembleListLabel label = (EnsembleListLabel)this.listModel.getElementAt(j);
            if (!ElNino.lookUp(enso_code, label)) continue;
            sel[count++] = j;
        }
        this.traceListList.setSelectedIndices(sel);
    }
}

