/*
 * Decompiled with CFR 0.152.
 */
package org.omscentral.modules.analysis.esp;

import org.omscentral.modules.analysis.esp.ModelDateTime;
import org.omscentral.modules.analysis.esp.TimeSeriesCookie;

public class ESPTimeSeries
implements TimeSeriesCookie {
    private double[] dates;
    private double[] vals;
    private ModelDateTime start;
    private ModelDateTime end;
    private String description;
    private String name;
    private String source;
    private String units;

    public ESPTimeSeries(String name, double[] dates, double[] vals, ModelDateTime start, ModelDateTime end, String description, String source, String units) {
        this.name = name;
        this.dates = dates;
        this.vals = vals;
        this.start = start;
        this.end = end;
        this.description = description;
        this.source = source;
        this.units = units;
    }

    public ESPTimeSeries(String name, double[] dates, double[] vals) {
        this.name = name;
        this.dates = dates;
        this.vals = vals;
        this.setDates(dates);
        this.description = name;
        this.source = "unknown";
        this.units = "unknown";
    }

    @Override
    public double[] getDates() {
        return this.dates;
    }

    @Override
    public void setDates(double[] dates) {
        this.dates = dates;
        this.start = new ModelDateTime(dates[0]);
        this.end = new ModelDateTime(dates[dates.length - 1]);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ModelDateTime getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(ModelDateTime end) {
        this.end = end;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public ModelDateTime getStart() {
        return this.start;
    }

    @Override
    public void setStart(ModelDateTime start) {
        this.start = start;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(String units) {
        this.units = units;
    }

    @Override
    public double[] getVals() {
        return this.vals;
    }

    @Override
    public void setVals(double[] vals) {
        this.vals = vals;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getXmlBlock() {
        return "<TimeSeries name=\"" + this.name + "\" description=\"" + this.description + "\" source=\"" + this.source + "\" units=\"" + this.units + "\" start =\"" + this.start.getJulian() + "\" end =\"" + this.end.getJulian() + "\"/>";
    }

    @Override
    public void dump() {
        System.out.println("TimeSeries name = " + this.name);
        System.out.println("    description = " + this.description);
        System.out.println("         source = " + this.source);
        System.out.println("          units = " + this.units);
        System.out.println("          start = " + this.start);
        System.out.println("            end = " + this.end);
    }

    @Override
    public void trim(ModelDateTime start, ModelDateTime end) {
        double start_jd = start.getJulian();
        double end_jd = end.getJulian();
        int count = 0;
        for (int i = 0; i < this.dates.length; ++i) {
            if (!(this.dates[i] >= start_jd) || !(this.dates[i] <= end_jd)) continue;
            ++count;
        }
        double[] new_dates = new double[count];
        double[] new_data = new double[count];
        count = 0;
        for (int i = 0; i < this.dates.length; ++i) {
            if (!(this.dates[i] >= start_jd) || !(this.dates[i] <= end_jd)) continue;
            new_dates[count] = this.dates[i];
            new_data[count] = this.vals[i];
            ++count;
        }
        this.dates = new_dates;
        this.vals = new_data;
        this.start = new ModelDateTime(this.dates[0]);
        this.end = new ModelDateTime(this.dates[count - 1]);
    }
}

