/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.util.Arrays;

public class Stats {
    private Stats() {
    }

    public static double norm_vec(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double max(double[] vals) {
        double max = vals[0];
        for (double v : vals) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static double min(double[] vals) {
        double min = vals[0];
        for (double v : vals) {
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public static double range(double[] vals) {
        double min = vals[0];
        double max = vals[0];
        for (double v : vals) {
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        return max - min;
    }

    public static int length(double[] vals) {
        return vals.length;
    }

    public static double median(double[] vals) {
        return Stats.quantile(vals, 0.5);
    }

    public static double mean(double[] vals) {
        return Stats.sum(vals) / (double)vals.length;
    }

    public static double stddev(double[] vals) {
        double mean = Stats.mean(vals);
        double squareSum = 0.0;
        for (double v : vals) {
            squareSum += v * v;
        }
        return Math.sqrt(squareSum / (double)vals.length - mean * mean);
    }

    public static double stderr(double[] vals) {
        return Math.sqrt(Stats.variance(vals) / (double)vals.length);
    }

    public static double variance(double[] vals) {
        double stddev = Stats.stddev(vals);
        return stddev * stddev;
    }

    public static double meandev(double[] vals) {
        double mean = Stats.mean(vals);
        int size = vals.length;
        double sum = 0.0;
        int i = size;
        while (--i >= 0) {
            sum += Math.abs(vals[i] - mean);
        }
        return sum / (double)size;
    }

    public static double sum(double[] vals) {
        double sum = 0.0;
        for (double v : vals) {
            sum += v;
        }
        return sum;
    }

    public static double product(double[] vals) {
        double prod = 1.0;
        for (double v : vals) {
            prod *= v;
        }
        return prod;
    }

    public static double quantile(double[] vals, double phi) {
        if (vals.length == 0) {
            return 0.0;
        }
        double[] sortedElements = Arrays.copyOf(vals, vals.length);
        Arrays.sort(sortedElements);
        int n = sortedElements.length;
        double index = phi * (double)(n - 1);
        int lhs = (int)index;
        double delta = index - (double)lhs;
        double result = lhs == n - 1 ? sortedElements[lhs] : (1.0 - delta) * sortedElements[lhs] + delta * sortedElements[lhs + 1];
        return result;
    }

    public static double lag1(double[] vals) {
        double mean = Stats.mean(vals);
        int size = vals.length;
        double q = 0.0;
        double v = (vals[0] - mean) * (vals[0] - mean);
        for (int i = 1; i < size; ++i) {
            double delta0 = vals[i - 1] - mean;
            double delta1 = vals[i] - mean;
            q += (delta0 * delta1 - q) / (double)(i + 1);
            v += (delta1 * delta1 - v) / (double)(i + 1);
        }
        double r1 = q / v;
        return r1;
    }

    public static double rmse(double[] pred, double[] valid) {
        double error = 0.0;
        for (int i = 0; i < pred.length; ++i) {
            double diff = pred[i] - valid[i];
            error += diff * diff;
        }
        return Math.sqrt(error /= (double)pred.length);
    }

    public static double bias(double[] pred, double[] valid) {
        double sum = 0.0;
        for (int i = 0; i < pred.length; ++i) {
            sum += pred[i] - valid[i];
        }
        return sum / Stats.sum(pred);
    }

    public static double nashsut(double[] prediction, double[] validation, double pow) {
        int pre_size = prediction.length;
        int val_size = validation.length;
        int steps = 0;
        double sum_td = 0.0;
        double sum_vd = 0.0;
        if (pre_size != val_size) {
            System.err.println("Prediction data and validation data are not consistent!");
            return -9999.0;
        }
        steps = pre_size;
        for (int i = 0; i < steps; ++i) {
            sum_td += prediction[i];
            sum_vd += validation[i];
        }
        double mean_td = sum_td / (double)steps;
        double mean_vd = sum_vd / (double)steps;
        double td_vd = 0.0;
        double vd_mean = 0.0;
        for (int i = 0; i < steps; ++i) {
            td_vd += Math.pow(Math.abs(validation[i] - prediction[i]), pow);
            vd_mean += Math.pow(Math.abs(validation[i] - mean_vd), pow);
        }
        double efficiency = 1.0 - td_vd / vd_mean;
        return efficiency;
    }

    public static double nashsut_log(double[] prediction, double[] validation, double pow) {
        int i;
        int pre_size = prediction.length;
        int val_size = validation.length;
        int steps = 0;
        double sum_log_pd = 0.0;
        double sum_log_vd = 0.0;
        if (pre_size != val_size) {
            System.err.println("Prediction data and validation data are not consistent!");
            return -9999.0;
        }
        steps = pre_size;
        double[] log_preData = new double[pre_size];
        double[] log_valData = new double[val_size];
        for (i = 0; i < steps; ++i) {
            if (prediction[i] < 0.0) {
                System.err.println("Logarithmic efficiency can only be calculated for positive values!");
                return -9999.0;
            }
            if (validation[i] < 0.0) {
                System.err.println("Logarithmic efficiency can only be calculated for positive values!");
                return -9999.0;
            }
            log_preData[i] = prediction[i] == 0.0 ? 0.0 : Math.log(prediction[i]);
            log_valData[i] = validation[i] == 0.0 ? 0.0 : Math.log(validation[i]);
        }
        for (i = 0; i < steps; ++i) {
            sum_log_pd += log_preData[i];
            sum_log_vd += log_valData[i];
        }
        double mean_log_pd = sum_log_pd / (double)steps;
        double mean_log_vd = sum_log_vd / (double)steps;
        double pd_log_vd = 0.0;
        double vd_log_mean = 0.0;
        for (int i2 = 0; i2 < steps; ++i2) {
            pd_log_vd += Math.pow(Math.abs(log_valData[i2] - log_preData[i2]), pow);
            vd_log_mean += Math.pow(Math.abs(log_valData[i2] - mean_log_vd), pow);
        }
        double log_efficiency = 1.0 - pd_log_vd / vd_log_mean;
        return log_efficiency;
    }

    public static double err_sum(double[] validation, double[] prediction) {
        double volError = 0.0;
        for (int i = 0; i < prediction.length; ++i) {
            volError += prediction[i] - validation[i];
        }
        return volError;
    }

    public static double ioa(double[] prediction, double[] validation, double pow) {
        int td_size = prediction.length;
        int vd_size = validation.length;
        if (td_size != vd_size) {
            throw new IllegalArgumentException("Data sets in ioa does not match!");
        }
        int steps = td_size;
        double sum_td = 0.0;
        double sum_vd = 0.0;
        for (int i = 0; i < steps; ++i) {
            sum_td += prediction[i];
            sum_vd += validation[i];
        }
        double mean_td = sum_td / (double)steps;
        double mean_vd = sum_vd / (double)steps;
        double td_vd = 0.0;
        double vd_mean = 0.0;
        for (int i = 0; i < steps; ++i) {
            td_vd += Math.pow(Math.abs(validation[i] - prediction[i]), pow);
            vd_mean += Math.pow(Math.abs(validation[i] - mean_vd), pow);
        }
        double ad_test = 0.0;
        double ad_veri = 0.0;
        double abs_sqDevi = 0.0;
        for (int i = 0; i < steps; ++i) {
            abs_sqDevi += Math.pow(Math.abs(prediction[i] - mean_vd) + Math.abs(validation[i] - mean_vd), pow);
        }
        double ioa = 1.0 - td_vd / abs_sqDevi;
        return ioa;
    }

    private static double[] calcLinReg(double[] xData, double[] yData) {
        double sumX = 0.0;
        double sumY = 0.0;
        double prod = 0.0;
        int nstat = xData.length;
        double[] regCoef = new double[3];
        double meanYValue = Stats.mean(yData);
        double meanXValue = Stats.mean(xData);
        for (int i = 0; i < nstat; ++i) {
            sumX += (xData[i] - meanXValue) * (xData[i] - meanXValue);
            sumY += (yData[i] - meanYValue) * (yData[i] - meanYValue);
            prod += (xData[i] - meanXValue) * (yData[i] - meanYValue);
        }
        if (sumX > 0.0 && sumY > 0.0) {
            regCoef[1] = prod / sumX;
            regCoef[0] = meanYValue - regCoef[1] * meanXValue;
            regCoef[2] = Math.pow(prod / Math.sqrt(sumX * sumY), 2.0);
        }
        return regCoef;
    }

    public static double intercept(double[] xData, double[] yData) {
        return Stats.calcLinReg(xData, yData)[0];
    }

    public static double gradient(double[] xData, double[] yData) {
        return Stats.calcLinReg(xData, yData)[1];
    }

    public static double r2(double[] xData, double[] yData) {
        return Stats.calcLinReg(xData, yData)[2];
    }

    public static double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static float round(float val, int places) {
        return (float)Stats.round((double)val, places);
    }

    public static double random(double min, double max) {
        assert (max > min);
        return min + Math.random() * (max - min);
    }
}

